package dressing.ui.Assemblage;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

import dressing.ui.CountryComboSelect;
import dressing.ui.util.EditorWindow;
import param.AssemblySystemCluster;
import param.AssemblySystemsPreference;
import param.ParamFactory;
import param.cam.MachineSides;

public class AssemblySystemsPreferenceEditorWindow extends EditorWindow {

    private AssemblySystemsPreferenceController controller;
    private AssemblySystemsPreference existingPreference;

    private ComboViewer sideViewer;
    private ComboViewer clusterViewer;
    private Button applyToAllCheckbox;
	private AssemblySystemClusterComboSelect assemblySystemClusterComboSelect;
	
    public AssemblySystemsPreferenceEditorWindow(
        Shell parentShell,
        AssemblySystemsPreferenceController controller,
        AssemblySystemsPreference existingPreference,
        int mode
    ) {
        super(parentShell, mode);
        this.controller = controller;
        this.existingPreference = existingPreference;
    }

    @Override
    protected Composite createClientArea(Composite parent) {
    	getShell().setText(existingPreference == null ? "Ajouter Préférence" : "Modifier Préférence");
        Composite container = new Composite(parent, SWT.NONE);
        container.setLayout(new GridLayout(2, false));

        // Face Side
        new Label(container, SWT.NONE).setText("Face:");
        sideViewer = new ComboViewer(container, SWT.READ_ONLY);
        sideViewer.getCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        sideViewer.setContentProvider(ArrayContentProvider.getInstance());
        sideViewer.setLabelProvider(new LabelProvider());
        sideViewer.setInput(MachineSides.values());

        // Cluster
        new Label(container, SWT.NONE).setText("Assemblage: ");
        assemblySystemClusterComboSelect = new AssemblySystemClusterComboSelect(container, SWT.NONE) {
        	@Override
        	public Object getinput() {
        		List<AssemblySystemCluster> clusters=controller.getClusters();
        		if(existingPreference.getLocalAssemblySystem()!=null && !clusters.contains(existingPreference.getLocalAssemblySystem())) {
        			clusters.add(existingPreference.getLocalAssemblySystem());
        		}
        		return clusters;
        	}
        	@Override
        	public void Modify() {
        		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
        		if(selection!=null && selection instanceof AssemblySystemCluster) {
        			AssemblySystemCluster cluster=(AssemblySystemCluster) selection;
        			if(!cluster.equals(existingPreference.getLocalAssemblySystem())) {
        				cluster = EcoreUtil.copy(cluster);
        				existingPreference.setLocalAssemblySystem(cluster);
        			}
        			AssemblySystemClusterEditorWindow assemblyClusterEditorWindow = new AssemblySystemClusterEditorWindow(getShell(),cluster,EditorWindow.update);
        			assemblyClusterEditorWindow.create();
        			int ret=assemblyClusterEditorWindow.open();
        			if(ret==Window.OK) {
        				refresh();
        				StructuredSelection selectedcluster=new StructuredSelection(cluster);
        				getComboViewer().setSelection(selectedcluster);
        				
        			}
        		}
        		
        	}
        };
        assemblySystemClusterComboSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		clusterViewer = assemblySystemClusterComboSelect.getComboViewer();
//        clusterViewer = new ComboViewer(container, SWT.READ_ONLY);
        clusterViewer.getCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
//        clusterViewer.setContentProvider(ArrayContentProvider.getInstance());
//        clusterViewer.setLabelProvider(new LabelProvider() {
//            @Override
//            public String getText(Object element) {
//                return element instanceof AssemblySystemCluster ? ((AssemblySystemCluster) element).getName() : super.getText(element);
//            }
//        });
//        clusterViewer.setInput(controller.getClusters());

        // Apply to All Sides
        new Label(container, SWT.NONE).setText("Appliquer tous Faces: ");
        applyToAllCheckbox = new Button(container, SWT.CHECK);

        // Populate if editing
        if (existingPreference != null) {
            // Set face side
            if (existingPreference.getFaceSide() != null) {
            	sideViewer.setSelection(new StructuredSelection(existingPreference.getFaceSide()));
            }
            // Set cluster
            if (existingPreference.getAssemblySystem() != null) {
            	clusterViewer.setSelection(new StructuredSelection(existingPreference.getAssemblySystem()));
            }
            // Set all sides checkbox
            applyToAllCheckbox.setSelection(existingPreference.isAllSides());
        }else {
        	sideViewer.setSelection(new StructuredSelection(MachineSides.FACE));

             if (!controller.getClusters().isEmpty()) {
            	 clusterViewer.setSelection(new StructuredSelection(controller.getClusters().get(0)));
             }
        }

        return container;
    }

    @Override
    public boolean check() {
        if (sideViewer.getStructuredSelection().isEmpty() || clusterViewer.getStructuredSelection().isEmpty()) {
            this.errorMessage = "Please select both a face side and an assembly cluster.";
            return false;
        }
        return true;
    }

    @Override
    protected void cancel() {
        // No special cancel logic needed
    }

    @Override
    public boolean terminer() {
        if (!super.terminer()) {
            return false;
        }

        MachineSides selectedSide = (MachineSides) sideViewer.getStructuredSelection().getFirstElement();
        AssemblySystemCluster selectedCluster = (AssemblySystemCluster) clusterViewer.getStructuredSelection().getFirstElement();
        boolean applyToAll = applyToAllCheckbox.getSelection();

        AssemblySystemsPreference newPref = existingPreference != null
            ? existingPreference
            : ParamFactory.eINSTANCE.createAssemblySystemsPreference();

        newPref.setFaceSide(selectedSide);
        newPref.setAllSides(applyToAll);
        newPref.setAssemblySystem(selectedCluster);

        controller.addOrUpdatePreference(newPref);
        finish();
        return true;
    }
    @Override
	protected Point getInitialSize() {
		
		return new Point(720, 300);
	}

	@Override
	protected boolean isMaximized() {
		return false;
	}
}
