package dressing.ui.Assemblage;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.AssemblySystemCluster;
import param.ParamFactory;

public class AssemblySystemClusterListWindow extends ListEditorWindow {

	public AssemblySystemClusterListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des chants");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof AssemblySystemCluster ) {
					return ((AssemblySystemCluster)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));

	}
	@Override
	protected void Add() {
		AssemblySystemCluster cluster=ParamFactory.eINSTANCE.createAssemblySystemCluster();
		cluster.setName("");
		AssemblySystemClusterEditorWindow assemblyClusterEditorWindow = new AssemblySystemClusterEditorWindow(getShell(),cluster,EditorWindow.create);
		assemblyClusterEditorWindow.create();
		int ret=assemblyClusterEditorWindow.open();
		if(ret==Window.OK) {
			tableViewer.refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof AssemblySystemCluster) {
			AssemblySystemClusterEditorWindow mechanicDesignWindow = new AssemblySystemClusterEditorWindow(shell,(AssemblySystemCluster) selection.getFirstElement(),EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				tableViewer.refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof AssemblySystemCluster) {
						ResourceManagers.getIntance().getApplication().getAssemblySystems().getAssemblyClusters().remove(obj);
						ResourceManagers.getIntance().saveApplication();
					}
				}
				tableViewer.refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof AssemblySystemCluster) {
			AssemblySystemClusterEditorWindow mechanicDesignWindow = new AssemblySystemClusterEditorWindow(shell,(AssemblySystemCluster) selection.getFirstElement(),EditorWindow.View);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getApplication().getAssemblySystems().getAssemblyClusters();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
