package dressing.ui.Assemblage;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.Assembly;
import param.Chant;
import param.MechanicPublicParam;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;

import dressing.ui.DoubleTextFieldFactory;
import dressing.ui.PublicParamEditorComposite;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.NumericConvertor;

public class AssemblyEditorWindow extends EditorWindow {
	private Assembly assembly;
	private Assembly assemblyOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtLongeur;
	private Text txtHauteur;
	private Text txtProfondeur;
	protected Map<MechanicPublicParam,PublicParamEditorComposite> dirtyParams = new HashMap<MechanicPublicParam,PublicParamEditorComposite>();
	protected Map<MechanicPublicParam,PublicParamEditorComposite> ParamsCompositeMap = new HashMap<MechanicPublicParam,PublicParamEditorComposite>();

	public AssemblyEditorWindow(Shell parentShell,Assembly chant,int update) {
		super(parentShell,update);	
		this.assembly=chant;
		this.assemblyOrigin=EcoreUtil.copy(chant);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Longueur");
		
		txtLongeur = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		Label lblPrice = new Label(clientArea, SWT.NONE);
		lblPrice.setText("Hauteur");
		txtHauteur = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtHauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		Label lblProfondeur = new Label(clientArea, SWT.NONE);
		lblProfondeur.setText("Profondeur");
		txtProfondeur = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtProfondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		
		for(MechanicPublicParam param:assembly.getUsinage().getPublicparamgroup().getMechanicpublicparam()) {
			if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty() && param.getDefaultvalue().contains("@")) {
				continue;
			}
			PublicParamEditorComposite paramEditor=new PublicParamEditorComposite(clientArea, SWT.NONE, param,dirtyParams,true); 
			ParamsCompositeMap.put(param, paramEditor);
		}
		this.shell.setText("Editeur Assemblage");
		parent.requestLayout();

		if(assembly!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();

		this.assembly.setName(originName);
		for(MechanicPublicParam param:dirtyParams.keySet()) {
			dirtyParams.get(param).updateValues();
		}
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getApplication().getAssemblies().getAssemblies().add(assembly);
		}
		ResourceManagers.getIntance().saveLibraryResource();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.assembly.setName(this.assemblyOrigin.getName());
		this.assembly.setLength(this.assemblyOrigin.getLength());
		this.assembly.setWidth(this.assemblyOrigin.getWidth());
		this.assembly.setDepth(this.assemblyOrigin.getDepth());


	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String ep=txtLongeur.getText();
		try {
			Double dep =Double.valueOf(ep);
			if(dep<=0) {
				errorExist=true;
				errorMessage="L'épaisseur doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="L'épaisseur est obligatoire";
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = BeanProperties.value("name").observe(assembly);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxtEpObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtLongeur);
		IObservableValue epaisseurChantObserveValue = BeanProperties.value("width").observe(assembly);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtEpObserveWidget, epaisseurChantObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtpriceObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtHauteur);
		IObservableValue priceChantObserveValue = BeanProperties.value("length").observe(assembly);
		UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
		strategy_2.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
		strategy_3.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtpriceObserveWidget, priceChantObserveValue, strategy_2, strategy_3);
		//
		//
		IObservableValue observeTextTxtDepthObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtProfondeur);
		IObservableValue depthAssemblyObserveValue = BeanProperties.value("depth").observe(assembly);
		UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
		strategy_4.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
		strategy_5.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtDepthObserveWidget, depthAssemblyObserveValue, strategy_4, strategy_5);
		//
		return bindingContext;
	}
}
