package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignAssemblyManager;
import dressing.model.MechanicDesignCreator;
import dressing.model.MechanicDesignMaterialsHelper;
import dressing.model.Space3D;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageLoaderCache;
import param.Catalog;
import param.DesignClassGroup;
import param.DesignClasse;
import param.DesignInstance;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.ModelRoot;
import param.PieceType;

import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.eclipse.core.databinding.DataBindingContext;
import dressing.ui.palette.PaletteGroup;
import dressing.ui.palette.PaletteItem;
import dressing.ui.palette.PaletteProject;

import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.custom.ScrolledComposite;

public class ApplicationEditorWindow extends EditorWindow {

	private DesignObject3D parent;

	Composite parentComposite;
	private Composite clientArea;

	private Composite buttonControlBar;

	private Button btnBack;

	private Button btnUp;

	private Composite grid;
	private ConcurrentLinkedQueue<PaletteGroup> previousGroup = new ConcurrentLinkedQueue<PaletteGroup>();
	private MechanicDesign design;
	private PaletteGroup parentGroup;

	private Label lblNameRoot;
	private ScrolledComposite scrolledComposite;
	private Composite composite;

	private PaletteProject palette;

	public ApplicationEditorWindow(Shell parentShell, DesignObject3D parent) {
		super(parentShell, EditorWindow.executeAction);
		this.parent = parent;
		palette = createPaletteProject();
	}
	@Override
	public int open() {
		if(palette.getPaletteItems().isEmpty()) {
			finish();
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					MessageDialog.openError(getParentShell(),"Aucun Applicable", "Il n'y a aucun composant applicable à :"+parent.getName());
				}
			});
			return CANCEL;
		}else {
			return super.open();
		}
		
	}
	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite = parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(1, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		scrolledComposite = new ScrolledComposite(clientArea, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);

		composite = new Composite(scrolledComposite, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		buttonControlBar = new Composite(composite, SWT.NONE);
		buttonControlBar.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		GridLayout gl_buttonControlBar = new GridLayout(3, false);
		gl_buttonControlBar.marginHeight = 2;
		gl_buttonControlBar.verticalSpacing = 0;
		buttonControlBar.setLayout(gl_buttonControlBar);
		//
		SelectionListener listener2 = new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if (previousGroup != null && previousGroup.peek() != null) {
					//
					grid.dispose();
					PaletteGroup group = previousGroup.poll();
					previousGroup.add(parentGroup);
					configure(clientArea, group);
					scrolledComposite.pack(true);
					scrolledComposite.requestLayout();
					scrolledComposite.layout(true);
					scrolledComposite.redraw();
					composite.pack(true);
					composite.requestLayout();
					composite.layout(true);
					composite.redraw();
				}

			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		};
		SelectionListener listener = new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if (parentGroup != null && parentGroup.getParent() != null) {
					//
					grid.dispose();
					previousGroup.add(parentGroup);
					configure(composite, parentGroup.getParent());
					scrolledComposite.pack(true);
					scrolledComposite.requestLayout();
					scrolledComposite.layout(true);
					scrolledComposite.redraw();
					composite.pack(true);
					composite.requestLayout();
					composite.layout(true);
					composite.redraw();
				}

			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		};
		btnBack = new Button(buttonControlBar, SWT.NONE);
		btnBack.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		btnBack.setImage(ResourceManager.getPluginImage("Dressing", "icons/icons8-left-16.png"));

		btnUp = new Button(buttonControlBar, SWT.NONE);
		btnUp.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		btnUp.setImage(ResourceManager.getPluginImage("Dressing", "icons/icons8-up-16.png"));
		btnBack.addSelectionListener(listener2);
		btnUp.addSelectionListener(listener);

		lblNameRoot = new Label(buttonControlBar, SWT.NONE);
		lblNameRoot.setText("Name");
		lblNameRoot.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		scrolledComposite.setContent(composite);
		scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		
		configure(composite, palette);
		shell.addControlListener(new ControlAdapter() {
			@Override
			public void controlResized(ControlEvent e) {
				// TODO Auto-generated method stub
				super.controlResized(e);
				clientArea.requestLayout();
				shell.layout(true);
				shell.redraw();
			}
		});
		this.shell.setText("Editeur");
		parent.requestLayout();

		return clientArea;
	}

	public Button createChildControl(Composite parent, String label, PaletteItem item, PaletteGroup group, int color) {
		Composite cellItem_1 = new Composite(parent, SWT.NONE);
		RowLayout rl_cellItem_1 = new RowLayout(SWT.VERTICAL);
		rl_cellItem_1.fill = true;
		cellItem_1.setLayout(rl_cellItem_1);

		Button result = new Button(cellItem_1, SWT.NONE);
		result.setLayoutData(new RowData(SWT.DEFAULT, SWT.DEFAULT));
		result.setBackground(getSystemColor(color));
		Label lbl = new Label(cellItem_1, SWT.NONE);
		lbl.setText(label);
		lbl.setAlignment(SWT.CENTER);

		if (item != null) {
			if (item.getImage() != null) {
				result.setImage(getimage(item.getImage(), 200, 200));
			} else if (item.getPreviewImage() != null) {
				result.setImage(getimage(item.getPreviewImage(), 200, 200));
			}
			result.addListener(SWT.MouseDoubleClick, new Listener() {

				@Override
				public void handleEvent(Event event) {
					if (item.getData() instanceof MechanicDesign) {
						design = (MechanicDesign) item.getData();
					}
					if (item.getData() instanceof DesignInstance) {
						design = ((DesignInstance) item.getData()).getDesign();
					}
					terminer();

				}
			});
			;
			result.addListener(SWT.MouseDown, new Listener() {

				@Override
				public void handleEvent(Event event) {
					if (item.getData() instanceof MechanicDesign) {
						design = (MechanicDesign) item.getData();
					}
					if (item.getData() instanceof DesignInstance) {
						design = ((DesignInstance) item.getData()).getDesign();
					}

				}
			});
			;
		}
		if (group != null) {
			if (group.getImage() != null) {
				result.setImage(getimage(group.getImage(), 100, 100));
			}

			result.addListener(SWT.MouseDoubleClick, new Listener() {

				@Override
				public void handleEvent(Event event) {
					grid.dispose();
					previousGroup.add(parentGroup);
					configure(composite, group);
					clientArea.requestLayout();
					scrolledComposite.pack(true);
					scrolledComposite.requestLayout();
					scrolledComposite.layout(true);
					scrolledComposite.redraw();
					composite.pack(true);
					composite.requestLayout();
					composite.layout(true);
					composite.redraw();
				}
			});
			;
		}

		return result;
	}

	private void configure(Composite parent, PaletteGroup group) {
		grid = new Composite(parent, SWT.NONE);
		grid.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		RowLayout rl_grid = new RowLayout(SWT.HORIZONTAL);
		rl_grid.fill = true;
		grid.setLayout(rl_grid);
		new ParentHandler(grid);
		if (group.getName() != null && !group.getName().isEmpty()) {
			lblNameRoot.setText(group.getName());
		} else {
			lblNameRoot.setText("Bibliothèque");
		}

		parentGroup = group;
		for (PaletteItem item : group.getItems()) {
			Button lbl = createChildControl(grid, item.getName(), item, null, SWT.COLOR_WHITE);
		}
		for (PaletteGroup item : group.getPalettegroupes()) {
			Button lbl = createChildControl(grid, item.getName(), null, item, SWT.COLOR_WHITE);

		}
	}

	public Image getimage(String path, int width, int height) {
		if (path != null) {
			File image = new File(path);
			if (image.exists()) {
				return ImageLoaderCache.getInstance().loadImage(path, width, height);
			}
		}
		return null;
	}

	public static Color getSystemColor(int colorIndex) {
		return Display.getCurrent().getSystemColor(colorIndex);
	}

	public PaletteProject createPaletteProject() {
		PaletteProject palette = new PaletteProject();

		List<ModelRoot> roots = ResourceManagers.getIntance().getModelroots();
		for(ModelRoot root:roots) {
		
			DesignClassGroup classes = root.getClasses();
			if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
				for (DesignClasse classe : classes.getDesignClasse()) {
					PaletteGroup grp2 = new PaletteGroup(classe.getName()+"("+root.getName()+")");
					grp2.setData(classe);
					grp2.setModifiable(false);
					grp2.setDeletable(false);
					if (classe.getCategorie() != null && classe.getCategorie().size() > 0) {
						for (MechanicDesignGroup famille : classe.getCategorie()) {
							if (famille != null && famille.getMechanicdesign() != null) {
								createGroupFromDesignGroup(grp2, famille);
							}
						}
					}
					if (!grp2.getPalettegroupes().isEmpty()) {
						if (classe.getPerviewPath() != null && !classe.getPerviewPath().isEmpty()) {
							grp2.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + classe.getPerviewPath());
						} else {
							String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator
									+ "icons8-folder-100.png";
							grp2.setImage(imagePath);
	
						}
						palette.getPalettegroupes().add(grp2);
						grp2.setParent(palette);
					}
				}
	
			}
		}
		for (Catalog cat : ResourceManagers.getIntance().getCatalogs()) {
			PaletteGroup grp2 = new PaletteGroup(cat.getName() + "(" + cat.getOwner() + ")");
			grp2.setData(cat);
			grp2.setModifiable(true);
			grp2.setDeletable(true);
			if (cat.getCategorie() != null && !cat.getCategorie().isEmpty()) {
				for (MechanicDesignGroup famille : cat.getCategorie()) {
					if (famille != null && famille.getMechanicdesign() != null) {
						createGroupFromDesignGroup(grp2, famille);
					}
				}
			}
			if (!grp2.getPalettegroupes().isEmpty()) {
				if (cat.getPerviewPath() != null && !cat.getPerviewPath().isEmpty()) {
					grp2.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + cat.getPerviewPath());
				} else {
					String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator + "icons8-folder-100.png";
					grp2.setImage(imagePath);

				}
				palette.getPalettegroupes().add(grp2);
				grp2.setParent(palette);
			}
		}
		return palette;
	}

	/**
	 * @param parent
	 * @param famille
	 */
	private void createGroupFromDesignGroup(PaletteGroup parent, MechanicDesignGroup famille) {
		boolean isapplyToSpace=this.parent instanceof Space3D;
		PaletteGroup grp3 = new PaletteGroup(famille.getName());
		grp3.setData(famille);
		for (MechanicDesign design : famille.getMechanicdesign()) {
			if( isapplyToSpace && !design.getType().equals(PieceType.OBSTACLE) ) {
				continue;
			}
			if (design != null && design.isApplicable()) {
				createItemFromDesign(grp3, design);
			}
		}
		for (DesignInstance design : famille.getDesignsintances()) {
			if( isapplyToSpace && !design.isObstacle() ) {
				continue;
			}
			if (design != null && design.isApplicable()) {
				createItemFromDesignInstance(grp3, design);
			}
		}
		if (!grp3.getPaletteItems().isEmpty()) {
			if (famille.getPerviewPath() != null && !famille.getPerviewPath().isEmpty()) {
				grp3.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + famille.getPerviewPath());
			} else {
				String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator + "icons8-folder-100.png";
				grp3.setImage(imagePath);

			}
			parent.getPalettegroupes().add(grp3);
			grp3.setParent(parent);
		}
	}

	/**
	 * @param parent
	 * @param design
	 */
	private void createItemFromDesignInstance(PaletteGroup parent, DesignInstance design) {
		PaletteItem p = new PaletteItem(design.getName());
		p.setData(design);
		parent.getItems().add(p);
		p.setParent(parent);
		if (design.getPerviewPath() != null && !design.getPerviewPath().isEmpty()) {
			p.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + design.getPerviewPath());
		} else {
			String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator + "icons8-folder-100.png";
			p.setImage(imagePath);
		}
	}

	/**
	 * @param parent
	 * @param design
	 * @return
	 */
	private PaletteItem createItemFromDesign(PaletteGroup parent, MechanicDesign design) {
		PaletteItem p = new PaletteItem(design.getName());
		p.setData(design);
		parent.getItems().add(p);
		p.setParent(parent);
		if (design.getPreviewImagePath() != null && design.getPreviewImagePath() != null) {
			p.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + design.getPreviewImagePath());
		} else {
			p.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + "cube-64.png");
		}
		return p;
	}

	@Override
	public boolean terminer() {
		if (!super.terminer()) {
			return false;
		}

		try {
			if (design != null && parent!=null) {
				Display.getDefault().asyncExec(new Runnable() {

					@Override
					public void run() {
						// TODO Auto-generated method stub
						MechanicDesign copy = EcoreUtil.copy(design);
						try {
							MechanicDesignCreator.getInstance().syncParamsFromParentDesign(copy, parent);
						} catch (Exception e) {
							SuperCadMessageDialog.openMessage(MessageDialog.ERROR, getShell(), "Une erreur dans la synchronisation avec Parent", e.getMessage());
							e.printStackTrace();
						}
						MechaincDesignEditorWindow mechanicDesignWindow = new MechaincDesignEditorWindow(
								ApplicationEditorWindow.this.getParentShell(), copy, false, null, parent, null, null,
								true, MechanicDesignCreator.create);
						mechanicDesignWindow.create();
						mechanicDesignWindow.open();
					}
				});

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		finish();
		return true;
	}

	@Override
	protected void cancel() {

	}

	@Override
	public boolean check() {
		errorExist = false;
		errorMessage = "";
		return !errorExist;
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		return bindingContext;
	}

	@Override
	protected Point getInitialSize() {
		return new Point(720, 600);
	}
	
	@Override
	protected boolean isMaximized() {
		return false;
	}

}
