package dressing.model;

import java.util.ArrayList;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import param.Material;
import param.MechanicDressing;
import param.MechanicPublicParam;
import param.PieceType;
import param.PublicParamGroup;
import utils.EmfUtils;


public class Space3DFree extends Space3D {
	
	protected  ArrayList<ModelAccessoire> accessoires = new ArrayList<ModelAccessoire>();
	protected  ArrayList<ModelQuincaillerie> quincailleries = new ArrayList<ModelQuincaillerie>();

	public ArrayList<ModelAccessoire> getAccessoires() {
		if(accessoires==null) {
			accessoires=new ArrayList<ModelAccessoire>();
		}
		return accessoires;
	}

	public void setAccessoires(ArrayList<ModelAccessoire> accessoires) {
		this.accessoires = accessoires;
	}

	public ArrayList<ModelQuincaillerie> getQuincailleries() {
		if(quincailleries==null) {
			quincailleries=new ArrayList<ModelQuincaillerie>();
		}
		return quincailleries;
	}

	public void setQuincailleries(ArrayList<ModelQuincaillerie> quincailleries) {
		this.quincailleries = quincailleries;
	}

	public void addAccessoire(ModelAccessoire accessoire) {
		if(accessoires!=null && accessoire!=null)
		{
			ModelAccessoire accessoireold=null;
			for(ModelAccessoire access:accessoires) {
				if(access.getAccessoire().getAccessoire().equals(accessoire.getAccessoire().getAccessoire())) {
					accessoireold=access;
					break;
				}
			}
			if(accessoireold!=null) {
				accessoireold.setNumber(accessoireold.getNumber()+accessoire.getNumber());
			}else {
				accessoires.add(accessoire);
			}
		}
	}
	public void addQuincaillerie(ModelQuincaillerie quincaillerie) {
		if(quincailleries!=null && quincaillerie!=null)
		{
			ModelQuincaillerie quincaillerieold=null;
			for(ModelQuincaillerie access:quincailleries) {
				if(access.getQuincaillerie().getQuincaillerie().equals(quincaillerie.getQuincaillerie().getQuincaillerie())) {
					quincaillerieold=access;
					break;
				}
			}
			if(quincaillerieold!=null) {
				quincaillerieold.setNumber(quincaillerieold.getNumber()+quincaillerie.getNumber());
			}else {
				quincailleries.add(quincaillerie);
			}
		}
	}

	@Override
	public DesignObject3D getRoot() {
		if(getMechanicDesignDefinition()!=null && (getMechanicDesignDefinition() instanceof MechanicDressing || getMechanicDesignDefinition().getType().equals(PieceType.DRESSING))) {
			return this;
		}
		if(getParentdesign()==null && getMechanicDesignDefinition()!=null && 
				(getMechanicDesignDefinition().getType().equals(PieceType.SPACE3D)|| getMechanicDesignDefinition().getType().equals(PieceType.CAISSON))) {
			return this;
		}
		return super.getRoot();
	}
	
	public boolean isfacade() {
		try {
			if(getMechanicDesignDefinition() !=null) {
				MechanicPublicParam param=getMechanicDesignDefinition().getPublicParam("Piece_Type");
				if(param!=null && param.getTypedefelement()!=null&&param.getKey()!=null && param.getTypedefelement().getKey().contains("FACADE")) {
					return true;
				}else {
					return false;
				}
			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		return false;

	}

	public DesignObject3D update() throws Exception {

		PublicParamGroup publicparams = this.mechanicDesignDefinition.getPublicparamgroup();

		MechanicPublicParam ep = publicparams.getParam("global.ep");
		MechanicPublicParam epback = publicparams.getParam("global.epback");
		MechanicPublicParam epface = publicparams.getParam("global.epface");

		ep.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getPrincipalmaterial().getEpaisseur()));
		epback.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getSecondmaterial().getEpaisseur()));
		epface.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getFacadeMaterial().getEpaisseur()));

		DesignObject3D parent = this.getParentdesign();
		clearautomatique(false);
		MechanicDesignCreator.getInstance().constructObject(parent, this,
				this.mechanicDesignDefinition, MechanicDesignCreator.update);

		return this;
	}
	
	public void updateMaterials() throws Exception {
		Material principal = mechanicDesignDefinition.getPrincipalmaterial();
		Material secondary = mechanicDesignDefinition.getSecondmaterial();
		Material facade = mechanicDesignDefinition.getFacadeMaterial();

		double currentEp = principal != null ? principal.getEpaisseur() : 0.0;
	    double currentEpBack = secondary != null ? secondary.getEpaisseur() : 0.0;
	    double currentEpFace = facade != null ? facade.getEpaisseur() : 0.0;
	    
		PublicParamGroup publicParams = mechanicDesignDefinition.getPublicparamgroup();

		double defaultEp = EmfUtils.safeParseParam(publicParams, "global.ep",currentEp);
		double defaultEpBack = EmfUtils.safeParseParam(publicParams, "global.epback",currentEpBack);
		double defaultEpFace = EmfUtils.safeParseParam(publicParams, "global.epface",currentEpFace);

		boolean hasChanged = Double.compare(currentEp, defaultEp) != 0
				|| Double.compare(currentEpBack, defaultEpBack) != 0
				|| Double.compare(currentEpFace, defaultEpFace) != 0;

		if (hasChanged) {
			update(); // assumes this updates all affected pieces
		} else {
			for (Piece2D piece : getListPieces()) {
				MechanicDesignMaterialsHelper.updateDesignElement(mechanicDesignDefinition,
						piece.getMechanicDesignElementDefinition(), piece);
			}
		}
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Space3DFree [name=");
		builder.append(name);
		builder.append(", longeurext=");
		builder.append(longeurext);
		builder.append(", profondeurext=");
		builder.append(profondeurext);
		builder.append(", hauteurext=");
		builder.append(hauteurext);	
		builder.append(", longeurint=");
		builder.append(longeurint);
		builder.append(", hauteurint=");
		builder.append(hauteurint);
		builder.append(", profondeurint=");
		builder.append(profondeurint);
		builder.append(", basematerial=");
		builder.append(basematerial);
		builder.append(", backmaterial=");
		builder.append(backmaterial);
		builder.append(", facadeMaterial=");
		builder.append(facadeMaterial);
		builder.append(", xpos=");
		builder.append(xpos);
		builder.append(", ypos=");
		builder.append(ypos);
		builder.append(", zpos=");
		builder.append(zpos);
		builder.append(", visible=");
		builder.append(visible);
		builder.append(", selected=");
		builder.append(selected);
		builder.append(", parentdesign=");
		builder.append(parentdesign!=null ?parentdesign.getName():"");
		builder.append("]");
		return builder.toString();
	}
	
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
		if(accessoires!=null)accessoires.clear();
		if(quincailleries!=null)quincailleries.clear();
		accessoires=null;
		quincailleries=null;
	}
}


