package dressing.model;

import java.util.ArrayList;
import java.util.List;
import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.controller.DependenceResponsibilityCenter;
import dressing.model.types.PieceType;
import param.Material;

public class Space3D extends DesignObject3D {
	protected double longeurint;
	protected double profondeurint;
	protected double hauteurint;
	protected Material basematerial=null;
	protected Material backmaterial=null;
	protected Material facadeMaterial=null;
	
	protected DependenceResponsibilityCenter dependenceController=new DependenceResponsibilityCenter(this);

	public double getLongeurint() {
		return longeurint;
	}
	public void setLongeurint(double longeurint) {
	
		double oldValue = this.longeurint;
		this.longeurint = longeurint;
		firePropertyChange("longeurint", oldValue, longeurint);
	}
	public double getProfondeurint() {
		return profondeurint;
	}
	public void setProfondeurint(double profondeurint) {
	
		double oldValue = this.profondeurint;
		this.profondeurint = profondeurint;
		firePropertyChange("profondeurint", oldValue, profondeurint);
	}
	public double getHauteurint() {
		return hauteurint;
	}
	public void setHauteurint(double hauteurint) {
	
		double oldValue = this.hauteurint;
		this.hauteurint = hauteurint;
		firePropertyChange("hauteurint", oldValue, hauteurint);
	}
	
	public Material getBasematerial() {
		return basematerial;
	}
	public void setBasematerial(Material basematerial) {
	
		Material oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}
	public Material getBackmaterial() {
		return backmaterial;
	}
	public void setBackmaterial(Material backmaterial) {
	
		Material oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}
	
	public Material getFacadeMaterial() {
		return facadeMaterial;
	}
	
	public void setFacadeMaterial(Material facadeMaterial) {
		Material oldValue = this.facadeMaterial;
		this.facadeMaterial = facadeMaterial;
		firePropertyChange("facadeMaterial", oldValue, facadeMaterial);
	}

	@Override
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException {
		super.updateproperties(equations);
		setNotificationon(false);
		Equation eq = null;
		try {
			if (equations != null) {
				eq = Equation.FIND_EQUATION(EngineKeys.HauteurInt, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setHauteurint(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException(EngineKeys.HauteurInt + " not found to update");
				}
				eq = Equation.FIND_EQUATION(EngineKeys.longeurInt, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setLongeurint(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException(EngineKeys.longeurInt + " not found to update");
				}
				eq = Equation.FIND_EQUATION(EngineKeys.profondeurInt, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setProfondeurint(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException(EngineKeys.profondeurInt + " not found to update");
				}
			}

		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		} finally {
			setNotificationon(true);
		}
	}

	public double gettransparency() {
		return 0.0;
	}
	
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		return true;
	}
	
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean ishasdos() {
		for (DesignObject3D piece : getChilds()) {
			if (piece instanceof Piece2D && ((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
				return true;
			}
		}
		return false;

 }
 
 @Override
public boolean isDirectlyDelatable() {
	if(getMechanicDesignDefinition()!=null&& !getMechanicDesignDefinition().isDeleteable()) {
		return false;
	}
	return super.isDirectlyDelatable();
	}
/**
 * Le this est le grand espace
 * 
 * @param le sous espace contenue
 * @return
 */
public boolean contains(DesignObject3D o) {
	// TODO Auto-generated method stub
	if(o.getXPosABS()>= this.getXPosABS()
	   && 	o.getYPosABS()>= this.getYPosABS()
	   && 	o.getZPosABS()>= this.getZPosABS())
	{
		
		
		if(o.getXPosABS() + o.getXSize() <= this.getXPosABS() + this.getXSize() 
			&& o.getYPosABS() + o.getYSize() <= this.getYPosABS() + this.getYSize() 
			&& o.getZPosABS() + o.getZSize() <= this.getZPosABS() + this.getZSize() )
		{
			return true;
		}
	}
	
	
	return false;
}

	/**
	 * chercher pour le caisson root , si cette espace un caisson on vas la retourner,
	 * si ce espace est un cuisine ou dressing on retourner null car ces composant de haut degrer et impossible ces objet peut etre contenue 
	 * dans un caisson 
	 * sinon on chercher pour les caison dans le parent et ce parent ... 
	 * @return root caisson
	 */
	public DesignObject3D getRootCaisson() {
		
		if(this instanceof Space3DFree && getMechanicDesignDefinition()!=null) {
			return this;
		}
		DesignObject3D parent= this.getParentdesign();
		if(parent == null) {
			return this;
		}
		while(parent!= null && !(parent instanceof Space3DFree)) {
			parent=parent.getParentdesign();
		}
		return parent;
		
		
	}

	/**
	 * supprimer les usinages et les accessoire 
	 * @throws Exception 
	 */
	@Override
	public void deleteUsinage() throws Exception {
		List<DesignObject3D>childstobeDeleted =new ArrayList<DesignObject3D>();
		
		//collecter les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:getChilds()) {
			
			if((design instanceof Usinage)|| (design instanceof Accessoire)) {
				childstobeDeleted.add(design);
			}
		}			
		//supprimer tout les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:childstobeDeleted) {	
			
			deletechild(design,true);
		}
		
		super.deleteUsinage();
	}
	
	@Override
	public ArrayList<Couple> getSystemEquationAsParent() {
		// TODO Auto-generated method stub
		ArrayList<Couple> systemesequationsasparent=new ArrayList<Couple>();
		systemesequationsasparent.add(new Couple(EngineKeys.parentLongeurExt, ""+getLongeurext()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentProfondeurExt, ""+getProfondeurext()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentHauteureExt, ""+getHauteurext()));
		
		systemesequationsasparent.add(new Couple(EngineKeys.parentLongeurint, ""+getLongeurint()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentProfondeurint, ""+getProfondeurint()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentHauteureint, ""+getHauteurint()));
		
		systemesequationsasparent.add(new Couple(EngineKeys.parentEpaisseurSecondaire, ""+getBackmaterial().getEpaisseur()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentEpaisseurPrincipale, ""+getBasematerial().getEpaisseur()));

		systemesequationsasparent.add(new Couple(EngineKeys.parentposx, ""+getXpos()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentposy, ""+getYpos()));
		systemesequationsasparent.add(new Couple(EngineKeys.parentposz, ""+getZpos()));
		

		return systemesequationsasparent;
 	}
	
	public DependenceResponsibilityCenter getDependenceController() {
		return dependenceController;
	}
	public void setDependenceController(DependenceResponsibilityCenter dependenceController) {
		this.dependenceController = dependenceController;
	}

	@Override
	public DesignObject3D getRootModule() {
		if(getMechanicDesignDefinition()!=null 
				&& (getMechanicDesignDefinition().getType().equals(param.PieceType.SPACE3D) ||getMechanicDesignDefinition().getType().equals(param.PieceType.DRESSING)||getMechanicDesignDefinition().getType().equals(param.PieceType.CAISSON)  )
				&& getMechanicDesignDefinition().getChainOfResponsabilityController()!=null) {
			return this;
		}
		return super.getRootModule();
	}

	@Override
	public DesignObject3D getRoot() { 
		if(getParentdesign()==null && getMechanicDesignDefinition()!=null 
				&& (getMechanicDesignDefinition().getType().equals(param.PieceType.DRESSING) 
						|| getMechanicDesignDefinition().getType().equals(param.PieceType.CAISSON)
						|| getMechanicDesignDefinition().getType().equals(param.PieceType.SPACE3D))) {
			return this;
		}
		return super.getRoot();
	}
	
}
