package dressing.model;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;

import dressing.config.persistence.ResourceManagers;
import param.Chant;
import param.ChantGroup;
import param.DesignElementChantGroup;
import param.DesignMaterialType;
import param.Material;
import param.MaterialType;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPublicParam;
import param.ParamFactory;
import param.PublicParamGroup;
import param.impl.ParamFactoryImpl;

public class MechanicDesignMaterialsHelper {
	
	public static void ubdateChildsMaterial(MechanicDesign mechanicdesign) {
		if(mechanicdesign!=null && mechanicdesign.getMechanicdesign()!=null && !mechanicdesign.getMechanicdesign().isEmpty()) {
			for(MechanicDesign child :mechanicdesign.getMechanicdesign())
			{
				updateMaterialFromParentDesign(mechanicdesign, child);
			}
		}
		
	}
	
	public static void  updateMaterialFromParentDesign(MechanicDesign parentDesign, MechanicDesign mechanicdesign) {
		if(parentDesign.getFacadeMaterialType()!=null &&(!mechanicdesign.isFacadeMaterialFree() || mechanicdesign.getFacadeMaterialType()==null) ) {
			mechanicdesign.setFacadeMaterialType(EcoreUtil.copy(parentDesign.getFacadeMaterialType()));
		}
		if(parentDesign.getPrincipalMaterialType()!=null  && (!mechanicdesign.isPrincipalMaterialFree() || mechanicdesign.getPrincipalMaterialType()==null)) {
			mechanicdesign.setPrincipalMaterialType(EcoreUtil.copy(parentDesign.getPrincipalMaterialType()));
		}
		if(parentDesign.getSecondMaterialType()!=null && (!mechanicdesign.isSecondMaterialFree() || mechanicdesign.getSecondMaterialType()==null)) {
			mechanicdesign.setSecondMaterialType(EcoreUtil.copy(parentDesign.getSecondMaterialType()));
		}
		
		if(parentDesign.getFacadeMaterial()!=null  && (!mechanicdesign.isFacadeMaterialFree()|| mechanicdesign.getFacadeMaterial()==null)) {
			mechanicdesign.setFacadeMaterial(parentDesign.getFacadeMaterial());
		}
		if(parentDesign.getPrincipalmaterial()!=null && (!mechanicdesign.isPrincipalMaterialFree() || mechanicdesign.getPrincipalmaterial()==null)) {
			mechanicdesign.setPrincipalmaterial(parentDesign.getPrincipalmaterial());
		}
		if(parentDesign.getSecondmaterial()!=null && (!mechanicdesign.isSecondMaterialFree() || mechanicdesign.getSecondmaterial()==null)) {
			mechanicdesign.setSecondmaterial(parentDesign.getSecondmaterial());
		}
		if(parentDesign.getChantFacade()!=null && (!mechanicdesign.isChantFacadeFree() || mechanicdesign.getChantFacade()==null)) {
			mechanicdesign.setChantFacade(parentDesign.getChantFacade());
		}
		if(parentDesign.getChantElement()!=null && (!mechanicdesign.isChantElementFree() || mechanicdesign.getChantElement()==null)) {
			mechanicdesign.setChantElement(parentDesign.getChantElement());
		}
		PublicParamGroup publicparams = mechanicdesign.getPublicparamgroup();
		try {
			MechanicPublicParam ep = publicparams.getParam("global.ep");
			MechanicPublicParam epback = publicparams.getParam("global.epback");

			MechanicPublicParam epface = publicparams.getParam("global.epface");
			if(ep!=null)
			{
				ep.setDefaultvalue(String.valueOf(mechanicdesign.getPrincipalmaterial().getEpaisseur()));
			}
			if(epback!=null)
			{
				epback.setDefaultvalue(String.valueOf(mechanicdesign.getSecondmaterial().getEpaisseur()));
			}
			if(epface!=null)
			{
				epface.setDefaultvalue(String.valueOf(mechanicdesign.getFacadeMaterial().getEpaisseur()));
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static void setDefaultMaterialifNull( MechanicDesign mechanicdesign) {
		//tester si les matireaux d'affichage son null insérer la default material
		MaterialTypeInstance defaultmaterialType =MechanicDesignMaterialsHelper.getdefaultMaterialTypeInstance();
		MaterialTypeInstance faceTypeInstance=mechanicdesign.getFacadeMaterialType();
		MaterialTypeInstance principalTypeInstance=mechanicdesign.getPrincipalMaterialType();
		MaterialTypeInstance secondTypeInstance=mechanicdesign.getSecondMaterialType();
		if(faceTypeInstance==null) {
			faceTypeInstance=EcoreUtil.copy(defaultmaterialType);
			mechanicdesign.setFacadeMaterialType(faceTypeInstance);

		}
		if(principalTypeInstance==null) {
			principalTypeInstance=EcoreUtil.copy(defaultmaterialType);
			mechanicdesign.setPrincipalMaterialType(principalTypeInstance);

		}
		if(secondTypeInstance==null) {		
			secondTypeInstance=EcoreUtil.copy(defaultmaterialType);;
			mechanicdesign.setSecondMaterialType(secondTypeInstance);
		}
		//affecter material d'affuchage du vitre a l'element
		if(mechanicdesign.getDefaultVitreMaterialType()==null) {
			MaterialTypeInstance materialType =EcoreUtil.copy(defaultmaterialType);
			materialType.setMaterial(MechanicDesignMaterialsHelper.getMaterialType("Verre claire"));
			materialType.setColor(EcoreUtil.copy(materialType.getColor()));
			mechanicdesign.setDefaultVitreMaterialType(materialType);		
		}
		if(mechanicdesign.getChantElement()==null) {
			mechanicdesign.setChantElement(MechanicDesignMaterialsHelper.getDefaultChant());
		}
		if(mechanicdesign.getChantFacade()==null) {
			mechanicdesign.setChantFacade(MechanicDesignMaterialsHelper.getDefaultChant());
		}		
		Material mat18 = ResourceManagers.getIntance().getSystemMaterialGroup().getMaterial().stream()
				.filter(mat -> mat.getEpaisseur() == 18.0).findAny().orElse(null);
		if (mat18 == null) {
			mat18 = ResourceManagers.getIntance().getMaterialGroup().getMaterial().stream()
					.filter(mat -> mat.getEpaisseur() == 18.0).findAny().orElse(null);
		}
		
		Material mat5 = ResourceManagers.getIntance().getSystemMaterialGroup().getMaterial().stream()
				.filter(mat -> mat.getEpaisseur() == 5.0).findAny().orElse(null);
		if (mat5 == null) {
			mat5 = ResourceManagers.getIntance().getMaterialGroup().getMaterial().stream()
					.filter(mat -> mat.getEpaisseur() == 5.0).findAny().orElse(null);
		}
		
		if (mat18 == null || mat5 == null) {
			MessageDialog.openError(null, "Matériel manquant",
					"Aucun matériel trouvé. Veuillez vérifier votre configuration et télécharger les donners avant de continuer.");
			throw new IllegalStateException("Missing required materials: 18mm or 5mm not found.");
		}
		if(mechanicdesign.getFacadeMaterial()==null 
				|| mechanicdesign.getFacadeMaterial().getName()==null 
				|| mechanicdesign.getFacadeMaterial().getName().isEmpty()) {
			mechanicdesign.setFacadeMaterial(mat18);
		}
		if(mechanicdesign.getPrincipalmaterial()==null 
				|| mechanicdesign.getPrincipalmaterial().getName()==null 
				|| mechanicdesign.getPrincipalmaterial().getName().isEmpty()) {
			mechanicdesign.setPrincipalmaterial(mat18);
		}
		if(mechanicdesign.getSecondmaterial()==null
				|| mechanicdesign.getSecondmaterial().getName()==null 
				|| mechanicdesign.getSecondmaterial().getName().isEmpty()) {
			mechanicdesign.setSecondmaterial(mat5);
		}
		
	}

	public static MaterialTypeInstance getdefaultMaterialTypeInstance() {
		MaterialTypeInstance defaultmaterialType = ParamFactoryImpl.eINSTANCE.createMaterialTypeInstance();
		defaultmaterialType
				.setMaterial(ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes().get(0));
		defaultmaterialType.setIsColor(true);

		defaultmaterialType.setColor(defaultmaterialType.getMaterial().getAlbedo() != null
				? EcoreUtil.copy(defaultmaterialType.getMaterial().getAlbedo())
				: ParamFactoryImpl.eINSTANCE.createVertice3());
		return defaultmaterialType;
	}

	public static MaterialType getMaterialType(String name) {
		EList<MaterialType> materials = ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes();
		for (MaterialType material : materials) {
			if (material.getName().toUpperCase().contentEquals(name.toUpperCase())) {
				return material;
			}
		}
		return getdefaultMaterialTypeInstance().getMaterial();
	}

	public static void updateDesignElement(MechanicDesign mechanicdesign, MechanicDesignElment mechanicelment, Piece2D p2) {
		MaterialTypeInstance defaultmaterialType = MechanicDesignMaterialsHelper.getdefaultMaterialTypeInstance();

		if (mechanicelment.isFaceMaterial()) {
			mechanicelment.setMaterial(mechanicdesign.getFacadeMaterial());
			if(!mechanicelment.isMaterialTypeFree())
				mechanicelment.setMaterialType(EcoreUtil.copy(mechanicdesign.getFacadeMaterialType()));
			fixPieceElementChant(mechanicdesign.getChantFacade(), mechanicelment);
		}
		if (mechanicelment.isPrimaryMaterial()) {
			mechanicelment.setMaterial(mechanicdesign.getPrincipalmaterial());
			if(!mechanicelment.isMaterialTypeFree())
				mechanicelment.setMaterialType(EcoreUtil.copy(mechanicdesign.getPrincipalMaterialType()));
			fixPieceElementChant(mechanicdesign.getChantElement(), mechanicelment);
		}
		if (mechanicelment.isBackMaterial()) {
			mechanicelment.setMaterial(mechanicdesign.getSecondmaterial());
			if(!mechanicelment.isMaterialTypeFree())
				mechanicelment.setMaterialType(EcoreUtil.copy(mechanicdesign.getSecondMaterialType()));
		}
		//
		if (mechanicelment.isFreeMaterial()) {
			if (mechanicelment.getMaterialType() == null) {
				MaterialTypeInstance material = EcoreUtil.copy(defaultmaterialType);
				mechanicelment.setMaterialType(material);
			}
			fixPieceElementChant(mechanicdesign.getChantElement(), mechanicelment);

		} else {
			if (mechanicdesign.getMaterialTypes() != null
					&& mechanicdesign.getMaterialTypes().getDesignMaterialTypes() != null
					&& !mechanicdesign.getMaterialTypes().getDesignMaterialTypes().isEmpty()) {
				for (DesignMaterialType materialType : mechanicdesign.getMaterialTypes().getDesignMaterialTypes()) {
					if (materialType.getMaterialType() == null) {
						MaterialTypeInstance materialTypeinstance = MechanicDesignMaterialsHelper
								.getdefaultMaterialTypeInstance();
						MaterialType defaultMatarialType = MechanicDesignMaterialsHelper.getMaterialType("MDF");
						if(defaultMatarialType==null) {
							defaultMatarialType = MechanicDesignMaterialsHelper.getMaterialType("Bois");
						}
						if(defaultMatarialType==null) {
							defaultMatarialType = ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes().get(0);
						}
						materialTypeinstance.setMaterial(defaultMatarialType);
						materialType.setMaterialType(materialTypeinstance);
					}
					if (materialType.getPieceType() != null) {
						if (materialType.getPieceType().contains(mechanicelment.getTypedefelement())) {
							MaterialTypeInstance material = EcoreUtil.copy(materialType.getMaterialType());
							mechanicelment.setMaterialType(material);
						}
					}
				}
			}
		}
		//
		if (p2 != null) {
			// set material des panneau dans la piece
			p2.setMaterial(mechanicelment.getMaterial());
			// set material d'affichage dans la piece
			p2.setMaterialType(mechanicelment.getMaterialType());
		}

		if (!mechanicelment.isVitreMaterialTypeFree() || mechanicelment.getVitreMaterialType() == null) {
			mechanicelment.setVitreMaterialType(EcoreUtil.copy(mechanicdesign.getDefaultVitreMaterialType()));
		}
		// set material du vitre d'affichage dans la piece
		if (p2 != null) {
			p2.setVitreMaterialType(mechanicelment.getVitreMaterialType());
			//
		}
	}
	
	public static Chant getDefaultChant() {
		ChantGroup chants=ResourceManagers.getIntance().getChants();
		if(chants!=null && chants.getChant()!=null && !chants.getChant().isEmpty()) {
			return chants.getChant().get(0);
		}
		return null;
	}
	
	public static void fixPieceElementChant(Chant chnt, MechanicDesignElment mechanicelment) {
		if (mechanicelment.getChants() == null) {
			mechanicelment.setChants(ParamFactory.eINSTANCE.createDesignElementChantGroup());
		}
		DesignElementChantGroup chant = mechanicelment.getChants();
		if (!chant.isLeftFree() || chant.getLeft() == null) {
			chant.setLeft(chnt);
		}
		if (!chant.isRightFree() || chant.getRight() == null) {
			chant.setRight(chnt);
		}
		if (!chant.isTopFree() || chant.getTop() == null) {
			chant.setTop(chnt);
		}
		if (!chant.isBottomFree() || chant.getBottom() == null) {
			chant.setBottom(chnt);
		}
	}
	
	public static void updateMaterialFromKitchen(Kitchen kitchen, MechanicDesign mechanicdesign) {
		Material faceMat=	kitchen.getFaceMaterial();
		Material baseMat=	kitchen.getPrimaryMaterial();
		Material backMat=	kitchen.getBackMaterial();
		
		if(baseMat!=null)
		{
			mechanicdesign.setPrincipalmaterial(baseMat);
		}
		if(faceMat!=null)
		{
			mechanicdesign.setFacadeMaterial(faceMat);
		}
		if(backMat!=null)
		{
			mechanicdesign.setSecondmaterial(backMat);
		}
		PublicParamGroup publicparams = mechanicdesign.getPublicparamgroup();

		MechanicPublicParam ep;
		try {
			ep = publicparams.getParam("global.ep");
			if(ep!=null) {
				ep.setDefaultvalue(String.valueOf(mechanicdesign.getPrincipalmaterial().getEpaisseur()));
			}
			
			MechanicPublicParam epback = publicparams.getParam("global.epback");	
			if(epback!=null) {
				epback.setDefaultvalue(String.valueOf(mechanicdesign.getSecondmaterial().getEpaisseur()));
			}
			
			MechanicPublicParam epface = publicparams.getParam("global.epface");
			if(epface!=null) {
				epface.setDefaultvalue(String.valueOf(mechanicdesign.getFacadeMaterial().getEpaisseur()));
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		MechanicDesignMaterialsHelper.setDefaultMaterialifNull(mechanicdesign);
		MaterialTypeInstance faceTypeInstance=mechanicdesign.getFacadeMaterialType();
		MaterialTypeInstance principalTypeInstance=mechanicdesign.getPrincipalMaterialType();
		MaterialTypeInstance secondTypeInstance=mechanicdesign.getSecondMaterialType();
		if(faceTypeInstance!=null) {
			if(faceTypeInstance.getTexture()==null &&kitchen.getScene()!=null
					&&kitchen.getScene().getPreferences()!=null &&kitchen.getScene().getPreferences().getFacadeMtl().getAlbedoMapPath()!=null) {
				faceTypeInstance.setTexture(kitchen.getScene().getPreferences().getFacadeMtl().getAlbedoMapPath());
				faceTypeInstance.setIsColor(false);
				faceTypeInstance.setMaterial(ModelProvider.getMaterialTypeByName(kitchen.getScene().getPreferences().getFacadeMtl().getName()));
			}
		}
		if(principalTypeInstance!=null) {
			if(principalTypeInstance.getTexture()==null &&kitchen.getScene()!=null
					&&kitchen.getScene().getPreferences()!=null &&kitchen.getScene().getPreferences().getBoxMtl().getAlbedoMapPath()!=null) {
				principalTypeInstance.setTexture(kitchen.getScene().getPreferences().getBoxMtl().getAlbedoMapPath());
				principalTypeInstance.setIsColor(false);
				principalTypeInstance.setMaterial(ModelProvider.getMaterialTypeByName(kitchen.getScene().getPreferences().getBoxMtl().getName()));
			}
		}
		if(secondTypeInstance!=null) {
			if(secondTypeInstance.getTexture()==null &&kitchen.getScene()!=null
					&&kitchen.getScene().getPreferences()!=null &&kitchen.getScene().getPreferences().getBackMtl().getAlbedoMapPath()!=null) {
				secondTypeInstance.setTexture(kitchen.getScene().getPreferences().getBoxMtl().getAlbedoMapPath());
				secondTypeInstance.setIsColor(false);
				secondTypeInstance.setMaterial(ModelProvider.getMaterialTypeByName(kitchen.getScene().getPreferences().getBackMtl().getName()));
			}
		}
	}
	
}


