package dressing.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.controller.DependenceResponsibilityCenter;
import param.AxisDelimitersEntry;
import param.Delimeter;
import param.DelimiterConstraintsEntry;
import param.DelimiterCreatorsEntry;
import param.DesignReferencesEntry;
import param.DirectionDelimiterMap;
import param.MechanicDesign;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.PieceType;
import param.impl.DelimeterImpl;

public class MechanicDesignDelimitersSystemManager {

	static DesignObject3D preprocessParent(DesignObject3D parent, MechanicDesign mechanicDesign) {
		if (parent == null || parent.getRootModule() == null)
			return parent;

		Space3D rootSpace = (Space3D) parent.getRootModule();
		DirectionDelimiterMap delimiters = rootSpace.getDependenceController().getChainModel().getDesignsReferences()
				.get(mechanicDesign);

		if (delimiters != null && !delimiters.getEntries().isEmpty()) {
			DesignObject3D spaceParent = rootSpace.getDependenceController().createConstraintSpace(delimiters, parent,
					false);
			if (spaceParent != null)
				return spaceParent;
		}

		return parent;
	}
	
	static DesignObject3D getExistingInstanceFromRootModule(DesignObject3D parent, MechanicDesign mechanicdesign) {
	    if (parent == null || (Space3D) parent.getRootModule()==null) return null;
	    Space3D rootModule = (Space3D) parent.getRootModule();
	    return rootModule.getDependenceController().getIntsatanceToDefinition().get(mechanicdesign);
	}
	
	
	public static DesignObject3D updateDelimitersAndCheckCollisions(MechanicDesign mechanicdesign, int update,
			boolean isCreatedFromParentChilds, DesignObject3D src, DesignObject3D parentDesign, Space3D rootModule)
			throws Exception {
		EList<MechanicPrivateParam> privateparams = mechanicdesign.getPrivateparamgroup().getMechanicprivateparam();
		EList<MechanicPublicParam> publicparams = mechanicdesign.getPublicparamgroup().getMechanicpublicparam();

		updateOuterDelimiters(mechanicdesign, update, isCreatedFromParentChilds, privateparams, publicparams, src,
				rootModule);

		if (!mechanicdesign.getType().equals(PieceType.OBSTACLE)) {
			updateModuleInnerDelimiters(mechanicdesign, update, privateparams, publicparams, src);
		}

		DesignObject3D pieceCollusionvalue = MechanicDesignCollusionsHelper.checkPiecesCollusions(src, parentDesign, rootModule);
		if (pieceCollusionvalue != null) {
			return pieceCollusionvalue;// or return early, adapt as needed
		}

		DesignObject3D doscollusionvalue = MechanicDesignCollusionsHelper.checkDosCollusions(src, parentDesign, rootModule);
		if (doscollusionvalue != null) {
			return doscollusionvalue;
		}
		//check if the src is not dos and intersect with a dos then we split dos
		MechanicDesignCollusionsHelper.checkPieceCollusionWithDos(src, rootModule);
		//check if the src is seperator facade and intersect with a PARTITION_FACADE then we split PARTITION_FACADE
		MechanicDesignCollusionsHelper.checkSeparatorFacadePieceCollusion(src, rootModule);

		DesignObject3D value = MechanicDesignCollusionsHelper.checkPartitionFacedeCollusions(src, parentDesign, rootModule);
		if (value != null) {
			return value;	
		}

		MechanicDesignCollusionsHelper.removeIntersectDosWithSpace(mechanicdesign, src, parentDesign);

		if (src instanceof Space3D && mechanicdesign.getType().equals(PieceType.ACCESOIRE)) {
			MechanicDesignCollusionsHelper.separateFacadeCoulissant(mechanicdesign, src, parentDesign, rootModule);
		}
		return null;
	}
	
	/**
	 * @param mechanicdesign
	 * @param update
	 * @param isCreatedFromParentChilds
	 * @param privateparams
	 * @param publicparams
	 * @param src
	 * @param rootModule
	 * @throws DesignException
	 * @throws GeometricEngineException
	 * @throws Exception
	 */
	private static void updateOuterDelimiters(MechanicDesign mechanicdesign, int update, boolean isCreatedFromParentChilds,
			EList<MechanicPrivateParam> privateparams, EList<MechanicPublicParam> publicparams, DesignObject3D src,
			Space3D rootModule) throws DesignException, GeometricEngineException, Exception {
		if(rootModule!=null ) {
			List<dressing.model.Delimeter> delimeters = new ArrayList<dressing.model.Delimeter>();
			if( mechanicdesign.getResultDelimeters()!=null && mechanicdesign.getResultDelimeters().getDelimeters()!=null 
					&&!mechanicdesign.getResultDelimeters().getDelimeters().isEmpty()) {
				for(Delimeter delimeter:mechanicdesign.getResultDelimeters().getDelimeters()) {
					dressing.model.Delimeter del =rootModule.getDependenceController().getDelimeter((DelimeterImpl) delimeter);
					if(del==null)
					 {
						del = new dressing.model.Delimeter((DelimeterImpl) delimeter);
					 }
					del.constructGenericDebitage(privateparams, publicparams, delimeter, src);
					if((Boolean)del.get("EXIST"))
					{
						if(delimeter.getId()==null|| update==MechanicDesignCreator.create) {
							UUID id=UUID.randomUUID();
							delimeter.setId(id);
							del.setId(id);
						}else {
							del.setId(delimeter.getId());
						}
						del.setXint(new Intervale(src.getXpos(), true, src.getXpos()+src.getLongeurext(), true));
						del.setYint(new Intervale(src.getYpos(), true, src.getYpos()+src.getHauteurext(), true));
						del.setZint(new Intervale(src.getZpos(), true, src.getZpos()+src.getProfondeurext(), true));
						delimeters.add(del);
					}
					
				}
			}
			rootModule.getDependenceController().registerOrUpdateTargetReference(src,delimeters,!isCreatedFromParentChilds);
		}
	}

	/**
	 * @param mechanicdesign
	 * @param update
	 * @param privateparams
	 * @param publicparams
	 * @param src
	 * @throws DesignException
	 * @throws GeometricEngineException
	 * @throws Exception
	 */
	private static void updateModuleInnerDelimiters(MechanicDesign mechanicdesign, int update,
			EList<MechanicPrivateParam> privateparams, EList<MechanicPublicParam> publicparams, DesignObject3D src)
			throws DesignException, GeometricEngineException, Exception {
		//update inner Delimiters if there any (in case the current mechanic Design represent a module and passing delimeters to his inner module)
		if(src!=null && src instanceof Space3D && mechanicdesign.getInnerDelimeters() !=null && mechanicdesign.getInnerDelimeters().getDelimeters()!=null 
				&&!mechanicdesign.getInnerDelimeters().getDelimeters().isEmpty() && ((Space3D)src).getDependenceController()!=null 
				&& src.getMechanicDesignDefinition()!=null&&src.getMechanicDesignDefinition().getChainOfResponsabilityController()!=null) {
			List<dressing.model.Delimeter> delimeters = new ArrayList<dressing.model.Delimeter>();

			for(Delimeter delimeter:mechanicdesign.getInnerDelimeters().getDelimeters()) {
				dressing.model.Delimeter del =((Space3D) src).getDependenceController().getDelimeter((DelimeterImpl) delimeter);
				if(del==null)
				 {
					del = new dressing.model.Delimeter((DelimeterImpl) delimeter);
				 }
				del.constructGenericDebitage(privateparams, publicparams, delimeter, src);
				if((Boolean)del.get("EXIST"))
				{
					if(delimeter.getId()==null|| update==MechanicDesignCreator.create) {
						UUID id=UUID.randomUUID();
						delimeter.setId(id);
						del.setId(id);
					}else {
						del.setId(delimeter.getId());
					}
					del.setXint(new Intervale(0, true, src.getLongeurext(), true));
					del.setYint(new Intervale(0, true, src.getHauteurext(), true));
					del.setZint(new Intervale(0, true, src.getProfondeurext(), true));
					delimeters.add(del);
				}
				
			}
			
			
			((Space3D) src).getDependenceController().registerOrUpdateTargetReference(src,delimeters,false);
		}
	}

	public static void cleanUP(DesignObject3D src,int update) {
		if(src!=null && src instanceof Space3D && ((Space3D)src).getDependenceController()!=null 
				&& src.getMechanicDesignDefinition()!=null&&src.getMechanicDesignDefinition().getChainOfResponsabilityController()!=null){
			DependenceResponsibilityCenter chain =((Space3D)src).getDependenceController();
			if(chain.getChainModel()==null) {
				return;
			}
			//clean the general list of delimeters in AxisDelimitersMap
				for(AxisDelimitersEntry entry: chain.getChainModel().getAxisDelimiters().getEntries()) {
					if(entry.getDelimiters()!=null && !entry.getDelimiters().isEmpty()) {
						List<Delimeter> dels=entry.getDelimiters().stream().distinct().collect(Collectors.toList());
						if(dels.size()!=entry.getDelimiters().size()) {
							entry.getDelimiters().clear();
							entry.getDelimiters().addAll(dels);
						}
						
					}
					
				}
				//clean delimeter creators if they does not belong to this system Anymore 
				List<DelimiterCreatorsEntry> tobeDeletedcreatorsEntries=new ArrayList<DelimiterCreatorsEntry>();
				for(DelimiterCreatorsEntry entry:chain.getChainModel().getDelimiterCreators().getEntries()) {
					if(entry.getCreator()==null ||!(src.getMechanicDesignDefinition().getMechanicdesign().contains(entry.getCreator())||entry.getCreator().equals(src.getMechanicDesignDefinition()) ) ) {
						tobeDeletedcreatorsEntries.add(entry);
					}
				}
				chain.getChainModel().getDelimiterCreators().getEntries().removeAll(tobeDeletedcreatorsEntries);
				//
				List<DesignReferencesEntry> tobeDeletedDesignReferencesEntries=new ArrayList<DesignReferencesEntry>();
				for(DesignReferencesEntry entry:chain.getChainModel().getDesignsReferences().getEntries()) {
					if(entry.getDesign()==null||!(src.getMechanicDesignDefinition().getMechanicdesign().contains(entry.getDesign())||entry.getDesign().equals(src.getMechanicDesignDefinition()) ) ) {
						tobeDeletedDesignReferencesEntries.add(entry);
					}
				}
				chain.getChainModel().getDesignsReferences().getEntries().removeAll(tobeDeletedDesignReferencesEntries);
				
				//
				List<DelimiterConstraintsEntry> tobeDeletedDelimiterConstraintsEntries =new ArrayList<DelimiterConstraintsEntry>();
				for(DelimiterConstraintsEntry entry:chain.getChainModel().getDelimiterContraints().getEntries()) {
					if(entry.getDelimiter()==null) {
						tobeDeletedDelimiterConstraintsEntries.add(entry);
					}
				}
				chain.getChainModel().getDelimiterContraints().getEntries().removeAll(tobeDeletedDelimiterConstraintsEntries);
				
		}
	}
	
}
