package dressing.model;

import java.util.ArrayList;
import java.util.List;

import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.Direction;
import dressing.mathutils.CoordinateSystem;
import dressing.model.debitage.FaceAssemblyGenericDebitage;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;

public class FaceModel extends Piece2D {
	private param.Face node;
	private Direction dirX;
	private Direction dirY;
	private Direction dirZ;
	private Matrix4 transformMatrix;
	private Matrix3 rotationMatrix;
	private Vector3 dimention;
	private Vector3 position;
	private Piece2D piece;
	private transient ArrayList<AssemblyContainerModel> assemblies=new ArrayList<AssemblyContainerModel>();

	public FaceModel(param.Face node,Piece2D parent) {
		super();
		this.node = node;
		piece=parent;
		setParentdesign(parent);
		
	}
    private void init() {
    	setName(node.getSide().getLiteral());
		setDirX(dressing.cam.model.Direction.valueOf(node.getDirection_X().getLiteral()));
		setDirY(dressing.cam.model.Direction.valueOf(node.getDirection_Y().getLiteral()));
		setDirZ(dressing.cam.model.Direction.valueOf(node.getDirection_Z().getLiteral()));

		Vector3 dim=new Vector3((float)(MechanicDesignAssemblyManager.getDimentionFromDirection(dirX,piece)-node.getDecalageX())
				, (float)(MechanicDesignAssemblyManager.getDimentionFromDirection(dirY,piece)-node.getDecalageY()),
				(float)	(MechanicDesignAssemblyManager.getDimentionFromDirection(dirZ,piece)-node.getDecalageZ()));
		setDimention(dim);
		Vector3 pos=new Vector3((float)	MechanicDesignAssemblyManager.getPositionFromDirection(dirX,piece,node.getDecalageX())
				, (float)MechanicDesignAssemblyManager.getPositionFromDirection(dirY,piece,node.getDecalageY())
				, (float)	MechanicDesignAssemblyManager.getPositionFromDirection(dirZ,piece,node.getDecalageZ()));
		Vector3 xpos=MechanicDesignAssemblyManager.getVector(dirX).scl(pos.x);
		Vector3 ypos=MechanicDesignAssemblyManager.getVector(dirY).scl(pos.y);
		Vector3 zpos=MechanicDesignAssemblyManager.getVector(dirZ).scl(pos.z);
		pos.set(0, 0, 0).add(xpos).add(ypos).add(zpos);
		setPosition(pos);
		setMaterial(piece.getMaterial());
		setMaterialType(piece.getMaterialType());
		setMechanicDesignDefinition(piece.getMechanicDesignDefinition());
		setMechanicDesignElementDefinition(piece.getMechanicDesignElementDefinition());
		Vector3 xv=dirX.toVector();
		Vector3 yv=dirY.toVector();
		Vector3 zv=dirZ.toVector();
		
		transformMatrix =CoordinateSystem.getTransformMatrix(xv, yv, zv, pos);
		transformMatrix=transformMatrix.inv();
		rotationMatrix = CoordinateSystem.getRotationMatrix(xv, yv, zv, pos);
    }
	public Vector3 getDimention() {
		return dimention;
	}

	public void setDimention(Vector3 dimention) {
		this.dimention = dimention;
		
		setLongeurext(dimention.x);
		setHauteurext(dimention.y);
		setProfondeurext(dimention.z);
		node.setWidth(dimention.x);
		node.setLength(dimention.y);
		node.setDepth(dimention.z);
	}

	public Vector3 getPosition() {
		return position;
	}

	public void setPosition(Vector3 position) {
		this.position = position;
		setXpos(position.x);
		setYpos(position.y);
		setZpos(position.z);
	}

	public Direction getDirX() {
		return dirX;
	}

	public void setDirX(Direction dirX) {
		this.dirX = dirX;
	}

	public Direction getDirY() {
		return dirY;
	}

	public void setDirY(Direction dirY) {
		this.dirY = dirY;
	}

	public Direction getDirZ() {
		return dirZ;
	}

	public void setDirZ(Direction dirZ) {
		this.dirZ = dirZ;
	}

	public Matrix4 getTransformMatrix() {
		return transformMatrix;
	}

	public void setTransformMatrix(Matrix4 transformMatrix) {
		this.transformMatrix = transformMatrix;
	}

	public Matrix3 getRotationMatrix() {
		return rotationMatrix;
	}

	public void setRotationMatrix(Matrix3 rotationMatrix) {
		this.rotationMatrix = rotationMatrix;
	}

	public param.Face getNode() {
		return node;
	}

	public void setNode(param.Face node) {
		this.node = node;
	}

	public ArrayList<AssemblyContainerModel> getAssemblies() {
		return assemblies;
	}
	public void setAssemblies(ArrayList<AssemblyContainerModel> assemblies) {
		this.assemblies = assemblies;
	}
	public Piece2D getPiece() {
		return piece;
	}
	public void setPiece(Piece2D piece) {
		this.piece = piece;
	}
	@Override
	public boolean isSolid() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isdrawable() {
		return false;
	}
	@Override
	public void setParentdesign(DesignObject3D parentdesign) {
		// TODO Auto-generated method stub
		super.setParentdesign(parentdesign);
		this.piece=(Piece2D) parentdesign;
	}
	@Override
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException {
		
		super.updateproperties(equations);
	}

	@Override
	public void constructGenericDebitage(List<MechanicPrivateParam> privateparams,
			List<MechanicPublicParam> publicparams, Object emf, DesignObject3D parent)
			throws DesignException, GeometricEngineException {
		ArrayList<Equation> equations = new ArrayList<Equation>();
		FaceAssemblyGenericDebitage.createupdateDebitage(parent , this,privateparams,publicparams,node,equations);
//		if((boolean) this.get("EXIST")) {
			init();
//		}
		
		equations.clear();
	}
	
	@Override
	public boolean isDirectlyDelatable() {
		// TODO Auto-generated method stub
		return true;
	}
	
	public void delete() throws Exception {
		this.piece.deletechild(this, true);
		this.piece.getFaces().remove(this);
		this.piece.getMechanicDesignElementDefinition().getAssemblySystemsfaces().remove(getNode());
	}
}
