package dressing.model;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;
import dressing.model.debitage.GenericDebitage;
import dressing.model.persistence.mappers.PersistenceValue;
import dressing.model.types.IntersectionType;
import dressing.model.types.PieceType;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.PublicParamGroup;
import utils.EmfUtils;

public abstract class DesignObject3D implements Solide3D,Serializable{

	protected  DesignObject3D parentdesign;
	protected MechanicDesign mechanicDesignDefinition;
	public int sceneNumber;

	protected List<DesignObject3D> childs;

	//Pour les pieces 3D
	protected double longeurext;//la plus longue distance
	protected double profondeurext;//profondeur
	protected double hauteurext;
	
	protected String name="";
	
	transient private boolean notificationon=true;

	protected double xpos;
	protected double ypos;
	protected double zpos;
	
	Properties props=new Properties();
	@PersistenceValue
	protected UUID ID = null;
	Kitchen kitchen;
	protected transient boolean visible = true;
	transient protected Boolean selected=false;
	private transient TransformManager<?, ?> transformManager;
    private transient boolean errorexist=false;
    private transient String errormsg="";
	public boolean isVisible() {
		return visible;
	}

	public void setVisible(boolean visible) {
		boolean oldValue = this.visible;
		this.visible = visible;
		firePropertyChange("visible", oldValue, visible);
	}
	
	public double getXPosABS() {	

		if (getParentdesign() != null) {
			return getXpos() + getParentdesign().getXPosABS();
		} else {
			return getXpos();
		}

	}

	public double getYPosABS() {
		if (getParentdesign() != null) {
			return getYpos() + getParentdesign().getYPosABS();
		} else {
			return getYpos();
		}
			
	}

	public double getZPosABS() {
		if (getParentdesign() != null) {
			return getZpos() + getParentdesign().getZPosABS();
		} else {
			return getZpos();
		}
	
	}

	public DesignObject3D() {
		// TODO Auto-generated constructor stub
		childs = new ArrayList<DesignObject3D>();
//	   readResolve() ;
	}

	public DesignObject3D getParentdesign() {
		return parentdesign;
	}

	public void setParentdesign(DesignObject3D parentdesign) {
		this.parentdesign = parentdesign;
	}

	public List<DesignObject3D> getChilds() {
		if(childs==null) {
			childs = new ArrayList<DesignObject3D>();
		}
		return childs;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}

	public double getLongeurext() {
		return longeurext;
	}

	public void setLongeurext(double longeurext) {

		double oldValue = this.longeurext;
		this.longeurext = longeurext;
		firePropertyChange("longeurext", oldValue, longeurext);
	}

	public double getProfondeurext() {
		return profondeurext;
	}

	public void setProfondeurext(double profondeurext) {

		double oldValue = this.profondeurext;
		this.profondeurext = profondeurext;
		firePropertyChange("profondeurext", oldValue, profondeurext);
	}

	public double getHauteurext() {
		return hauteurext;
	}

	public void setHauteurext(double hauteurext) {

		double oldValue = this.hauteurext;
		this.hauteurext = hauteurext;
		firePropertyChange("hauteurext", oldValue, hauteurext);
	}

	public abstract boolean canHold(DesignObject3D child);

	@Override
	public String toString() {

		return name;
	}

	public void check() throws DesignException
	{
		
	}

	/**
	 * 
	 * @return L'objet design parent absolue dressing ou cuisine
	 */
	public DesignObject3D getRoot()
	{

		if(getParentdesign()!=null) {
			return getParentdesign().getRoot();
		}else {
			return this;
		}
	}

	public void checkIntersectionWithRoot(DesignObject3D coming) throws DesignException
	{
		DesignObject3D root = this.getRoot();
		if (root != null && coming != null && coming instanceof Piece2D)
			checkIntersectionWithSubelements(root, coming);
	}
	public void checkIntersectionWithSubelements(DesignObject3D sub , DesignObject3D coming) throws DesignException
	{
		for(DesignObject3D designobject : sub.getChilds())
		{
			if(designobject instanceof Piece2D && coming instanceof Piece2D)
			{
				if(designobject.isIntersect(coming).equals(IntersectionType.INTERSECTION))
				{
//					throw new DesignException("Intersection detecté entre  "+coming.getName()+" et "+designobject.getName());
//					if(sub instanceof Piece2D && coming instanceof Piece2D) {
//						if(!isallowedIntersection(sub,coming)) {
//							throw new DesignException("Intersection detecté entre  "+coming.getName()+" et "+designobject.getName());
//						}
//					}
				}
				if(designobject.isIntersect(coming).equals(IntersectionType.TANGENT))
				{
//					throw new DesignException("Intersection detecté entre  "+coming.getName()+" et "+designobject.getName());
				}
			}
			checkIntersectionWithSubelements(designobject, coming);
           
		}
	}

//	private boolean isallowedIntersection(DesignObject3D sub, DesignObject3D coming) {
//		if(((Piece2D)sub).getPiecetype().equals(PieceType.DOS_INTERIEUR)
//				||((Piece2D)coming).getPiecetype().equals(PieceType.DOS_INTERIEUR)){
//			return true;
//		}
//		if(((Piece2D)sub).getPiecetype().equals(PieceType.PORTE)
//				||((Piece2D)coming).getPiecetype().equals(PieceType.PORTE)){
//			return true;
//		}
//		return false;
//	}
	public void addElement(DesignObject3D child) throws DesignException, GeometricEngineException
	{
		if(child ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}

//		this.checkIntersectionWithRoot(child);
		
		
		if(canHold(child))
		{
			child.addPropertyChangeListener(new PropertyChangeListener() {

				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if (!evt.getPropertyName().equalsIgnoreCase("selected")) {
						firePropertyChange("project.modify", null, child);
					}

				}
			});
			
			childs.add(child);
			child.setParentdesign(this);			
			firePropertyChange("project.child.added", null, child);
		
		}
		else
		{
			throw new DesignException("Impossible d'ajouter "+child.getName());
		}
		
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public PropertyChangeSupport getPropertyChangeSupport() {
		if (propertyChangeSupport == null) {
			propertyChangeSupport = new PropertyChangeSupport(this);
		}
		return propertyChangeSupport;
	}
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		getPropertyChangeSupport().addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
	}

	public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		if (isNotificationon()) {
			getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
		}

	}

	public PropertyChangeListener[] getListeners() {

		return getPropertyChangeSupport().getPropertyChangeListeners();
	}

	public void removeAllLsteners() {
		PropertyChangeListener[] listeners = getListeners();
		if (listeners == null) {
			return;
		}
		for (PropertyChangeListener listener : listeners) {
			getPropertyChangeSupport().removePropertyChangeListener(listener);
		}
	}

	public void setErrorexist(boolean errorexist) {

		boolean oldValue = this.errorexist;
		this.errorexist = errorexist;
		firePropertyChange("errorexist", oldValue, errorexist);
	}

	public boolean isErrorexist() {
		return errorexist;
	}

	public void setErrormsg(String errormsg) {

		String oldValue = this.errormsg;
		this.errormsg = errormsg;
		firePropertyChange("errormsg", oldValue, errormsg);
	}

	public String getErrormsg() {
		return errormsg;
	}

	public void clearautomatique(boolean isuser) throws Exception
	{
		ArrayList<DesignObject3D> list =  new ArrayList<DesignObject3D>();
		list.addAll(getChilds());
		for(DesignObject3D obj : list)
		{
			deletechild(obj,false);
//			obj.clearautomatique(false);
//			obj.setParentdesign(null);
			obj.removeAllLsteners();
			
		
		}
		list.clear();
		list.trimToSize();
		list=null;
	}

	public String printDescription()
	{		
		String s="	";
		s+=" 	Default design object "  + getName() +"\n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}

	public boolean deletechild(DesignObject3D child) throws Exception {
		return deletechild(child, true, true);
	}

	public boolean deletechild(DesignObject3D child, boolean isuser) throws Exception {
		return deletechild(child, isuser, isuser);
	}

	public boolean deletechild(DesignObject3D child, boolean isuser, boolean isdeleteFromSystem) throws Exception {
		if (childs.contains(child)) {
			if (isuser) {
				if (child.getMechanicDesignDefinition() != null) {
					MechanicDesign design = child.getMechanicDesignDefinition();
					// TODO test if child not contained in rootModule System we delete it
//					DesignObject3D DesignObject=((Space3D) getRootModule()).getDependenceController().getIntsatanceToDefinition().get(design);
//					if(DesignObject!=null) {
//						DesignObject3D parent = DesignObject.getParentdesign();
					if ((!design.getType().equals(param.PieceType.PIECE2D) && (child instanceof Piece2D)
							&& ((Piece2D) child).getMechanicDesignElementDefinition() != null)) {
						design.getMechanicelementgroup().getMechanicdesignelment()
								.remove(((Piece2D) child).getMechanicDesignElementDefinition());

					} else if (getMechanicDesignDefinition() != null) {
						getMechanicDesignDefinition().getMechanicdesign().remove(design);
					}
//					}

				}
			}

			boolean retval =  childs.remove(child);
			if( isuser && isdeleteFromSystem) {
				if(child.getMechanicDesignDefinition()!=null ) {
					MechanicDesign design=child.getMechanicDesignDefinition();
					if((design.getType().equals(param.PieceType.PIECE2D) && (child instanceof Piece2D) )
						||(!design.getType().equals(param.PieceType.PIECE2D) && !(child instanceof Piece2D)))
					((Space3D)getRootModule()).getDependenceController().deleteDesign(design);
					if(getMechanicDesignDefinition().getStructureAction()!=null && getMechanicDesignDefinition().getStructureAction().getCreatedRefences().contains(design)) {
							getMechanicDesignDefinition().getStructureAction().getCreatedRefences().remove(design);
						}
				}
			}
			if (child instanceof Space3D && isuser && isdeleteFromSystem) {
				((Space3D) child).getDependenceController().clear();
			}
			boolean updateParent = false;
			if(child !=null && child.getMechanicDesignDefinition()!=null 
					&& child instanceof Space3D && isuser
					&& child.getMechanicDesignDefinition().getType().equals(param.PieceType.OBSTACLE)) {
				updateParent = true;
			}
			child.clearautomatique(isuser);
			child.setParentdesign(null);
			if (updateParent)
				update(false);
			return retval;
		}
		return false;
	}

	public void setNotificationon(boolean notificationon) {
		this.notificationon = notificationon;
	}

	public boolean isNotificationon() {
		return notificationon;
	}

	@Override
	public List<Solide3D> getChildren() {
		// TODO Auto-generated method stub
		return new ArrayList<>(childs);
	}

	@Override
	public double getXPosition() {
		// TODO Auto-generated method stub
		return getXpos();
	}

	@Override
	public double getYPosition() {
		// TODO Auto-generated method stub
		return getYpos();
	}

	@Override
	public double getZPosition() {
		// TODO Auto-generated method stub
		return getZpos();
	}

	public double getXpos() {
		return xpos;
	}

	public void setXpos(double xpos) {
		double oldValue = this.xpos;
		this.xpos = xpos;
		firePropertyChange("xpos", oldValue, xpos);
	}

	public double getYpos() {
		return ypos;
	}

	public void setYpos(double ypos) {
		double oldValue = this.ypos;
		this.ypos = ypos;
		firePropertyChange("ypos", oldValue, ypos);
	}

	public double getZpos() {
		return zpos;
	}

	public void setZpos(double zpos) {
		double oldValue = this.zpos;
		this.zpos = zpos;
		firePropertyChange("zpos", oldValue, zpos);
	}

	@Override
	public double gettransparency() {
		// TODO Auto-generated method stub
		return 0;
	}

	/**
	 * @param selected the selected to set
	 */
	public void setSelected(Boolean selected) {
		if (this.selected == null) {
			this.selected = false;
		}
		boolean oldValue = this.selected;
		this.selected = selected;
		firePropertyChange("selected", oldValue, selected);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tech.frsdev.solids.Solide3D#isSelected()
	 */
	@Override
	public Boolean isSelected() {
		if (this.selected == null) {
			this.selected = false;
		}
		return selected;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see tech.frsdev.solids.Solide3D#isHighlighted()
	 */

	@Override
	public Solide3D getParent() {
		// TODO Auto-generated method stub
		return this.getParentdesign();
	}
	
	/**
	 * cette methode est utilise pour le debiotage dynamique
	 * 
	 * @param eList
	 * @param publicparams
	 * @param privateparams
	 * @throws DesignException
	 */
	public void constructGenericDebitage(List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, Object emf,DesignObject3D parent) throws DesignException, GeometricEngineException
	{
		// faire passer tous les variables categoriques dans les proprotes de design
		// object
		// avnat de lancer le calcul de debitage et passer la resolutions
		//

		if(emf instanceof MechanicDesignElment)
		{
			
			if (this instanceof Piece2D) {
				Piece2D piece = ((Piece2D) this);
				if (piece.getMaterialType() != null && piece.getMaterialType().getMaterial() != null
						&& piece.getMaterialType().getMaterial().getName() != null
						&& !piece.getMaterialType().getMaterial().getName().isEmpty()) {
					this.put(EngineKeys.MATERIAL_TYPE, piece.getMaterialType().getMaterial().getName());

				}
				if (piece.getVitreMaterialType() != null && piece.getVitreMaterialType().getMaterial() != null
						&& piece.getVitreMaterialType().getMaterial().getName() != null
						&& !piece.getVitreMaterialType().getMaterial().getName().isEmpty()) {
					this.put(EngineKeys.VITRE_MATERIAL_TYPE, piece.getVitreMaterialType().getMaterial().getName());					




			}
		}
			
			MechanicDesignElment elt = (MechanicDesignElment) emf;
			if (elt.isFacadeTypeFree() && elt.getFacadeType() != null && elt.getFacadeType().getKey() != null
					&& !elt.getFacadeType().getKey().isEmpty()) {
				this.put(EngineKeys.FACADE_TYPE, elt.getFacadeType().getKey());

			}

		}
		ArrayList<Equation> equations = new ArrayList<Equation>();
		GenericDebitage.createupdateDebitage(parent,this,privateparams,publicparams,emf,equations);
		if((Boolean) get("EXIST"))
		{
			evaluategeneric(equations);
		}
		equations.clear();

	}
	/**
	 * Cette methode est utilsie pour le debitage generique
	 * 
	 * @throws GeometricEngineException
	 * @throws DesignException
	 */
	public void evaluategeneric(ArrayList<Equation> equations) throws GeometricEngineException, DesignException
	{
		if(equations!=null)
		{
//			GenericDebitageFormula.EVALUATE(equations);
			GeomtericEngine.getInstance().setEquations(equations);
			GeomtericEngine.getInstance().reset();
			updateproperties(equations);
		}
		else
		{
			throw new DesignException("Debitage object is null");
		}
	}

	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException
	{
		setNotificationon(false);
		Equation eq = null;
		try {
			if(equations!=null)
			{
				eq  = Equation.FIND_EQUATION(EngineKeys.HauteurExt, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setHauteurext(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(this.name + " "+EngineKeys.HauteurExt +" not found to update");
				}
				eq  = Equation.FIND_EQUATION(EngineKeys.longeurExt, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setLongeurext(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.longeurExt +" not found to update");
				}
				eq  = Equation.FIND_EQUATION(EngineKeys.profondeurExt, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setProfondeurext(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.profondeurExt+" not found to update");
				}
				
				eq  = Equation.FIND_EQUATION(EngineKeys.posx, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setXpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.posx+" not found to update");
				}
				
				eq  = Equation.FIND_EQUATION(EngineKeys.posy, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setYpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.posy+" not found to update");
				}
				
				eq  = Equation.FIND_EQUATION(EngineKeys.posz, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setZpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.posz+" not found to update");
				}
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}

	}

	public IntersectionType isIntersect(DesignObject3D planche2) {

		DesignObject3D planche1 = this;
		Plan3D ppdroite = new Plan3D(planche1);
		Plan3D pphaut = new Plan3D(planche2);
		Plan3D intersection = ppdroite.getIntersection(pphaut);
		try {
			ppdroite.finalize();
			pphaut.finalize();
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		IntersectionType type=null;
		if(intersection.getXinter()==null || intersection.getYinter()==null|| intersection.getZinter()==null) {
			type= IntersectionType.NOT_RELATED;
		}else if(intersection.getXinter().isPoint() || intersection.getYinter().isPoint()|| intersection.getZinter().isPoint())
		{	
			type= IntersectionType.TANGENT;
		}else
		{
			type= IntersectionType.INTERSECTION;
		}
		try {
			intersection.finalize();
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		return type;
	}

	public Point3D getoppositPoint(DesignObject3D planche1) {
		return new Point3D();
	}

	public Point3D[] redifinePoints() {
		Point3D[] extremes = new Point3D[8];

		Point3D a;
		Point3D b;
		Point3D c;
		Point3D d;
		Point3D e;
		Point3D f;
		Point3D g;
		Point3D h;

		a = new Point3D(getXPosABS(), getYPosABS(), getZPosABS());

		b = a.Clone();
		b.setX(b.getX() + getLongeurext());

		c = b.Clone();
		c.setZ(c.getZ() + getProfondeurext());

		d = a.Clone();
		d.setZ(a.getZ() + getProfondeurext());

		e = a.Clone();
		e.setY(e.getY() + getHauteurext());

		f = e.Clone();
		f.setX(f.getX() + getLongeurext());

		g = f.Clone();
		g.setZ(g.getZ() + getProfondeurext());

		h = e.Clone();
		h.setZ(h.getZ() + getProfondeurext());

		extremes[0] = a;
		extremes[1] = b;
		extremes[2] = c;
		extremes[3] = d;
		extremes[4] = e;
		extremes[5] = f;
		extremes[6] = g;
		extremes[7] = h;
		return extremes;
	}

	public Plan3D getIntersect(DesignObject3D planche2) {

		DesignObject3D planche1 = this;
		Plan3D ppdroite = new Plan3D(planche1);
		Plan3D pphaut = new Plan3D(planche2);
		Plan3D intersection = ppdroite.getIntersection(pphaut);
		return intersection;
		 
	}
	
	public void createUsinage(List<Usinage> usins, boolean cavityOnly) throws GeometricEngineException, DesignException {
		List<DesignObject3D> list =  new ArrayList<DesignObject3D>();
		list.addAll(getChilds());
		list=list.stream().filter(design->!(design instanceof Usinage)).collect(Collectors.toList());
		for(DesignObject3D design:list) {
			design.createUsinage(usins,cavityOnly);
		}
	}

	public void deleteUsinage() throws GeometricEngineException, DesignException, Exception {
		for (DesignObject3D design : getChilds()) {
			design.deleteUsinage();
		}
	}

	public Boolean isHasTrous() {
		for (DesignObject3D design : getChilds()) {
			if (design instanceof Trou) {
				return true;
			}
			if (design.isHasTrous()) {
				return true;
			}
		}
		return false;
	}

	/**
	 * un méthode pour supprimer tous les trous contenus dans cette object3D ou un
	 * de ses fils
	 * 
	 * @throws Exception
	 */
	public void deleteTrous() throws Exception {
		for (DesignObject3D design : getChilds()) {
			if (design instanceof Trou) {
				this.deletechild(design, true);
			} else {
				design.deleteTrous();
			}
		}
	}

	public boolean ishasrainure() {
		// TODO Auto-generated method stub
		for (DesignObject3D design : getChilds()) {
			if (design instanceof Rainure && !(design instanceof Trou)) {
				return true;
			}
			if (design.ishasrainure()) {
				return true;
			}
		}
		return false;
	}

	public List<Couple> getSystemEquation(Object emf)
	{
		return null;
	}
	public ArrayList<Couple> getSystemesequations() {
		return null;
	}
	
	public ArrayList<Couple> getSystemEquationAsParent() {
		return null;
	}
	
	
	public Properties getProps() {
		return props;
	}

	public void setProps(Properties props) {
		this.props = props;
	}

	public Object put(Object key, Object value) {
//		Object oldvalue=this.getProperty((String) key);
//		firePropertyChange((String) key, oldvalue, value);
		return this.props.put(key, value);
	}

	public String getProperty(String key) {
		return this.props.getProperty(key);
	}

	public String getProperty(String key, String defaultValue) {
		return this.props.getProperty(key, defaultValue);
	}

	public synchronized boolean isEmpty() {
		return this.props.isEmpty();
	}

	public synchronized Enumeration<Object> keys() {
		return this.props.keys();
	}

	public synchronized Enumeration<Object> elements() {
		return this.props.elements();
	}

	public synchronized Object get(Object key) {
		return this.props.get(key);
	}

	public synchronized void clear() {
		this.props.clear();
	}

	public Set<Object> keySet() {
		return this.props.keySet();
	}

	public Collection<Object> values() {
		return this.props.values();
	}

	public synchronized Object getOrDefault(Object key, Object defaultValue) {
		return this.props.getOrDefault(key, defaultValue);
	}

	public synchronized boolean remove(Object key, Object value) {
		return this.props.remove(key, value);
	}

	public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
		return this.props.replace(key, oldValue, newValue);

	}

	public Set<Map.Entry<Object, Object>> entrySet() {
		return this.props.entrySet();
	}

	public synchronized boolean containsKey(Object key) {
		return this.props.containsKey(key);
	}

	/**
	 *
	 * @return chercher recursuvement pour les pieces 2D contenue dans un caisson ou
	 *         un espace3D
	 */
	public List<Piece2D> getListPieces() {
		List<Piece2D> pieces = new ArrayList<Piece2D>();
		for (DesignObject3D design : getChilds()) {
			if (design instanceof Piece2D) {
				pieces.add((Piece2D) design);
					pieces.addAll(design.getListPieces());
			} else {
				pieces.addAll(design.getListPieces());
			}
		}

		return pieces;
	}

	/**
	 *
	 * @return chercher recursuvement pour les pieces 2D contenue dans un caisson ou
	 *         un espace3D
	 */
	public List<Piece2D> getListCotes() {
		List<Piece2D> pieces = new ArrayList<Piece2D>();
		for (DesignObject3D design : getChilds()) {
			if (design instanceof Piece2D && design != null) {
				Piece2D piece = (Piece2D) design;
				if (piece.getPiecetype() != null && (piece.getPiecetype().equals(PieceType.COTE_DROITE)
						|| piece.getPiecetype().equals(PieceType.COTE_GAUCHE))) {
					pieces.add((Piece2D) design);
				}
			}
			if (design instanceof Piece2D || design instanceof Space3D) {
				pieces.addAll(design.getListCotes());
			}
		}

		return pieces;
	}

	public UUID getID() {
		return ID;
	}

	public void setID(UUID iD) {
		ID = iD;
	}

	public List<Usinage> getUsinages(DesignObject3D space) {
		List<Usinage> list = new ArrayList<Usinage>();
		if (space != null) {
			for (DesignObject3D ch : space.getChilds()) {
				if(ch instanceof Usinage && !(ch instanceof UsinageNode)) {
					list.add((Usinage) ch);
				} else {
					list.addAll(getUsinages(ch));
				}
			}
		}

		return list;
	}

	public MechanicDesign getMechanicDesignDefinition() {
		return mechanicDesignDefinition;
	}

	public void setMechanicDesignDefinition(MechanicDesign mechanicDesignDefinition) {
		Object old = this.mechanicDesignDefinition;
		this.mechanicDesignDefinition = mechanicDesignDefinition;
		firePropertyChange("mechanicDesignDefinition", old, mechanicDesignDefinition);
	}

	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}

	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected void finalize() throws Throwable {
		removeAllLsteners();
		super.finalize();
	}

	public float getFacadeThickness() {
		float thickness = 0;
		for (DesignObject3D designX : getListPieces()) {
			if (designX instanceof Piece2D) {
				Piece2D piece2D = (Piece2D) designX;
				if ((piece2D.getPiecetype() == PieceType.PORTE) || (piece2D.getPiecetype() == PieceType.PORTE_GAUCHE)
						|| (piece2D.getPiecetype() == PieceType.PORTE_DROITE
								|| piece2D.getPiecetype() == PieceType.FACADE
								|| piece2D.getPiecetype() == PieceType.PORTE_BAS
								|| (piece2D.getPiecetype() == PieceType.PORTE_HAUT))) {
					float pieceThickness = (float) piece2D.getProfondeurext();
					if (pieceThickness > thickness)
						thickness = pieceThickness;
				}
			}
		}
		return thickness;
	}

	public void update(boolean isuser) throws Exception {
		DesignObject3D parent = this.getParentdesign();
//		if(parent==null ) 
//		{
//			return;
//		}
		if((this instanceof Piece2D) && !this.mechanicDesignDefinition.getType().equals(param.PieceType.PIECE2D)){
			parent.update(isuser);
			return;
		}
		//check if the design registred in the parent module is the current one otherwise we update the registered one
		if(parent!=null && parent.getRootModule()!=null && ((Space3D) parent.getRootModule()).getDependenceController()!=null) {
			DesignObject3D systemDesign=((Space3D) parent.getRootModule()).getDependenceController().getIntsatanceToDefinition().get(this.mechanicDesignDefinition);
			if(systemDesign!=null && !systemDesign.equals(this)) {
				systemDesign.update(isuser);
				return;
			}
		}
		
		if(getRoot()!=null && isuser) {
			ProjectManager.getInstance().getRoot().setNotificationon(false);
		}
		boolean isDirectParent=true;
		PublicParamGroup publicparams = this.mechanicDesignDefinition.getPublicparamgroup();

		MechanicPublicParam ep = publicparams.getParam("global.ep");
		MechanicPublicParam epback = publicparams.getParam("global.epback");
		MechanicPublicParam epface = publicparams.getParam("global.epface");
		if(ep!=null)
		{
			ep.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getPrincipalmaterial().getEpaisseur()));
		}
		if(epback!=null)
		{
			epback.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getSecondmaterial().getEpaisseur()));
		}
		if(epface!=null)
		{
			epface.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getFacadeMaterial().getEpaisseur()));
		}

		
		clearautomatique(false);
		//if this design is contained in a structure Action we directy update the rootModule to regenerate the whole structure
		if (parent!=null && parent.getMechanicDesignDefinition()!=null&& parent.getMechanicDesignDefinition().getStructureAction() != null && parent.getMechanicDesignDefinition()
				.getStructureAction().getCreatedRefences().contains(this.mechanicDesignDefinition)) {
			((Space3DFree) parent.getRootModule()).update(true);
		} else
			//if this design is an obstacle we update the rootModule to regenerate the whole structure
			if(parent!=null && this.getMechanicDesignDefinition().getType().equals(param.PieceType.OBSTACLE)){
			((Space3DFree) parent.getRootModule()).update(true);
		}
		else {
			MechanicDesignCreator.getInstance().constructObject(parent, this, this.mechanicDesignDefinition,
					MechanicDesignCreator.update, false, isDirectParent, false);

		}
		if(getRoot()!=null && isuser) {
			ProjectManager.getInstance().getRoot().setNotificationon(true);
			ProjectManager.getInstance().getRoot().firePropertyChange("project.modify", 1, 2);
		}
	}

	public Kitchen getKitchen() {
		return kitchen;
	}

	public void setKitchen(Kitchen kitchen) {
		Kitchen oldValue = this.kitchen;
		this.kitchen = kitchen;
		firePropertyChange("kitchen", oldValue, this.kitchen);
	}

	public int getSceneNumber() {
		return sceneNumber;
	}

	public void setSceneNumber(int sceneNumber) {
		this.sceneNumber = sceneNumber;
	}

	public DesignObject3D getRootCaisson() {
		
		if(this instanceof Space3DFree && getMechanicDesignDefinition()!=null ) {
			return this;
		}else {
			if(getParentdesign()==null) {
				return null;
			}
			return getParentdesign().getRootCaisson();
		}
	}	
	
	public DesignObject3D getRootModule() {
		if(getParentdesign()!=null) {
			return getParentdesign().getRootModule();
		}
		
		return null; 
	}
	
	public void hideFacade(boolean hide) {
		if(this instanceof Piece2D && ((Piece2D)this).getPiecetype().isFacade()) {
			setVisible(hide);
		}else
			if( this instanceof Space3D) {
			
			try {
				if(getMechanicDesignDefinition() !=null) {
					MechanicPublicParam param=getMechanicDesignDefinition().getPublicParam("Piece_Type");
					if(param!=null && param.getTypedefelement()!=null&&param.getKey()!=null && param.getTypedefelement().getKey().contains("FACADE")) {
						setVisible(hide);
					}else {
						for(DesignObject3D child:getChilds()) {
							child.hideFacade(hide);
						}
					}
				}
				
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	public void showAll() {
		setVisible(true);
		for (DesignObject3D child : getChilds()) {
			child.showAll();
		}

	}

	public int getSceneIndex() {
		if (EmfUtils.isFausseFacade(this)) {
			return ProjectManager.getManager().getCurrentKitchen().getElementsFausseFacades().indexOf(this) + 1;

		} else {
			return ProjectManager.getManager().getCurrentKitchen().getElementsWithoutFausseFacades().indexOf(this) + 1;
		}
	}

	@SuppressWarnings("unchecked")
    @Override
    public <V, R> TransformManager<V, R> getTransformManager() {
        return (TransformManager<V, R>) transformManager;
    }

    @Override
    public <V, R> void setTransformManager(TransformManager<V, R> manager) {
        this.transformManager = manager;
    }

	public void dispose() {
		removeAllLsteners();

		for (DesignObject3D d : childs) {
			if (d != null)
				d.dispose();
		}

		if (mechanicDesignDefinition != null)
			mechanicDesignDefinition.dispose();
		childs.clear();
		props.clear();
		parentdesign = null;
		childs = null;
		mechanicDesignDefinition = null;
		props = null;
		propertyChangeSupport = null;
		kitchen = null;
	}
}
