package dressing.model;

import java.util.ArrayList;
import java.util.List;

import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.model.debitage.AssemblyContainerGenericDebitage;
import param.AssemblyContainer;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;

public class AssemblyContainerModel extends Usinage {

	private AssemblyContainer node;
	private Vector3 dimention;
	private Vector3 position;
	private Vector3 realWorldPosition;
	private FaceModel face;
	private List<Usinage> usinages=new ArrayList<Usinage>();
	private Piece2D parentPiece;
	private Piece2D motherPiece;

	public AssemblyContainerModel(AssemblyContainer node) {
		super();
		this.node = node;
		setName(node.getName());
	}

	public AssemblyContainerModel(AssemblyContainer node, FaceModel face) {
		super();
		this.node = node;
		this.face = face;
		setName(node.getName());
	}

	public Vector3 getDimention() {
		return dimention;
	}

	public void setDimention(Vector3 dimention) {
		this.dimention = dimention;
		
		setLongeurext(dimention.x);
		setHauteurext(dimention.y);
		setProfondeurext(dimention.z);
	}

	@Override
	public DesignObject3D getParentdesign() {
		
		return getFace().getPiece();
	}
	@Override
	public Solide3D getParent() {
		
		return getFace().getPiece();
	}

	public Vector3 getPosition() {
		return position;
	}

	public void setPosition(Vector3 position) {
		this.position = position;
		
	}
	
	public Vector3 getRealWorldPosition() {
		return realWorldPosition;
	}

	public void setRealWorldPosition(Vector3 realWorldPosition) {
		this.realWorldPosition = realWorldPosition;
		setXpos(realWorldPosition.x);
		setYpos(realWorldPosition.y);
		setZpos(realWorldPosition.z);
	}

	public AssemblyContainer getNode() {
		return node;
	}

	public void setNode(AssemblyContainer node) {
		this.node = node;
	}

	public FaceModel getFace() {
		return face;
	}

	public void setFace(FaceModel face) {
		this.face = face;
	}

	public List<Usinage> getUsinages() {
		return usinages;
	}

	public void setUsinages(List<Usinage> usinages) {
		this.usinages = usinages;
	}

	public void addUsinage(Usinage usin) throws DesignException, GeometricEngineException {
		this.usinages.add(usin);
		childs.add(usin);
	}
	@Override
	public boolean isdrawable() {
		return true;
	}
	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		return true;
	}
	
	
	public Piece2D getParentPiece() {
		return parentPiece;
	}

	public void setParentPiece(Piece2D parentPiece) {
		this.parentPiece = parentPiece;
	}

	public Piece2D getMotherPiece() {
		return motherPiece;
	}

	public void setMotherPiece(Piece2D motherPiece) {
		this.motherPiece = motherPiece;
	}

	@Override
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException {
		
		
		Equation x=Equation.FIND_EQUATION("@"+node.getPosition().getX().getKey()+"@", equations);
		Equation y=Equation.FIND_EQUATION("@"+node.getPosition().getY().getKey()+"@", equations);
		Equation z=Equation.FIND_EQUATION("@"+node.getPosition().getZ().getKey()+"@", equations);
		Vector3 containerPos=new Vector3();
		GeomtericEngine.getInstance().resolveEquation(x);
		GeomtericEngine.getInstance().resolveEquation(y);
		GeomtericEngine.getInstance().resolveEquation(z);
		containerPos.set((float)(x.getEvaluation(null)+0.0f), (float)(y.getEvaluation(null)+0.0f), (float)(z.getEvaluation(null)+0.0f));
		setPosition(containerPos);
		update();
	}

	/**
	 * 
	 */
	public void update() {
		//
		Matrix4 transform = face.getTransformMatrix();
		Matrix3 rotationMatrix = face.getRotationMatrix();
	
		Vector3 dim=new Vector3((float)node.getAssembly().getWidth(), (float)node.getAssembly().getLength(), (float)node.getAssembly().getDepth());
		dim =dim.cpy().mul(rotationMatrix);
		dim=new Vector3(Math.abs(dim.x), Math.abs(dim.y),Math.abs( dim.z));
		setDimention(dim);
		Vector3 images = getPosition().cpy().mul(transform);

		Vector3 decalage=new Vector3((float)node.getAssembly().getPosX(), (float)node.getAssembly().getPosY(), (float)node.getAssembly().getPosZ());
		Vector3 xpos=face.getDirX().toVector().scl(decalage.x);
		Vector3 ypos=face.getDirY().toVector().scl(decalage.y);
		Vector3 zpos=face.getDirZ().toVector().scl(decalage.z);
		decalage.set(0, 0, 0).add(xpos).add(ypos).add(zpos);
		images=images.add(decalage);
		
		images =images.sub(dim.cpy().scl(0.5f));

		setRealWorldPosition(images);
	}

	@Override
	public void constructGenericDebitage(List<MechanicPrivateParam> privateparams,
			List<MechanicPublicParam> publicparams, Object emf, DesignObject3D parent)
			throws DesignException, GeometricEngineException {
		ArrayList<Equation> equations = new ArrayList<Equation>();
//		Date deb=new Date();
		AssemblyContainerGenericDebitage.createupdateDebitage(parent , this,publicparams,node,equations);
		evaluategeneric(equations);
//		System.err.println("calcul assembly containrer took"+(new Date().getTime()-deb.getTime()));
	}
}
