
package dressing.handlers.reporting;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.Gdx;

import dressing.config.ReportingPreferences;
import dressing.io.IOUtilities;
import dressing.model.ProjectManager;
import dressing.ui.ReportPreferencesEditorWindow;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.SupercadProgressMonitorDialog;
import gdxapp.object3d.KitchenElement;
import gdxapp.screens.room3d.Room3DController;
import reporting.ReportWindow;
import reporting.htmlReporting.ProjectReport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CountDownLatch;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class FicheDebitReportHandler {
	boolean showUsin = false;
	boolean showUsinCotes = false;
	boolean groupedPiece = false;

	ReportWindow window;

	@Execute
	public void execute(Shell shell, ParameterizedCommand cmd) {
		FileDialog fileDialog = new FileDialog(shell, SWT.SINGLE);
		fileDialog.setText("Choisir Image pour la Cuisine");
		fileDialog.setFilterExtensions(new String[] { "*.png", "*.jpg", "*.jpeg", "*.gif" });
		String result = fileDialog.open();
		if (result == null || result.isEmpty())
			return;
		File file = new File(result);
		String destination = ProjectManager.getManager().getCurrentProject().getProjectDirectory();
		destination = destination + File.separator + "reporting" + File.separator + "screenshot.png";
		File destFile = new File(destination);
		destFile.getParentFile().mkdirs();
		try {
			destFile.createNewFile();
			IOUtilities.copyFileUsingChannel(file, destFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
		boolean ShowReportPreferencesWindow = ReportingPreferences.getInstance().getBoolean("user.ShowReportPreferencesWindow", false);
		if(ShowReportPreferencesWindow) {
			ReportPreferencesEditorWindow PreferencesWindow= new ReportPreferencesEditorWindow(shell);
			int ret =PreferencesWindow.open();
			if (ret == Window.OK) {
				generateReport(shell, destFile);
			}
		}else {
			generateReport(shell, destFile);
		}
		
	}

	private void generateReport(Shell shell, File destFile) {
		SupercadProgressMonitorDialog progressmonitor = new SupercadProgressMonitorDialog(shell);
		IRunnableWithProgress operation = new IRunnableWithProgress() {
			// This is the method that gets invoked when the operation runs.
			//
			@Override
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				monitor.beginTask("Génération du rapport", IProgressMonitor.UNKNOWN);
				CountDownLatch latch = new CountDownLatch(1);
				Gdx.app.postRunnable(new Runnable() {
					@Override
					public void run() {
								
						try {
							monitor.subTask("Capture des éléments...");
							for (KitchenElement element : ProjectManager.getManager().getCurrentScene()
									.getKitchenElements()) {
								element.generateImages();
							}
							monitor.subTask("Capture des vues murales...");
							List<String> wallViewsUrls = Room3DController.getInstance().takeWallViews();
							monitor.subTask("Génération du rapport...");
							ProjectReport report = new ProjectReport(
									ProjectManager.getManager().getCurrentProject(), destFile.getPath(),
									wallViewsUrls);
							report.generate(true);

						} catch (Exception e) {
							Display.getDefault().asyncExec(new Runnable() {
								@Override
								public void run() {
									MessageDialog.openError(shell, "error",
											"failed to create report!\n" + e.getMessage());
									e.printStackTrace();
								}
							});
						} finally {
							latch.countDown(); // Signal that the job is done
						}

					}
				});
				// Wait for the OpenGL job to complete
		        latch.await();
		        monitor.done();
			}
		};
		try {
			// This runs the options, and shows progress.
			//
			progressmonitor.run(true, false, operation);

		} catch (Exception exception) {
			// Something went wrong that shouldn't.
			//
			exception.printStackTrace();
		}
	}

	@CanExecute
	public boolean canExecute() {
		return ProjectManager.getManager().getCurrentProject().getCurrentKitchen().getElements().size() > 0;
	}

}