package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

import dressing.ui.project.OpenProjectWizard;
import dressing.ui.util.OpenWizardDialog;

public class OpenProjectHandler {

	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell) {
		OpenProjectWizard projectWizard = ContextInjectionFactory.make(OpenProjectWizard.class,eclipsecontext);
		OpenWizardDialog dialog = new OpenWizardDialog(shell, projectWizard);
		dialog.open();
	}
	
	@CanExecute
	public boolean check() {
		
		return true;
	}
}
