package dressing.handlers;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.events.EventDriver;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import com.badlogic.gdx.Gdx;

import dressing.model.types.PieceType;
import dressing.ui.parts.ProjectExplorerPart;
import gdxapp.object3d.KitchenElement;
import gdxapp.scenes.SceneEvent;

public class DeleteHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(EPartService partService,Shell shell){
		Object o = null;
		
		MPart part=partService.getActivePart();
		Object activePart = part.getObject();
		if(activePart instanceof ProjectExplorerPart){
		 	o = selectionService.getSelection("dressing.part.projectexplorer");
		 }
		 else {
			o= selectionService.getSelection("dressing.part.tree"); 
		 }
		//Voire l element de l arbre selectionne
		 if(o instanceof List) {
			 for(Object o1:(List)o) {
				 deleteElement(o1, shell); 
			 }
		 }else {
			 deleteElement(o, shell); 
		 }
	}
	@CanExecute
	public boolean check(EPartService partService)
	{
		Object o = null;
		
		MPart part=partService.getActivePart();
		Object activePart = part.getObject();
		if(activePart instanceof ProjectExplorerPart){
			 	o = selectionService.getSelection("dressing.part.projectexplorer");
			 	if( o instanceof Kitchen) {
			 		ProjectManager.getManager().getCurrentProject().removeKitchen((Kitchen)o);
			 	}else if (o instanceof Space3DFree) {
			 		for(Kitchen kitchen: ProjectManager.getManager().getCurrentProject().getKitchens()) {
			 			if(kitchen.containsElement((Space3DFree) o))
			 				kitchen.removeElement((Space3DFree) o);
			 		}
			 	}	
			 	
		 }else {
			o= selectionService.getSelection("dressing.part.tree"); 
		 }	
		 if(o instanceof List) {
			 for(Object o1:(List)o) {
				 if(!check(o1)) {
					 return false;	 
				 }
			 }
			 return true;
		 }else {
			return check(o);
		 }
	}
	
	public boolean check(Object o) {
//		if(o instanceof DesignObject3D)
//		{
//			if(o instanceof Piece2D)
//			{
//				return true;
//			}
//			else if(o instanceof Project3D)
//			{
//				return false;
//			}
//			else
//			{
//				return true;
//			}
//		}
		if(o instanceof Kitchen || o instanceof DesignObject3D) {
			return true;
		}
		return false;
	}
	public void deleteElement(Object o,Shell shell) {
		if(o!=null && o instanceof DesignObject3D)
		{
				DesignObject3D child = (DesignObject3D)o;
				if(child!= null && child.getParentdesign()!=null)
				{
					boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression", "Voulez vous supprimer "+child.getName());
					if (ret) {
						DesignObject3D parent = child.getParentdesign();
						
						/**
						 * tester si le child est une dos interieur il faut ajuster ces frère
						 */
						 
							try {
								
								if(ProjectManager.getInstance().getRoot()!=null) {
									ProjectManager.getInstance().getRoot().setNotificationon(false);
								}
								
								parent.deletechild(child, true);
								
								if(ProjectManager.getInstance().getRoot()!=null) {
									ProjectManager.getInstance().getRoot().setNotificationon(true);
									ProjectManager.getInstance().getRoot().firePropertyChange("project.child.delete", 1, 2);
								}
								;
								Gdx.app.postRunnable(new Runnable() {
									@Override
									public void run() {
										updateKitchenElement(parent.getRoot());
									}

								});
							}catch (Exception e) {					
								parent.setErrorexist(true);
								parent.setErrormsg(e.getMessage());
							}
						
						
					}

				}
			

		}		
	}
	private void updateKitchenElement(DesignObject3D rootspace) {
		DesignObject3D element=rootspace!=null? rootspace.getRoot():rootspace;
		if(element!=null) {
			KitchenElement kitchenElement =	ProjectManager.getInstance().getCurrentKitchen().getScene().getKitchenElement(element );
			kitchenElement.getObjectDimention();
//			float y = spny.getSelection() * 0.001f;
//			float altitude = y + dim.y / 2.0f;
//			kitchenElement.getRealWorldPosition().y = altitude;
			kitchenElement.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(SceneEvent.OBJECT_CHANGED, kitchenElement);
		}
	}
}
