package dressing.cam.model;

import java.util.ArrayList;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.CoordinateSystem;
import dressing.model.Piece2D;
import dressing.model.types.Orientation;

public class SystemCoordinateSwitcher {
	
	
	private Matrix4 machineTransform;

	public Vector3 toMachineCoordinate(Vector3 worldPoint) {
		Vector3 image = worldPoint.cpy().mul(this.machineTransform);
		return image;
	}
	

	
	void init(Piece2D piece) {
		
		ArrayList<CoordinateSystem> systems = CoordinateSystem.getMachineCoordSystem(piece);
		Matrix4 transform = null;
		
		Orientation orientation = piece.getPieceOrientation();
		
		switch(orientation) {
		case HORIZONTAL:
			transform = systems.get(1).transform;
			break;
		case VERTICAL:
			transform = systems.get(5).transform;
			break;
		case PROUFOUND:
			transform = systems.get(1).transform;
			break;
		default:
			transform = systems.get(0).transform;
			break;
		}
		
		this.machineTransform = transform;
	}
	
Matrix4 initMat(Piece2D piece) {
		
		ArrayList<CoordinateSystem> systems = CoordinateSystem.getMachineCoordSystem(piece);
		Matrix4 transform = null;
		
		Orientation orientation = piece.getPieceOrientation();
		
		switch(orientation) {
		case HORIZONTAL:
			transform = systems.get(1).transform;
			break;
		case VERTICAL:
			transform = systems.get(5).transform;
			break;
		case PROUFOUND:
			transform = systems.get(1).transform;
			break;
		default:
			transform = systems.get(0).transform;
			break;
		}
		
	  return  transform;
	}
}
