package supercad.persistence.databinding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public interface Mapper {

	public void write(Object value, OutputStream stream);
	
	public default void write(Object value, File file) {
		FileOutputStream fos;
		try {
			fos = new FileOutputStream(file);
			write(value, fos);
		}catch(FileNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	public <T> T fromXml(InputStream stream, Class<? extends T> clazz);
	
	public default <T> T fromXml(File file, Class<? extends T> clazz) {
		FileInputStream fis;
		try {
			fis = new FileInputStream(file);
			return fromXml(fis, clazz);
		}catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	
}
