package reporting.htmlReporting.model;

import java.util.HashMap;
import java.util.Map;

public class HtmlStyleAttribute extends HtmlAttribute{
	
	Map<String,String> styles=new HashMap<String, String>();
	
	
	public HtmlStyleAttribute() {
		super("style",';');
	}

	@Override
	public char getSeperator() {
		
		return ';';
	}
	
	@Override
	public String getContent() {
		StringBuilder sb=new StringBuilder();
		if(!getStyles().isEmpty())
		{	
			sb.append(getName());
			sb.append("=\"");	
			for(String seg:getStyles().keySet()) {
				
				sb.append(seg==null?"":seg+": "+getStyles().get(seg)+getSeperator()+" ");
			}
			sb.append("\"");
		}
		
		return sb.toString();
	}
	
	public void appendAttribute(String key,String value) {
		getStyles().put(key, value);
		
	}
	
	@Override
	protected String getSegmentContent(String seg) {
		return super.getSegmentContent(seg);
	}

	public Map<String, String> getStyles() {
		return styles;
	}

	public void setStyles(Map<String, String> styles) {
		this.styles = styles;
	}
	
	
}
