package gdxapp.fabs3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.types.PieceType;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.KitchenElement;
import gdxapp.shaders.PbrMaterial;
import jakarta.xml.bind.annotation.XmlRootElement;
import param.MaterialTypeInstance;
import param.Vertice3;

@XmlRootElement(name = "planche")
public class Planche {

	private ArrayList<Vector3> vertices;
	private ArrayList<Vector2> localVertices;
	private ArrayList<Vector2> extrusionVertices;
	float projection;
	float longueur;
	float hauteur;
	float profondeur;
	float thickness;
	float x;
	float y;
	float z;
	private Vector3 center;
	private Vector3 halfExtents;
	Piece2D piece2D;
	PieceType pieceType;
	ArrayList<Cavity> cavities;
	PbrMaterial material;
	private UUID id;
	private Object userData;
	private Matrix4 transform;
	

	public UUID getId() {
		return id;
	}

	public void setId(UUID id) {
		this.id = id;
	}

	public Planche() {
	}

	public Planche(Piece2D piece2d, KitchenElement object) {

		this.longueur = (float) piece2d.getLongeurext() / 1000;
		this.hauteur = (float) piece2d.getHauteurext() / 1000;
		this.profondeur = (float) piece2d.getProfondeurext() / 1000;
		// calculer les position de piece2D par rapport a la rootCaisson qui le contenue
		// dans plan absolue
		this.x = (float) (piece2d.getXPosABS() + piece2d.getLongeurext() / 2f) / 1000;
		this.y = (float) (piece2d.getYPosABS() + piece2d.getHauteurext() / 2f) / 1000;
		this.z = (float) (piece2d.getZPosABS() + piece2d.getProfondeurext() / 2f) / 1000;

		this.halfExtents = new Vector3(this.longueur, this.hauteur, this.profondeur).scl(0.5f);
		this.center = new Vector3(x, y, z);

		this.pieceType = piece2d.getPiecetype();
		this.piece2D = piece2d;
		//must be fixed
		MaterialTypeInstance mtlType = piece2d.getMaterialType();
//		if(mtlType.isIsColor()) {
//			mtlType.getMaterial().setAlbedo(mtlType.getColor());
//		}
		material = new PbrMaterial(mtlType.getMaterial());
		SceneTexture texture = ModelProvider.getMaterialSceneTexture(mtlType);
		if (!mtlType.isIsColor() && texture != null) {
			material.setAlbedoMapPath(texture.getPath());
		} else {
			material.setAlbedoMapPath(null);
			Vector3 color = mtlType.getColor() == null ? new Vector3()
					: new Vector3(mtlType.getColor().getR(), mtlType.getColor().getG(), mtlType.getColor().getB());
			material.setAlbedo(color);
		}

		for (DesignObject3D child : piece2d.getChilds()) {
			if (child instanceof Cavity) {
				if (cavities == null) {
					cavities = new ArrayList<Cavity>();
				}
				cavities.add((Cavity) child);
			}
		}
		this.id = piece2d.getID();

	}

	public Planche(float longueur, float hauteur, float profondeur, float x, float y, float z, String motif) {
		super();
		this.longueur = longueur;
		this.hauteur = hauteur;
		this.profondeur = profondeur;
		this.x = x;
		this.y = y;
		this.z = z;
		this.halfExtents = new Vector3(this.longueur, this.hauteur, this.profondeur).scl(0.5f);
		this.center = new Vector3(x, y, z);
		this.material = new PbrMaterial();
	}

	public void calculateTransform() {
		Vector3 origin = new Vector3(y, z, -x);
		float[] values;
		float minDimension = Math.min(Math.min(this.longueur, this.hauteur), this.profondeur);
		if (minDimension == this.longueur) {
			values = new float[] { 0, -1, 0, x, 0, 0, -1, z, 1, 0, 0, -x, 0, 0, 0, 1 };
		} else if (minDimension == this.hauteur) {
			values = new float[] { 1, 0, 0, -x, 0, 0, -1, z, 0, 1, 0, -y, 0, 0, 0, 1 };
		} else {
			values = new float[] { 0, 1, 0, -y, -1, 0, 0, x, 0, 0, 1, -z, 0, 0, 0, 1 };
		}
		transform = new Matrix4().set(values).tra();
	}

	// must be fixed
	// distinguish the case where the extrusion is on the edge of the plank
	public void setVertices() {

		calculateTransform();
		Vector3 origin = new Vector3(x, y, z);
		Vector3 extension = new Vector3(this.longueur / 2, this.hauteur / 2, this.profondeur / 2);
		if (piece2D.getPiecetype().isFacade()) {
			extension.sub(0.0005f, 0.0005f, 0.0005f);
		}

		ArrayList<Vector3> vertices3D = new ArrayList<Vector3>();
		vertices3D.add(origin.cpy().add(extension).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(1, 1, -1)).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(1, -1, 1)).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(1, -1, -1)).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(-1, 1, 1)).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(-1, 1, -1)).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(-1, -1, 1)).mul(transform));
		vertices3D.add(origin.cpy().add(extension.cpy().scl(-1, -1, -1)).mul(transform));

		HashMap<Float, ArrayList<Vector2>> faces = new HashMap<Float, ArrayList<Vector2>>();
		for (Vector3 vertex3D : vertices3D) {
			ArrayList<Vector2> verticesZ = faces.get(vertex3D.z);
			if (verticesZ == null) {
				verticesZ = new ArrayList<Vector2>();
				faces.put(vertex3D.z, verticesZ);
			}
			verticesZ.add(new Vector2(vertex3D.x, vertex3D.y));
		}

		Float[] heights = new Float[2];
		faces.keySet().toArray(heights);
		float top = Math.max(heights[0], heights[1]);
		Vector2[] borders = MathUtilities.getBoundariesPlane(faces.get(top));
		if (localVertices == null) {
			localVertices = new ArrayList<Vector2>();
		} else {
			localVertices.clear();
		}
		localVertices.add(new Vector2(borders[0]));
		localVertices.add(new Vector2(borders[0].x, borders[1].y));
		localVertices.add(new Vector2(borders[1]));
		localVertices.add(new Vector2(borders[1].x, borders[0].y));
		thickness = Math.abs(heights[0] - heights[1]);

		if (cavities != null) {
			for (Cavity cavity : cavities) {
				Vector3 cavityDimension = new Vector3((float) cavity.getLongeurext(), (float) cavity.getHauteurext(),
						(float) cavity.getProfondeurext()).scl(0.001f);
				Vector3 cavityPosition = new Vector3((float) cavity.getXPosABS(), (float) cavity.getYPosABS(),
						(float) cavity.getZPosABS()).scl(0.001f);
				Vector3 cavOrigin = cavityPosition.cpy().add(cavityDimension.cpy().scl(0.5f));
				Vector3 cavExtension = cavityDimension.cpy().scl(0.5f);
				ArrayList<Vector3> cavityVertices3D = new ArrayList<Vector3>();
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(1, 1, -1)).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(1, -1, 1)).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(1, -1, -1)).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(-1, 1, 1)).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(-1, 1, -1)).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(-1, -1, 1)).mul(transform));
				cavityVertices3D.add(cavOrigin.cpy().add(cavExtension.cpy().scl(-1, -1, -1)).mul(transform));
				float topLevel = cavityVertices3D.get(0).z;
				for (int i = 1; i < cavityVertices3D.size(); i++) {
					if (topLevel < cavityVertices3D.get(i).z)
						topLevel = cavityVertices3D.get(i).z;
				}
				ArrayList<Vector2> topCavityVertices = new ArrayList<Vector2>();
				for (Vector3 vertex : cavityVertices3D) {
					if (Math.abs(vertex.z - topLevel) < 0.001f) {
						topCavityVertices.add(new Vector2(vertex.x, vertex.y));
					}
				}
				Vector2[] boundaries = MathUtilities.getBoundariesPlane(topCavityVertices);
				topCavityVertices.clear();
				topCavityVertices.add(new Vector2(boundaries[0]));
				topCavityVertices.add(new Vector2(boundaries[1].x, boundaries[0].y));
				topCavityVertices.add(new Vector2(boundaries[1]));
				topCavityVertices.add(new Vector2(boundaries[0].x, boundaries[1].y));
				MathUtilities.setWinding(topCavityVertices, 1);
				// fuse lists
				int indexInCavityVertices = -1;
				int indexInPieceVertices = -1;
				for (int i = 0; i < topCavityVertices.size(); i++) {
					for (int j = 0; j < localVertices.size(); j++) {
						if (topCavityVertices.get(i).epsilonEquals(localVertices.get(j))) {
							indexInCavityVertices = i;
							indexInPieceVertices = j;
						}
					}
				}

				if (indexInCavityVertices >= 0) {
					int[] indices = new int[topCavityVertices.size() - 1];
					for (int c = 0; c < topCavityVertices.size() - 1; c++) {
						int index = indexInCavityVertices + 1 + c;
						index %= topCavityVertices.size();
						if (index < 0)
							index += topCavityVertices.size();
						indices[c] = index;
					}
					localVertices.remove(indexInPieceVertices);
					ArrayList<Vector2> cav = new ArrayList<Vector2>();
					for (int i = 0; i < indices.length; i++) {
						cav.add(topCavityVertices.get(indices[i]));
					}
					localVertices.addAll(indexInPieceVertices, cav);
				} else {
					// check if the cavity is tangent to an edge
					Edge pieceTangentEdge = null;
					Vector2 v0 = null, v1 = null;
					int fuseIndex = -1;
					for (int i = 0; i < localVertices.size(); i++) {
						int next = (i + 1) % localVertices.size();
						v0 = localVertices.get(i);
						v1 = localVertices.get(next);
						for (int j = 0; j < topCavityVertices.size(); j++) {
							float sumOfDistance = localVertices.get(i).dst(topCavityVertices.get(j))
									+ localVertices.get(next).dst(topCavityVertices.get(j));
							if (Math.abs(sumOfDistance - localVertices.get(i).dst(localVertices.get(next))) < 0.0001f) {
								pieceTangentEdge = new Edge(v0, v1);
								fuseIndex = i + 1; 
								break;
							}
						}
					}
					if (pieceTangentEdge != null) {
						// setting the order of the vertices
						MathUtilities.setWinding(topCavityVertices, MathUtilities.getWinding(localVertices.toArray(new Vector2[0])));
						
						int start = -1;
						int last = -1;
						
						for(int i =0; i < topCavityVertices.size()-1; i++) {
							if(topCavityVertices.get(i+1).cpy().sub(topCavityVertices.get(i))
									.isCollinear(pieceTangentEdge.getDirector())) {
								start = i;
								last = i+1;
								break;
							}
						}
						
						ArrayList<Vector2> cavityAddition = new ArrayList<Vector2>();
						if(start >=0) {
							int index = start;
							cavityAddition.add(topCavityVertices.get(index));
							do {
								index = (index -1)%topCavityVertices.size();
								index = index < 0?index + topCavityVertices.size():index;
								cavityAddition.add(topCavityVertices.get(index));
							}while(index != last);
						}
						localVertices.addAll(fuseIndex, cavityAddition);
					} else {
						extrusionVertices = new ArrayList<Vector2>();
						for (Vector2 vertex : topCavityVertices) {
							extrusionVertices.add(vertex);
						}
					}
				}
				//break;
			}
		}

	}

	Planche duplicate() {
		Planche clone = new Planche();
		clone.setHauteur(this.hauteur);
		clone.setLongueur(this.longueur);
		clone.setPieceType(this.pieceType);
		clone.setProfondeur(this.profondeur);
		clone.setX(this.x);
		clone.setY(this.y);
		clone.setZ(this.getZ());
		return clone;
	}

	public float getLongueur() {
		return longueur;
	}

	public void setLongueur(float longueur) {
		this.longueur = longueur;
	}

	public float getHauteur() {
		return hauteur;
	}

	public void setHauteur(float hauteur) {
		this.hauteur = hauteur;
	}

	public float getProfondeur() {
		return profondeur;
	}

	public void setProfondeur(float profondeur) {
		this.profondeur = profondeur;
	}

	public float getX() {
		return x;
	}

	public void setX(float x) {
		this.x = x;
	}

	public float getY() {
		return y;
	}

	public void setY(float y) {
		this.y = y;
	}

	public float getZ() {
		return z;
	}

	public void setZ(float z) {
		this.z = z;
	}

	public PbrMaterial getMaterial() {
		return material;
	}

	public PbrMaterial getVitreMaterial() {
		PbrMaterial material = AssetsTextures.getInstance().getMaterial("Verre Claire");
		if (getPiece2D() != null && getPiece2D().getVitreMaterialType() != null
				&& getPiece2D().getVitreMaterialType().getMaterial() != null) {
			material = AssetsTextures.getInstance()
					.getMaterial(getPiece2D().getVitreMaterialType().getMaterial().getName()).cpy();

			if (!getPiece2D().getVitreMaterialType().isIsColor()) {
				if (getPiece2D().getVitreMaterialType().getTexture() != null
						&& !getPiece2D().getVitreMaterialType().getTexture().isEmpty()) {
					String texture = ModelProvider.getMaterialSceneTexture(getPiece2D().getVitreMaterialType()).getPath();
					if (texture != null) {
						this.material.setAlbedoMapPath(texture);
					}
				}
			} else {
				Vertice3 color = getPiece2D().getVitreMaterialType().getColor();
				material.setAlbedo(new Vector3(color.getR(), color.getG(), color.getB()));
			}
		}
		return material;
	}

	public PieceType getPieceType() {
		return pieceType;
	}

	public void setPieceType(PieceType pieceType) {
		this.pieceType = pieceType;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}

	public ArrayList<Vector3> getVertices() {
		return vertices;
	}

	public void setVertices(ArrayList<Vector3> vertices) {
		this.vertices = vertices;
	}

	public float getProjection() {
		return projection;
	}

	public void setProjection(float projection) {
		this.projection = projection;
	}

	public Piece2D getPiece2D() {
		return piece2D;
	}

	public void setPiece2D(Piece2D piece2d) {
		piece2D = piece2d;
	}

	public Object getUserData() {
		return userData;
	}

	public void setUserData(Object userData) {
		this.userData = userData;
	}

	public ArrayList<Vector2> getLocalVertices() {
		return localVertices;
	}

	public void setLocalVertices(ArrayList<Vector2> localVertices) {
		this.localVertices = localVertices;
	}

	public ArrayList<Vector2> getExtrusionVertices() {
		if (extrusionVertices == null)
			extrusionVertices = new ArrayList<Vector2>();
		return extrusionVertices;
	}

	public void setExtrusionVertices(ArrayList<Vector2> extrusionVertices) {
		this.extrusionVertices = extrusionVertices;
	}

	public Matrix4 getTransform() {
		return transform;
	}

	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}

	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
	}

	public Vector3 getCenter() {
		return center;
	}

	public Vector3 getHalfExtents() {
		return halfExtents;
	}

}
