package dressing.ui.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

import dressing.cam.model.MachineCodeHandler;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;
import dressing.model.ProjectManager;
import dressing.model.ProjectRoot;
import dressing.model.Solide3D;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.model.Usinage;
import dressing.ui.ProjectTreeContentProvider;
import dressing.ui.modelprovders.DimHLabelProvider;
import dressing.ui.modelprovders.DimLLabelProvider;
import dressing.ui.modelprovders.DimPLabelProvider;
import dressing.ui.modelprovders.TreeElementLabelProvider;
import dressing.ui.util.ListenerSelection;
import param.PieceType;
import param.cam.MachineEngine;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;

public class ProjectExplorerPart {

	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;
	@Inject
	EPartService partService;
	@Inject
	private EHandlerService handlerService;
	@Inject
	private EModelService modelService;
	@Inject
	private ECommandService commandService;

	@Inject
	MWindow window;
	@Inject
	private MDirtyable dirty;
	@Inject
	private IEventBroker eventBroker;

	SuperCadProject project;
	ProjectRoot root;
	Object selectedObj;
	TreeViewer treeViewer;
	ListenerSelection listenerSelection;
	// selection control
	private boolean isUpdatingFromSelectionService = false;
	private boolean isUpdatingFromTreeViewer = false;

	@PostConstruct
	public void createControl(Composite parent ,MPart part) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new FormLayout());
		this.treeViewer = new TreeViewer(composite, SWT.BORDER | SWT.MULTI);
		Tree tree = treeViewer.getTree();
		FormData fd_tree = new FormData();
		fd_tree.top = new FormAttachment(0);
		fd_tree.left = new FormAttachment(0);
		fd_tree.bottom = new FormAttachment(100);
		fd_tree.right = new FormAttachment(100);
		tree.setLayoutData(fd_tree);

		treeViewer.setContentProvider(new ProjectTreeContentProvider());

		TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn column = viewerColumn.getColumn();
		column.setText("Nom");
		column.setWidth(300);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new TreeElementLabelProvider()));

		TreeViewerColumn viewerColumnL = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn columnL = viewerColumnL.getColumn();
		columnL.setText("Longeur");
		columnL.setWidth(50);
		viewerColumnL.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimLLabelProvider()));

		TreeViewerColumn viewerColumnH = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn columnH = viewerColumnH.getColumn();
		columnH.setText("Largeur");
		columnH.setWidth(50);
		viewerColumnH.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimHLabelProvider()));
		TreeViewerColumn viewerColumnP = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn columnP = viewerColumnP.getColumn();
		columnP.setText("Profondeur");
		columnP.setWidth(50);
		viewerColumnP.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimPLabelProvider()));

		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				if (isUpdatingFromSelectionService) return; // prevent loop

		        try {
		            isUpdatingFromTreeViewer = true;

					IStructuredSelection selection = (IStructuredSelection) event.getSelection();
					Object selectionobj = selection.size() == 1 ? selection.getFirstElement() : selection.toList();
					selectionService.setSelection(selectionobj);
					selectedObj = selectionobj;
					partService.activate(part);
		        } finally {
		            isUpdatingFromTreeViewer = false;
		        }
			}
		});
		listenerSelection = new ListenerSelection(selectionService);
		root = ProjectManager.getManager().getRoot();

		root.addPropertyChangeListener(new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				if (!treeViewer.getControl().isDisposed()) {
					treeViewer.getControl().getDisplay().asyncExec(new Runnable() {
						@Override
						public void run() {
							if (!treeViewer.getControl().isDisposed()) {
								treeViewer.refresh(true);
								treeViewer.getAutoExpandLevel();
								dirty.setDirty(true);
							}
						}
					});
				}
			}
		});

		treeViewer.setInput(this.root);

		eventBroker.subscribe("newprojectcreated", new EventHandler() {
			@Override
			public void handleEvent(Event event) {
				ProjectManager.getManager().openCurrentProject();
				project = ProjectManager.getManager().getCurrentProject();
				root.setProject(project);
				project.setRoot(root);

			}
		});

		eventBroker.subscribe("Add_MODEL", new EventHandler() {
			@Override
			public void handleEvent(Event event) {
				Object obj = ProjectExplorerPart.this.selectedObj;
				if (obj != null && obj instanceof Kitchen) {
					Object data = event.getProperty("org.eclipse.e4.data");
					if (data != null && data instanceof Space3D) {
						DesignObject3D designobject = (DesignObject3D) data;
						Kitchen kitchen = (Kitchen) obj;
						try {
							kitchen.addElement(designobject);
						} catch (DesignException e) {
							e.printStackTrace();
						}
					}
				}
			}
		});
		selectionService.addSelectionListener(new ISelectionListener() {

			@Override
			public void selectionChanged(MPart part, Object selection) {
				if (isUpdatingFromTreeViewer)
				{
					partService.activate(part);
					return; // prevent loop
				}
				
				if (part.getElementId().contentEquals("dressing.part.editor3d")
						|| part.getElementId().contentEquals("dressing.part.gdx")) {
					if (selection != null && selection instanceof Solide3D) {
						if (!treeViewer.getControl().isDisposed()) {
							try {
								isUpdatingFromSelectionService = true;

								treeViewer.refresh(true);
								treeViewer.collapseAll();
								treeViewer.expandToLevel(selection, treeViewer.getAutoExpandLevel());
								treeViewer.setSelection(new StructuredSelection(selection), true);

							} finally {
								isUpdatingFromSelectionService = false;
							}
						}
					}
				} else {
					treeViewer.refresh(true);

				}

			}
		});
		// menu
		MenuManager menuMgr = new MenuManager();

		Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
		menuMgr.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				if (treeViewer.getSelection().isEmpty()) {
					return;
				}
				if (treeViewer.getSelection() instanceof IStructuredSelection) {
					IStructuredSelection selection = (IStructuredSelection) treeViewer.getSelection();
					Object object = selection.getFirstElement();
					if(object==null) {
						return;
					}
					// Imed bug 0001710 ajouter une action pour exporter un projet vers dxf
					Action exportdxfAction = new Action("Exporter DXF") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.exportdxf", null);
							handlerService.executeHandler(cmd);
						};
					};
					Action exportgcodeActionAction = new Action("Exporter Gcode") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.saveas", null);
							handlerService.executeHandler(cmd);
						};
					};
					Action ExportGcodeSCMTotal = new Action("Export Gcode SCM Total") {
						public void run() {
							ParameterizedCommand cmd = commandService
									.createCommand("dressing.command.ExportGcodeSCMTotal", null);
							handlerService.executeHandler(cmd);
						};
					};
					Action ExportGcodeSCMPartiel = new Action("Export Gcode SCM Partiel") {
						public void run() {
							ParameterizedCommand cmd = commandService
									.createCommand("dressing.command.ExportGcodeSCMPartiel", null);
							handlerService.executeHandler(cmd);
						};
					};

					Action generateUsinageAction = new Action("Générer Usinage") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.usinage.trou",
//							ParameterizedCommand cmd = commandService.createCommand("dressing.command.generategcode",
									null);
							handlerService.executeHandler(cmd);
						};
					};
					Action generateFicheDebitAction = new Action("Générer rapport fiche du débitage") {
						public void run() {
							ParameterizedCommand cmd = commandService
									.createCommand("dressing.command.generate.kitchen.report.cmd", null);
							handlerService.executeHandler(cmd);
						};
					};
					Action modifyElementAction = new Action("Modifier") {
                    	public void run() {
                    		ParameterizedCommand cmd = commandService.createCommand("dressing.command.modifyObject", null);                        	
                    		handlerService.executeHandler(cmd);
                    	};
					};
					Action addApplicableAction = new Action("Ajouter un Applicable") {
                      	public void run() {
                      		ParameterizedCommand cmd = commandService.createCommand("dressing.command.AddApplicableWindow", null);                        	
                      		handlerService.executeHandler(cmd);
                      	};
  					};
  					if(object instanceof DesignObject3D &&  ((DesignObject3D) object).getMechanicDesignDefinition()!=null &&(object instanceof Space3DFree || 
  							(((DesignObject3D) object).getMechanicDesignDefinition().getType().equals(PieceType.PIECE2D) && object instanceof Piece2D)) )
  					{
  						manager.add(modifyElementAction);
  						manager.add(addApplicableAction);
  					}
					if ((object instanceof DesignObject3D && !(object instanceof Usinage))
							|| object instanceof Kitchen) {
						manager.add(new Action("Copier les pièces vers Excell -Sans Grouper") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_NONE);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});

						manager.add(new Action("Copier les pièces vers Excell -Grouper Tous") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_ALL);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Parent") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_PARENT);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Projet") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_PROJECT);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Dressing") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby",
										Piece2DCoupe.GROUPBY_DRESSING);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Caisson") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_CAISSON);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
//						manager.add(new Action("Générer SVG") {
//							public void run() {
//								HashMap<String, Object> param = new HashMap<>();
//								param.put("dressing.commandparameter.svgsubject.piece", "svg");
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.generersvg", param);
//								handlerService.executeHandler(cmd);
//							};
//						});
//						//
//						manager.add(new Action("Appliquer Accessoires") {
//							public void run() {
//								ArrayList<DesignObject3D>listpiece=new ArrayList<DesignObject3D>();
//								listpiece=(ArrayList<DesignObject3D>) ((DesignObject3D)object).getChilds();
//								String objectname=((DesignObject3D)object).getName();
//								HashMap<String, Object> param = new HashMap<>();
//								param.put("dressing.commandparameter.AppliquerAccessoire", objectname);
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.AppliquerAccessoire", param);
//								handlerService.executeHandler(cmd);
//							};
//						});
				
				
					}

					if (object instanceof SuperCadProject) {

//						manager.add(new Action("Ajouter un dressing") {
//							public void run() {
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.create.wizard", null);
//								handlerService.executeHandler(cmd);
//							};
//						});
//						manager.add(new Action("Ajouter une cuisine") {
//							public void run() {
//								ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.cuisine",
//										null);
//								handlerService.executeHandler(cmd);
//							};
//						});
//						manager.add(new Action("Fermer") {
//							public void run() {
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.close.project", null);
//								handlerService.executeHandler(cmd);
//							};
//						});
//						manager.add(new Action("Générer rapport avec usinage") {
//							public void run() {
//								HashMap<String, Object> param = new HashMap<>();
//								param.put("dressing.commandparameter.reportWithUsin", "true");
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.birtreport", param);
//								handlerService.executeHandler(cmd);
//							};
//						});

//						manager.add(new Action("Générer rapport avec usinage Côtés") {
//							public void run() {
//								HashMap<String, Object> param = new HashMap<>();
//								param.put("dressing.commandparameter.reportWithUsin", "false");
//								param.put("dressing.commandparameter.reportWithUsinCote", "true");
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.birtreport", param);
//								handlerService.executeHandler(cmd);
//							};
//							public boolean isEnabled() {
//								HashMap<String, Object> param = new HashMap<>();
//								param.put("dressing.commandparameter.reportWithUsin", "false");
//								param.put("dressing.commandparameter.reportWithUsinCote", "true");
//								ParameterizedCommand cmd = commandService
//										.createCommand("dressing.command.birtreport", param);
//								return handlerService.canExecute(cmd);
//							};
//							
//						});
						manager.add(generateFicheDebitAction);
					}
					// Imed bug 0001710 ajouter une action pour exporter un projet vers dxf
					if (object != null && !(object instanceof Usinage)) {
						boolean isProject = object instanceof Kitchen || object instanceof SuperCadProject;
						boolean isDesign = object instanceof DesignObject3D;
						boolean isSpaceFree = object instanceof Space3DFree;

						if (isProject || isDesign) {
							manager.add(generateUsinageAction);
							manager.add(exportdxfAction);
						}
						if (isProject || isSpaceFree) {
							MachineEngine engine = ResourceManagers.getIntance().getPreference().getConfig().getEngine();
							String code = engine.getCode();
							if (!code.contentEquals(MachineCodeHandler.SCM)) {
								manager.add(exportgcodeActionAction);
							} else {
								manager.add(ExportGcodeSCMTotal);
								manager.add(ExportGcodeSCMPartiel);
							}
						}
					}
					if (object instanceof DesignObject3D && ((DesignObject3D) object).isDirectlyDelatable() ) {
						manager.add(new Action("Supprimer") {
							public void run() {
								ParameterizedCommand cmd = commandService.createCommand("dressing.command.delete",
										null);
								handlerService.executeHandler(cmd);
							};
						});
					}
				}
			}
		});
		menuMgr.setRemoveAllWhenShown(true);
		treeViewer.getControl().setMenu(menu);

	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		treeViewer.getControl().setFocus();
	}

	@Persist
	public void save() throws DesignException {
		if (ProjectManager.getManager().getCurrentProject() != null) {
			ProjectManager.getManager().saveProject(ProjectManager.getManager().getCurrentProject(), false, false);
			dirty.setDirty(false);
		}
	}

}
