package dressing.ui.modelprovders;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3DFree;
import dressing.model.types.PieceType;

public class NameLabelProvider extends LabelProvider implements IStyledLabelProvider {
	public  Display display;
	
	
    public NameLabelProvider() {
		super();
	}

	public NameLabelProvider(Display display) {
		super();
		this.display = display;
	}

	@Override
    public StyledString getStyledText(Object element) {
    	if(element!=null && element instanceof Space3DFree)
    	{       
    		Space3DFree piece = (Space3DFree) element;
        		// a directory is just a container and has no size
    			Styler namestyle  = new Styler() {
					
					@Override
					public void applyStyles(TextStyle textStyle) {
						// TODO Auto-generated method stub
						if(piece.isErrorexist())
						{
							textStyle.background = display.getSystemColor(SWT.COLOR_RED);
						}
					}
				};
    			StyledString stytl = new StyledString(""+piece.getName(),namestyle);
    			
    			Styler dimstyle = new Styler() {
					
					@Override
					public void applyStyles(TextStyle textStyle) {
						// TODO Auto-generated method stub
						textStyle.foreground = display.getSystemColor(SWT.COLOR_BLUE);
					}
				};
    			stytl.append(" ["+piece.getLongeurext()+"]", dimstyle);
        		return stytl;
    		
    	}
    	
    	else if (element!=null && element instanceof DesignObject3D) {
        	DesignObject3D piece = (DesignObject3D) element;

                // a directory is just a container and has no size
                return new StyledString(""+piece.getName());
        }
        return new StyledString(" ");
    }

	@Override
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		String s =null;
		if(element instanceof Space3DFree){
			s="icons/caissoncuisine.png";
		}
		
		else if(element instanceof Piece2D)
		{
			Piece2D piece=(Piece2D)element;
			if(piece.getPiecetype().equals(PieceType.PORTE)) {
				s="icons/singleporteIcon.png";
			}else if(piece.getPiecetype().equals(PieceType.PORTE_DROITE)||piece.getPiecetype().equals(PieceType.PORTE_GAUCHE)
					||piece.getPiecetype().equals(PieceType.PORTE_HAUT)||piece.getPiecetype().equals(PieceType.PORTE_BAS)) {
				s="icons/porte16.png";
			}
			else if(piece.getPiecetype().equals(PieceType.HAUT_CUISSON)) {
				s="icons/hautIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.BAS_CUISSON)||piece.getPiecetype().equals(PieceType.BAS_TIROIR)) {
				s="icons/basIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.DROITE_CUISSON)||piece.getPiecetype().equals(PieceType.COTE_DROITE_TIROIR)) {
				s="icons/droiteIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.GAUCHE_CUISSON)||piece.getPiecetype().equals(PieceType.COTE_GAUCHE_TIROIR)) {
				s="icons/gaucheIcon16.png";
			}
			
			else  {
				s="icons/piece16.jpg";
			}
			
		
		}
		
		if(s !=null)
		{
			Bundle bundle = FrameworkUtil.getBundle(NameLabelProvider.class);
			URL url = FileLocator.find(bundle, new Path(s), null);
			ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
			ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
			Image im = rsmanager.createImage(descriptor);

			return im;
		}

		return super.getImage(element);
	}

	
}