package dressing.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.ModulesPreferences;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.model.EngineKeys;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.ui.util.CommonStringExtractor;
import dressing.ui.Assemblage.AssemblyPreferencesComposite;
import dressing.ui.editorWindows.DesignOptionParamEditorWindow;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.util.DesignELementMaterialComposite;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageLoaderCache;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.MaterialTypeInstanceComposite;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.StaticUiObjects;
import dressing.ui.util.TypeDefElementLabelProvider;
import param.AccessoireInstanceGroup;
import param.Material;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicDressing;
import param.MechanicPublicParam;
import param.ModelRoot;
import param.Option;
import param.OptionGroup;
import param.ParamFamily;
import param.ParamFamilyGroup;
import param.PieceType;
import param.PublicParamGroup;
import param.QuincaillerieInstanceGroup;

public class MechanicDeisgnEditorUtil extends Composite {

	protected Text name;
	protected MechanicDesign design;
	protected Map<MechanicPublicParam,PublicParamEditorComposite> dirtyParams = new HashMap<MechanicPublicParam,PublicParamEditorComposite>();
	protected Map<MechanicPublicParam,PublicParamEditorComposite> ParamsCompositeMap = new HashMap<MechanicPublicParam,PublicParamEditorComposite>();
	protected Map<OptionGroup,ComboViewer> dirtyOptions = new HashMap<OptionGroup,ComboViewer>();
	protected ScrolledComposite model_scrolledComposite;
	protected CTabFolder tabFolder;
	protected CTabItem tbtmGnral;
	protected CTabItem tbtmComponents;
	protected CTabItem tbtmConception;
	protected CTabItem tbtmModel;
	protected Composite composite_model_1;
	protected TableComboViewer tableComboVwr_facademat;
	protected MaterialTypeInstanceComposite facadeMaterialType;
	protected TableComboViewer tableComboVwr_Eltmat;
	protected MaterialTypeInstanceComposite elementMaterialType;
	protected TableComboViewer tableComboVwr_Dosmat;
	protected MaterialTypeInstanceComposite dosMaterialType;
	protected Composite composite_general;
	protected Composite composite_components;
	protected Composite composite_conception;
	public Map<MechanicDesignElment, DesignELementMaterialComposite> elmentMaterialsEditors = new HashMap<MechanicDesignElment, DesignELementMaterialComposite>();
	protected CTabItem tbtmModelElements;
	protected ScrolledComposite general_scrolledComposite;
	protected ScrolledComposite components_scrolledComposite;
	protected ScrolledComposite conception_scrolledComposite;
	protected ListPieceModelComoposite pieceModel_Composite;
	protected DesignObject3D rootspace;
	protected Button btnfacadematLibre_1;
	protected Button btnEltmatLibre_1;
	protected Button btnDosmatLibre_1;
	protected Group groupChant;
	protected Button btnChantFacadeLibre;
	protected Button btnChantElementLibre;
	protected TableComboViewer tableComboVwr_ChantElement;
	protected TableComboViewer tableComboVwr_ChantFacade;
	protected int update;
	protected boolean ismodel;
	protected CTabItem tbtmArticles;
	protected Text txtAppartement;
	protected Text txtChantier;
	protected Text txtEtage;
	protected AccessoireInstanceGroup accessoiresGroup; 
	protected QuincaillerieInstanceGroup quincailleriesGroup; 

	public MechanicDeisgnEditorUtil(Composite parent, int style) {
		super(parent, style);
	}

	protected Composite createGeneralTab() {
		tbtmGnral = new CTabItem(tabFolder, SWT.NONE);
		tbtmGnral.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmGnral.setText("Général");
		//
		general_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		general_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		general_scrolledComposite.setExpandHorizontal(true);
		general_scrolledComposite.setExpandVertical(true);
		composite_general = new Composite(general_scrolledComposite, SWT.FILL);
		composite_general.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		composite_general.setLayoutData(gd_composite_1);
		GridLayout composite_generallayout =new GridLayout(2, false);
		composite_generallayout.marginHeight=0;
		composite_generallayout.marginWidth=0;
		composite_generallayout.verticalSpacing=0;
		composite_general.setLayout(composite_generallayout);
		populateGeneralTab();
		
	
		general_scrolledComposite.setContent(composite_general);
		general_scrolledComposite.setSize(composite_general.computeSize(SWT.MIN, SWT.MIN));
		general_scrolledComposite.setMinSize(composite_general.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		tbtmGnral.setControl(general_scrolledComposite);
		composite_general.pack();
		return composite_general;
	}

	/**
	 * 
	 */
	protected void populateGeneralTab() {
		createDressingDetails();
		if(getDesign()!=null && getDesign().getPublicparamgroup()!=null) {
			List<MechanicPublicParam> params=new ArrayList<MechanicPublicParam>();
			params.addAll(getDesign().getPublicparamgroup().getMechanicpublicparam());
			List<OptionGroup> options=new ArrayList<OptionGroup>();
			options.addAll(design.getOptionsParams());
			if(getDesign().getPublicparamgroup().getParametersFamilies()!=null) {
				createDesignParamFamilies(composite_general, design.getPublicparamgroup().getParametersFamilies(), params,options);
			}else {
				createFamiliesGroup(composite_general, params, design.getPublicparamgroup());
			}
			List<MechanicPublicParam> remainingParams=new ArrayList<MechanicPublicParam>();
	
			//filter
			for(MechanicPublicParam param:params) {
				if(param!=null&&param.isChangeable()) {
					if(this.update==MechanicDesignCreator.update && !ismodel)
					{
						if (param.getKey().contentEquals("SEPRATEUR_TRANSVERSANT")) {
							continue;
						}
						if(EngineKeys.listabsoluteRefecences.contains(param.getKey())) {
							continue;
						}
					}
					
					remainingParams.add(param);
					
				 }
			}
			addOptionParams(options);
			if(!remainingParams.isEmpty()) {
				Group gr=new Group(composite_general, SWT.NONE);
				gr.setLayout(new GridLayout(2, false));
				gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
				gr.setText("Autre");
				gr.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
				for(MechanicPublicParam param:remainingParams) {
					createParamComposite(param, gr);
				}
				gr.setSize(gr.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	
			}
			
		}
	}

	/**
	 * 
	 */
	private void createDressingDetails() {
		if(design instanceof MechanicDressing || design.getType().equals(PieceType.DRESSING)) {
			Group gr=new Group(composite_general, SWT.NONE);
			gr.setLayout(new GridLayout(2, false));
			gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));
			gr.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
	
			gr.setText("Détail");
			
			Label lblchantier = new Label(gr, SWT.NONE);
			lblchantier.setText("Chantier");
			lblchantier.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
			txtChantier = new Text(gr, SWT.BORDER);
			txtChantier.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			txtChantier.setText(((MechanicDressing)design).getChantier());
			lblchantier.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			Label lblEtage = new Label(gr, SWT.NONE);
			lblEtage.setText("Étage");
			lblEtage.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
			txtEtage = new Text(gr, SWT.BORDER);
			txtEtage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			txtEtage.setText(((MechanicDressing)design).getEtage());
			lblEtage.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			Label lblAppartement = new Label(gr, SWT.NONE);
			lblAppartement.setText("Appartement");
			lblAppartement.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
			lblAppartement.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			txtAppartement = new Text(gr, SWT.BORDER);
			txtAppartement.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			txtAppartement.setText(((MechanicDressing)design).getAppartement());
			
		}
	}

	/**
	 * @param options 
	 * 
	 */
	protected void addOptionParams(List<OptionGroup> options) {
		if(options!=null && options.size()>0) {
			Group gr=new Group(composite_general, SWT.NONE);
			gr.setLayout(new GridLayout(2, false));
			gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
			gr.setText("Options");
			gr.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			for(OptionGroup group:options) {
				
				createOptionParamComposite(gr, group);
			}
			gr.setSize(gr.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		}
	}

	/**
	 * @param parent
	 * @param optionGroup
	 */
	private void createOptionParamComposite(Composite parent, OptionGroup optionGroup) {
		Label lblName = new Label(parent, SWT.NONE);
		lblName.setText(optionGroup.getName());
		lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblName.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		ElementComboSelect comboselect = new ElementComboSelect(parent, SWT.NONE) {
//			@Override
//			public void listElements() {
//				OptionParamsListWindow OptionParamsListWindow = new OptionParamsListWindow(getShell(),optionGroup);
//				OptionParamsListWindow.create();
//				OptionParamsListWindow.open();
//				
//			}

			@Override
			public IContentProvider getContentProvider() {
				// TODO Auto-generated method stub
				return ArrayContentProvider.getInstance();
			}

			@Override
			public IBaseLabelProvider getLabelProvider() {
				// TODO Auto-generated method stub
				return TypeDefElementLabelProvider.getInstance();
			}

			@Override
			public Object getinput() {
				// TODO Auto-generated method stub
				return optionGroup.getOptions();
			}

			@Override
			public void addElement() {
				param.Option option= EcoreUtil.copy(optionGroup.getSelectedOption());
				DesignOptionParamEditorWindow designOptionWindow=new DesignOptionParamEditorWindow(getShell(),EditorWindow.update, option);
				designOptionWindow.create();
				if(designOptionWindow.open()==Window.OK) {
					optionGroup.getOptions().add(option);
					getComboViewer().refresh();
				}
			}
			@Override
			public void Modify() {
				DesignOptionParamEditorWindow designOptionWindow=new DesignOptionParamEditorWindow(getShell(),EditorWindow.update, (Option) getComboViewer().getStructuredSelection().getFirstElement() );
				designOptionWindow.create();
				designOptionWindow.open();
			}

			@Override
			public ListEditorWindow getListEditorWindow() {
				// TODO Auto-generated method stub
				return new OptionParamsListWindow(getShell(),optionGroup);
			}
		};
		comboselect.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		comboselect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		ComboViewer comboViewer = comboselect.getComboViewer();
		if(optionGroup.getSelectedOption()!=null) {
			comboViewer.setSelection(new StructuredSelection(optionGroup.getSelectedOption()), true);
		}
		comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				// TODO Auto-generated method stub
				dirtyOptions.put(optionGroup, comboViewer);
				Option selecetedOption=((Option)(comboViewer.getStructuredSelection().getFirstElement()));
				EList<MechanicPublicParam> publicParams=selecetedOption.getInjectedPublicParam().getMechanicpublicparam();
				if( publicParams!=null && !publicParams.isEmpty()) {
					for(MechanicPublicParam publicParam:publicParams) {	
						try {
							PublicParamEditorComposite composite =ParamsCompositeMap.get(design.getPublicParam(publicParam.getKey()));
							if(composite==null) {
								design.getPublicParam(publicParam.getKey()).set(publicParam);
								return;
							}
							composite.setValues(publicParam,true);	
							MechanicDeisgnEditorUtil.this.redraw();
							MechanicDeisgnEditorUtil.this.pack();
							MechanicDeisgnEditorUtil.this.requestLayout();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			}
		});
	}

	protected Composite createArticlesTab(boolean isShowAccessoire, boolean isShowQuicaillerie) {
		tbtmArticles = new CTabItem(tabFolder, SWT.NONE);
		tbtmArticles.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		String tabName="";
		if(isShowAccessoire) {
			tabName="Accessoires";
		}
		if(isShowQuicaillerie) {
			tabName=isShowAccessoire?"Accessoires et Quincaillerie":"Quincaillerie";
		}
		tbtmArticles.setText(tabName);
		//
	
		MecahnicDesignAccesoireComposite composite_Articles = new MecahnicDesignAccesoireComposite(tabFolder,this.quincailleriesGroup,this.accessoiresGroup, SWT.FILL);
		
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		composite_Articles.setLayoutData(gd_composite_1);
		composite_Articles.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
	
		tbtmArticles.setControl(composite_Articles);
		composite_Articles.pack();
		return composite_Articles;
	}

	public boolean containsChildsPublicParams() {
		if(design!=null && !design.getMechanicdesign().isEmpty())
		{
			for(MechanicDesign child:design.getMechanicdesign()) {
				if(child!=null && !child.getPublicparamgroup().getMechanicpublicparam().isEmpty()) {
					for(MechanicPublicParam param:child.getPublicparamgroup().getMechanicpublicparam()) {
						if(param.isExport()) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	public boolean containsChildsPublicConcurrentParams() {
		if(design!=null && !design.getMechanicdesign().isEmpty())
		{
			for(MechanicDesign child:design.getMechanicdesign()) {
				if(child!=null && !child.getPublicparamgroup().getMechanicpublicparam().isEmpty()) {
					for(MechanicPublicParam param:child.getPublicparamgroup().getMechanicpublicparam()) {
						if(param.isExportConcurrent()) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	public Map<MechanicDesign, List<MechanicPublicParam>> collectChildsPublicParams() {
		Map<MechanicDesign, List<MechanicPublicParam>> designsParams=new HashMap<MechanicDesign, List<MechanicPublicParam>>();
		if(design!=null && !design.getMechanicdesign().isEmpty())
		{
			for(MechanicDesign child:design.getMechanicdesign()) {
				if(child!=null && !child.getPublicparamgroup().getMechanicpublicparam().isEmpty()) {
					List<MechanicPublicParam> designParams=child.getPublicparamgroup().getMechanicpublicparam().stream().filter(p-> p.isExport()).collect(Collectors.toList());
					designsParams.put(child, designParams);
				}
			}
		}
		return designsParams;
	}

	public Map<MechanicDesign, List<MechanicPublicParam>> collectChildsConcurrentPublicParams() {
		Map<MechanicDesign, List<MechanicPublicParam>> designsParams=new HashMap<MechanicDesign, List<MechanicPublicParam>>();
		if(design!=null && !design.getMechanicdesign().isEmpty())
		{
			for(MechanicDesign child:design.getMechanicdesign()) {
				if(child!=null && !child.getPublicparamgroup().getMechanicpublicparam().isEmpty()) {
					List<MechanicPublicParam> designParams=child.getPublicparamgroup().getMechanicpublicparam().stream().filter(p-> p.isExportConcurrent()).collect(Collectors.toList());
					designsParams.put(child, designParams);
				}
			}
		}
		return designsParams;
	}

	protected Composite createComponentsConfigTab() {
			tbtmComponents = new CTabItem(tabFolder, SWT.NONE);
			tbtmComponents.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
			tbtmComponents.setText("Composants");
			//
	
			Map<MechanicDesign, List<MechanicPublicParam>> designParams=collectChildsPublicParams();
	
			int comlumncount=	designParams.values().stream().mapToInt(List::size).max().orElse(0);
			Map<UUID ,List<MechanicDesign>> childsperid=new HashMap<UUID, List<MechanicDesign>>();
			for(MechanicDesign design:designParams.keySet()) {
				if(!childsperid.containsKey(design.getModelId())) {
					List<MechanicDesign> idchilds=new ArrayList<MechanicDesign>();
					idchilds.add(design);
					childsperid.put(design.getModelId(), idchilds);
				}else {
					childsperid.get(design.getModelId()).add(design);
				}
			}
			//
			components_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
			components_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
			components_scrolledComposite.setExpandHorizontal(true);
			components_scrolledComposite.setExpandVertical(true);
			composite_components = new Composite(components_scrolledComposite, SWT.FILL);
			
			GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
			composite_components.setLayoutData(gd_composite_1);
			composite_components.setLayout(new GridLayout(1, false));
			composite_components.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			for(UUID id:childsperid.keySet()) {
				List<MechanicDesign> idchilds=childsperid.get(id).stream().filter(child-> !(designParams.containsKey(child)&&designParams.get(child).isEmpty())).collect(Collectors.toList());
				if(idchilds.isEmpty()) {
					continue;
				}
				Group composite = new Group(composite_components, SWT.NONE);
				composite.setText(getcompactedName(idchilds));
				composite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
				composite.setLayout(new GridLayout((comlumncount)+1, false));
				composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
				new Label(composite, SWT.NONE);
				 List<MechanicPublicParam> refs=designParams.get(idchilds.get(0));
					for(MechanicPublicParam param:refs) {
						Label lblName = new Label(composite, SWT.WRAP);
						lblName.setText(param.getUserlabel());
						GridData gd=new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
						lblName.setLayoutData(gd);
						lblName.setBackground(composite.getBackground());
					}
					if(refs.size()<comlumncount) {
						for(int i=0;i<comlumncount-refs.size();i++) {
							new Label(composite, SWT.NONE);
	//						new Label(composite_components, SWT.NONE);
		
						}
					}
				List<MechanicDesign> designchildren =new ArrayList<MechanicDesign>();
				designchildren.addAll(design.getMechanicdesign());
				designchildren.retainAll(idchilds);
				for(MechanicDesign child:designchildren) {
					if(designParams.containsKey(child)&&designParams.get(child).isEmpty()) {
						continue;
					}
					Label lblName = new Label(composite, SWT.NONE);
					lblName.setText(child.getName());
					lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
					lblName.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		
					List<MechanicPublicParam> params=designParams.get(child);
					for(MechanicPublicParam param:params) {
						if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty() && param.getDefaultvalue().contains("@")) {
							continue;
						}
						PublicParamEditorComposite paramEditor=new PublicParamEditorComposite(composite, SWT.NONE, param,dirtyParams,false); 
						ParamsCompositeMap.put(param, paramEditor);
					}
					if(params.size()<comlumncount) {
						for(int i=0;i<comlumncount-params.size();i++) {
							new Label(composite, SWT.NONE);
		
						}
					}
				}
			
			}
			composite_components.setSize(composite_components.computeSize(SWT.DEFAULT, SWT.DEFAULT));
			components_scrolledComposite.setContent(composite_components);
			components_scrolledComposite.setSize(composite_components.computeSize(SWT.MIN, SWT.MIN));
			components_scrolledComposite.setMinSize(composite_components.computeSize(SWT.DEFAULT, SWT.DEFAULT));
			tbtmComponents.setControl(components_scrolledComposite);
			composite_components.pack();
			return composite_components;
		}
	public String getcompactedName(List<MechanicDesign> designs) {
		List<String[]> nameparts=new ArrayList<String[]>();
		if(designs.size()>1) {
			for(MechanicDesign piece:designs) {
				nameparts.add(piece.getName().split(" "));
			}
			String[] compactedArray=CommonStringExtractor.extractCommonStrings(nameparts);
			String compoactedname=compactedArray.length>0?String.join(" ",compactedArray ):designs.get(0).getName();
			
			return compoactedname;

		}else {
			return designs.get(0).getName();
		}
	}
	protected Composite createComponentsConceptionConfigTab() {
		tbtmConception = new CTabItem(tabFolder, SWT.NONE);
		tbtmConception.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmConception.setText("Conception");
		//
		conception_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		conception_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		conception_scrolledComposite.setExpandHorizontal(true);
		conception_scrolledComposite.setExpandVertical(true);
		composite_conception = new Composite(conception_scrolledComposite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		composite_conception.setLayoutData(gd_composite_1);
		composite_conception.setLayout(new GridLayout(2, false));
		composite_conception.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		conception_scrolledComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		
		Map<MechanicDesign, List<MechanicPublicParam>> designchildsParams=collectChildsConcurrentPublicParams();
		ExpandBar expandBar = new ExpandBar(composite_conception, SWT.V_SCROLL);
		expandBar.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		expandBar.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		for (MechanicDesign child : design.getMechanicdesign()) {
			if (designchildsParams.containsKey(child) && designchildsParams.get(child).isEmpty()) {
				continue;
			}
			ExpandItem xpndtmClass = new ExpandItem(expandBar, SWT.NONE);
			xpndtmClass.setText(child.getName());
	
			ScrolledComposite scrolledComposite = new ScrolledComposite(expandBar,
					SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
			xpndtmClass.setControl(scrolledComposite);
			scrolledComposite.setExpandHorizontal(true);
			scrolledComposite.setExpandVertical(true);
			Composite composite_3 = new Composite(scrolledComposite, SWT.NONE);
			composite_3.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
	
			composite_3.setLayout(new GridLayout(2, false));
			//
			
			List<MechanicPublicParam> params = designchildsParams.get(child);
			if(child.getPublicparamgroup().getParametersFamilies()!=null) {
				List<OptionGroup> options=new ArrayList<OptionGroup>();
				options.addAll(child.getOptionsParams());
				createDesignParamFamilies(composite_3, child.getPublicparamgroup().getParametersFamilies(), params, options);
			}else {
				for (MechanicPublicParam param : params) {
					createParamComposite(param, composite_3);
				}
			}
			
			xpndtmClass.setHeight(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT).y+10);
			xpndtmClass.getControl().setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			
			//
			scrolledComposite.setContent(composite_3);
			scrolledComposite.setMinSize(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		}
		expandBar.addExpandListener(new ExpandListener() {
			
			@Override
			public void itemExpanded(ExpandEvent e) {
				
				for(ExpandItem item:	expandBar.getItems()) {
					if(!item.equals(e.item)) {
						item.setExpanded(false);
					}
				}
				
			}
			
			@Override
			public void itemCollapsed(ExpandEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		composite_conception.setSize(composite_conception.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		conception_scrolledComposite.setContent(composite_conception);
		conception_scrolledComposite.setSize(composite_conception.computeSize(SWT.MIN, SWT.MIN));
		conception_scrolledComposite.setMinSize(composite_conception.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		tbtmConception.setControl(conception_scrolledComposite);
		composite_conception.pack();
		return composite_conception;
	}

	protected void createFamiliesGroup(Composite parent, List<MechanicPublicParam> params, PublicParamGroup paramGroup) {
		Map<ParamFamily,List<Object>> famParams=new HashMap<ParamFamily, List<Object>>();
		List<ModelRoot> roots = ResourceManagers.getIntance().getModelroots();
		List<ParamFamily> families=new ArrayList<ParamFamily>();
		for(ModelRoot root:roots) {
			ParamFamilyGroup famGroup=root.getParametersFamilies();
			if(famGroup!=null && !famGroup.getFamilies().isEmpty()) {
				for(ParamFamily fam:famGroup.getFamilies()) {
					List<Object> famchilds =collectFamilyGroup(fam, params, paramGroup);
					if(famchilds!=null && !famchilds.isEmpty()) {
						famParams.put(fam, famchilds);
					}
				}
				families.addAll(famGroup.getFamilies());
			}
		}
		if(!families.isEmpty() && !famParams.isEmpty())
		{
			createFamilyGroup(famParams,families,parent);
		}

	}

	protected void createDesignParamFamilies(Composite parent, ParamFamily family, List<MechanicPublicParam> params, List<OptionGroup> options) {
		if(family==null) {
			return ;
		}
		Composite composite = new Composite(parent, SWT.FILL);
		composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		composite.setLayoutData(gd_composite_1);
		GridLayout composite_generallayout =new GridLayout((int)family.getNbColonne(), false);
		composite_generallayout.marginHeight=0;
		composite_generallayout.marginWidth=0;
		composite_generallayout.verticalSpacing=0;
		composite.setLayout(composite_generallayout);
		
		if(family.getParams()!=null && !family.getParams().isEmpty()&& family.isVisible()) {
			Group gr=new Group(composite, SWT.SHADOW_ETCHED_OUT);
			gr.setLayout(new GridLayout(2, false));
			gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false,(int)family.getNbColonne(), 1));
			gr.setText(family.getLabel());
			gr.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			List<MechanicPublicParam> filtered = filter(family.getParams());
			filtered.retainAll(params);
			for(MechanicPublicParam param:filtered) {
				createParamComposite(param, gr);
				params.remove(param);
			}
			
		}
		if(family.getOptionParams()!=null && !family.getOptionParams().isEmpty()&& family.isVisible()) {
			List<OptionGroup> familyOptionParams=	family.getOptionParams();
			familyOptionParams.retainAll(options);
			for(OptionGroup group:familyOptionParams) {
				createOptionParamComposite(composite, group);
				options.remove(group);
			}
		}
		if(!params.isEmpty())
		{
			createSubFamiliesDesignParams(family, composite,params,options);
		}
	}
	protected List<MechanicPublicParam> filter(List<MechanicPublicParam> params){
		List<MechanicPublicParam> filtered=new  ArrayList<MechanicPublicParam>();
		for(MechanicPublicParam param:params) {
			if(this.update==MechanicDesignCreator.update && !ismodel)
			{
				if (param.getKey().contentEquals("SEPRATEUR_TRANSVERSANT")) {
					continue;
				}
				if(EngineKeys.listabsoluteRefecences.contains(param.getKey())) {
					continue;
				}
			}
			if(!param.isChangeable()) {
				continue;
			}
			filtered.add(param);
		}
		return filtered;
	}
	protected boolean checkFamily(ParamFamily family) {
		boolean useUsinage = ModulesPreferences.getInstance().getProperty("use.usinage", true);
		List<MechanicPublicParam> filtered = filter(family.getParams());
		if(filtered.isEmpty()&& family.getSubFamilies().isEmpty()&& family.getOptionParams().isEmpty()) {
			return false;
		}else if( !family.isVisible()) {
			return false;
		}else if(!useUsinage && family.isUsinage()) {
			return false;
		}
		else if(!filtered.isEmpty()){
			return true;
		}else if(!family.getOptionParams().isEmpty()) {
			return true;
		}
		else {
			for(ParamFamily sub:family.getSubFamilies()) {
				if(checkFamily(sub)) {
					return true;
				}
			}
			return false;
		}
		
	}
	protected void createSubFamiliesDesignParams(ParamFamily family, Composite parent, List<MechanicPublicParam> params, List<OptionGroup> options) {
		if(family.getSubFamilies()!=null && !family.getSubFamilies().isEmpty()) {
			if(family.isIsChildFamiliesGroups()) {
				for(ParamFamily sub:family.getSubFamilies()) {
					List<MechanicPublicParam> filtered =new ArrayList<MechanicPublicParam>();
					filtered.addAll(sub.getParams());
					filtered.retainAll(params);
					filtered = filter(filtered);
					if(!checkFamily(sub)) {
						params.removeAll(getFamilyTreeParams(sub));
						continue;
					}
					Group gr=new Group(parent, SWT.SHADOW_ETCHED_OUT);
					gr.setLayout(new GridLayout((int) sub.getNbColonne(), false));
					gr.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, family.getParams().size()>0?(int)family.getNbColonne():1, 1));
					gr.setText(sub.getLabel());
					gr.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					//
					if(sub.getOptionParams()!=null && !sub.getOptionParams().isEmpty()) {
						List<OptionGroup> familyOptionParams=	sub.getOptionParams();
						familyOptionParams.retainAll(options);
						for(OptionGroup group:familyOptionParams) {
							createOptionParamComposite(gr, group);
							options.remove(group);
						}
					}
					//
					for(MechanicPublicParam param:filtered) {
						createParamComposite(param, gr);
						params.remove(param);
					}
					//
					if(!params.isEmpty())
					{
						createSubFamiliesDesignParams(sub, gr,params, options);
					}
				}
			}else if (family.isIsChildFamiliesExpandBar()) {
				if(!checkFamily(family)) {
					return;
				}
				ExpandBar expandBar = new ExpandBar(parent, SWT.V_SCROLL);
				expandBar.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
				expandBar.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, (int) family.getNbColonne(), 1));
				for(ParamFamily sub:family.getSubFamilies()) {
					List<MechanicPublicParam> filtered =new ArrayList<MechanicPublicParam>();
					filtered.addAll(sub.getParams());
					filtered.retainAll(params);
					filtered = filter(filtered);
					if(!checkFamily(sub)) {
						params.removeAll(getFamilyTreeParams(sub));
						continue;
					}
					ExpandItem xpndtmClass = new ExpandItem(expandBar, SWT.NONE);
					xpndtmClass.setText(sub.getName());
	
					ScrolledComposite scrolledComposite = new ScrolledComposite(expandBar,
							SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
					scrolledComposite.setExpandHorizontal(true);
					scrolledComposite.setExpandVertical(true);
					scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, (int) sub.getNbColonne(), 1));
					Composite composite_3 = new Composite(scrolledComposite, SWT.NONE);
	
					composite_3.setLayout(new GridLayout((int) sub.getNbColonne(), false));
					scrolledComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					composite_3.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					//
					if(sub.getOptionParams()!=null && !sub.getOptionParams().isEmpty()) {
						List<OptionGroup> familyOptionParams=	sub.getOptionParams();
						familyOptionParams.retainAll(options);
						for(OptionGroup group:familyOptionParams) {
							createOptionParamComposite(composite_3, group);
							options.remove(group);
						}
					}
					for(MechanicPublicParam param:filtered) {
						createParamComposite(param, composite_3);
						params.remove(param);
					}
					if(!params.isEmpty())
					{
						createSubFamiliesDesignParams(sub, composite_3,params, options);
					}
					//
					scrolledComposite.setContent(composite_3);
					scrolledComposite.setMinSize(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT));
					xpndtmClass.setControl(scrolledComposite);
					xpndtmClass.setHeight(scrolledComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT).y+10);
					xpndtmClass.getControl().setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					
					//
					
				}
				expandBar.setSize(parent.getSize());
				if(expandBar.getItemCount()>0)
				{
					expandBar.getItem(0).setExpanded(true);
				}
				expandBar.addExpandListener(new ExpandListener() {
					
					@Override
					public void itemExpanded(ExpandEvent e) {
						
						for(ExpandItem item:	expandBar.getItems()) {
							if(!item.equals(e.item)) {
								item.setExpanded(false);
							}
						}
						
					}
					
					@Override
					public void itemCollapsed(ExpandEvent e) {
						// TODO Auto-generated method stub
						
					}
				});
			}else if (family.isIsChildFamiliesTabbedPane()){
				CTabFolder	tabFolder = new CTabFolder(parent, SWT.BORDER);
				tabFolder.setHighlightEnabled(true);
				tabFolder.setSimple(false);
				tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, (int) family.getNbColonne(), 1));
				tabFolder.setSelectionBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));
				tabFolder.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
				tabFolder.setBorderVisible(true);
				for(ParamFamily sub:family.getSubFamilies()) {
					List<MechanicPublicParam> filtered =new ArrayList<MechanicPublicParam>();
					filtered.addAll(sub.getParams());
					filtered.retainAll(params);
					filtered = filter(filtered);

					if(!checkFamily(sub)) {
						params.removeAll(getFamilyTreeParams(sub));
						continue;
					}
					CTabItem	tbtmArticles = new CTabItem(tabFolder, SWT.NONE);
					tbtmArticles.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 12, SWT.BOLD));
					tbtmArticles.setText(sub.getName());
					ScrolledComposite	scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
					scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
					scrolledComposite.setExpandHorizontal(true);
					scrolledComposite.setExpandVertical(true);
//					scrolledComposite.setAlwaysShowScrollBars(true);
					Composite composite = new Composite(scrolledComposite, SWT.FILL);
					GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
					composite.setLayoutData(gd_composite_1);
					GridLayout clayout=new GridLayout((int) sub.getNbColonne(), false);
					composite.setLayout(clayout);
					scrolledComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					//
					if(sub.getOptionParams()!=null && !sub.getOptionParams().isEmpty()) {
						List<OptionGroup> familyOptionParams=	sub.getOptionParams();
						familyOptionParams.retainAll(options);
						for(OptionGroup group:familyOptionParams) {
							createOptionParamComposite(composite, group);
							options.remove(group);
						}
					}
					//
					for(MechanicPublicParam param:filtered) {
						createParamComposite(param, composite);
						params.remove(param);
					}
					if(!params.isEmpty())
					{
						createSubFamiliesDesignParams(sub, composite,params, options);
					}
					//
					composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
					scrolledComposite.setContent(composite);
					scrolledComposite.setSize(composite.computeSize(SWT.MIN, SWT.MIN));
					scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
					tbtmArticles.setControl(scrolledComposite);
					composite.pack();
					
				}
	
				
				tabFolder.setSelection(0);
				tabFolder.requestLayout();
				tabFolder.redraw();
			}else {
				for(ParamFamily sub:family.getSubFamilies()) {
					List<MechanicPublicParam> filtered =new ArrayList<MechanicPublicParam>();
					filtered.addAll(sub.getParams());
					filtered.retainAll(params);
					filtered = filter(filtered);

					if(!checkFamily(sub)) {
						params.removeAll(getFamilyTreeParams(sub));
						continue;
					}
					Composite composite = new Composite(parent, SWT.FILL);
					GridData gd_composite_1 = new GridData(SWT.FILL, SWT.TOP, true, false, family.getParams().size()>0?(int)family.getNbColonne():1, 1);
					composite.setLayoutData(gd_composite_1);
					composite.setLayout(new GridLayout((int) sub.getNbColonne(), false));
					composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
					//
					if(sub.getOptionParams()!=null && !sub.getOptionParams().isEmpty()) {
						List<OptionGroup> familyOptionParams=sub.getOptionParams()	;
						familyOptionParams.retainAll(options);
						for(OptionGroup group:familyOptionParams) {
							createOptionParamComposite(composite, group);
							options.remove(group);
						}
					}
					//
					for(MechanicPublicParam param:filtered) {
						createParamComposite(param, composite);
						params.remove(param);
					}
					if(!params.isEmpty())
					{
						createSubFamiliesDesignParams(sub, composite,params, options);
					}
				}
			}
		}
	}
	protected List<MechanicPublicParam> getFamilyTreeParams(ParamFamily family) {
		List<MechanicPublicParam> filtered =new ArrayList<MechanicPublicParam>();
		filtered.addAll(family.getParams());
		filtered = filter(filtered);
		for(ParamFamily sub:family.getSubFamilies()) {
			filtered.addAll(getFamilyTreeParams(sub));
		}
		return filtered;
	}
	protected void createParamComposite(MechanicPublicParam param, Composite parent) {
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty() && param.getDefaultvalue().contains("@")) {
			return;
		}
		PublicParamEditorComposite paramEditor = new PublicParamEditorComposite(parent, SWT.NONE, param,dirtyParams,true);
		ParamsCompositeMap.put(param, paramEditor);
	}

	protected void createFamilyGroup(Map<ParamFamily, List<Object>> famchilds, List<ParamFamily> families, Composite parent) {
		if(!famchilds.isEmpty()) {
			for(ParamFamily family:families) {
				if(famchilds.containsKey(family)) {
					Group gr=new Group(parent, SWT.SHADOW_ETCHED_OUT);
					gr.setLayout(new GridLayout(2, false));
					gr.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, famchilds.get(family).size()/2));
					gr.setText(family.getLabel());
					gr.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
	
					for(Object child:famchilds.get(family)) {
						if(child instanceof MechanicPublicParam) {
							createParamComposite((MechanicPublicParam) child, gr);
						}else if(child instanceof Map) {
							createFamilyGroup((Map<ParamFamily, List<Object>>) child,family.getSubFamilies(), gr);
						}
					}
					gr.setSize(gr.computeSize(SWT.DEFAULT, SWT.DEFAULT));
				}
				
			}
		}
		
	}

	protected List<Object> collectFamilyGroup(ParamFamily family, List<MechanicPublicParam> params, PublicParamGroup paramGroup) {
		List<Object> childs=new ArrayList<Object>();
		if(!family.getKeys().isEmpty()) {
			List<MechanicPublicParam> familyparams=new ArrayList<MechanicPublicParam>();
			for(String key:family.getKeys()) {
				
				if(this.update==MechanicDesignCreator.update && !ismodel)
				{
					if (key.contentEquals("SEPRATEUR_TRANSVERSANT")) {
						continue;
					}
					if(EngineKeys.listabsoluteRefecences.contains(key)) {
						continue;
					}
				}
				
				try {
					MechanicPublicParam param=	paramGroup.getParam(key);
					if(param!=null && params.contains(param)&& param.isChangeable()) {
						familyparams.add(param);
						params.remove(param);
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if(!familyparams.isEmpty()) {
				childs.addAll(familyparams);
			}
			
	
		}
		if(family.getSubFamilies()!=null && !family.getSubFamilies().isEmpty()) {
			Map<ParamFamily,Object> famParams=new HashMap<ParamFamily, Object>();
			for(ParamFamily fam:family.getSubFamilies()) {
				List<Object> famchilds=collectFamilyGroup(fam, params, paramGroup);
				if(famchilds!=null) {
					famParams.put(fam,famchilds);
				}
			}
			if(!famParams.isEmpty()) {
				childs.add(famParams);
			}
		}
		if(childs.isEmpty()) {
			return null;
		}
		 
		return childs;
	}

	protected Composite createModelTabComposite() {
		tbtmModel = new CTabItem(tabFolder, SWT.NONE);
		tbtmModel.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmModel.setText("Modèle");
		model_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		model_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		model_scrolledComposite.setExpandHorizontal(true);
		model_scrolledComposite.setExpandVertical(true);
		
		composite_model_1 = new Composite(model_scrolledComposite, SWT.NONE);
		tbtmModel.setControl(model_scrolledComposite);
		composite_model_1.setLayout(new GridLayout(10, false));
		model_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		Label lblFacade_2 = new Label(composite_model_1, SWT.NONE);
		lblFacade_2.setText("Façade");
		SingleImageItemLabelProvider matLabelProvider=SingleImageItemLabelProvider.getInstance();
		tableComboVwr_facademat = new TableComboViewer(composite_model_1, SWT.NONE);
		TableCombo tableCombo = tableComboVwr_facademat.getTableCombo();
		tableCombo.setEditable(false);
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo.defineColumns(StaticUiObjects.MaterialColumns);
		tableComboVwr_facademat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_facademat.setLabelProvider(matLabelProvider);
		
		tableComboVwr_facademat.setInput(getMaterials());
		//
		btnfacadematLibre_1 = new Button(composite_model_1, SWT.CHECK);
		btnfacadematLibre_1.setText("Libre");
		btnfacadematLibre_1.setSelection(design.isFacadeMaterialFree());
		//
		tableComboVwr_facademat.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_facademat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if(se2!=null &&se2 instanceof Material ) {
					Material mat=(Material) se2;
					if(mat.isApplyTexture()&& mat.getImage()!=null && !mat.getImage().isEmpty()) {
						SceneTexture texture=ModelProvider.getMaterialSceneTexture(mat);
						if(texture!=null)
						{
							facadeMaterialType.getTableComboViewerTexture().setSelection(new StructuredSelection(texture), true);
						}

					}
				}
			}
		});
		Button btnList = new Button(composite_model_1, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = 30;
		gd_btnList.heightHint = 30;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow=new MaterialListWindow(getShell(), null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret=listWindow.open();
				tableComboVwr_facademat.setInput(getMaterials());
				tableComboVwr_facademat.refresh();
				if(ret==Window.OK) {
					tableComboVwr_facademat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		//
		facadeMaterialType = new MaterialTypeInstanceComposite(composite_model_1,SWT.NONE);
		facadeMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		facadeMaterialType.setSize(facadeMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		btnfacadematLibre_1.addSelectionListener(new SelectionAdapter() {
	
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnfacadematLibre_1.getSelection()) {
					tableComboVwr_facademat.getControl().setEnabled(true);
					facadeMaterialType.setEnabled(true);
				}else {
					tableComboVwr_facademat.getControl().setEnabled(false);
					facadeMaterialType.setEnabled(false);
				}
			}
			
		});
		//
		Label lblElement_1 = new Label(composite_model_1, SWT.NONE);
		lblElement_1.setText("Élément");
		
		tableComboVwr_Eltmat = new TableComboViewer(composite_model_1, SWT.NONE);
		TableCombo tableCombo_1 = tableComboVwr_Eltmat.getTableCombo();
		tableCombo_1.setEditable(false);
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo_1.defineColumns(StaticUiObjects.MaterialColumns);
		tableComboVwr_Eltmat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_Eltmat.setLabelProvider(matLabelProvider);
		tableComboVwr_Eltmat.setInput(getMaterials());
		
		btnEltmatLibre_1 = new Button(composite_model_1, SWT.CHECK);
		btnEltmatLibre_1.setText("Libre");
		btnEltmatLibre_1.setSelection(design.isPrincipalMaterialFree());
		//
		tableComboVwr_Eltmat.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_Eltmat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if(se2!=null &&se2 instanceof Material ) {
					Material mat=(Material) se2;
					if(mat.isApplyTexture()&& mat.getImage()!=null && !mat.getImage().isEmpty()) {
						SceneTexture texture=ModelProvider.getMaterialSceneTexture(mat);
						if(texture!=null)
						{
							elementMaterialType.getTableComboViewerTexture().setSelection(new StructuredSelection(texture), true);
						}
						
					}
				}
			}
		});
 		Button btnList2 = new Button(composite_model_1, SWT.CENTER);
		GridData gd_btnList2 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList2.widthHint = 30;
		gd_btnList2.heightHint = 30;
		btnList2.setLayoutData(gd_btnList2);
		btnList2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow=new MaterialListWindow(getShell(), null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret=listWindow.open();
				tableComboVwr_Eltmat.setInput(getMaterials());
				tableComboVwr_Eltmat.refresh();
				if(ret==Window.OK) {
					tableComboVwr_Eltmat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList2.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		//
		elementMaterialType = new MaterialTypeInstanceComposite(composite_model_1,SWT.NONE);
		elementMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		elementMaterialType.setSize(elementMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		btnEltmatLibre_1.addSelectionListener(new SelectionAdapter() {
	
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnEltmatLibre_1.getSelection()) {
					tableComboVwr_Eltmat.getControl().setEnabled(true);
					elementMaterialType.setEnabled(true);
				}else {
					tableComboVwr_Eltmat.getControl().setEnabled(false);
					elementMaterialType.setEnabled(false);
				}
			}
			
		});
		//
		Label lblDos = new Label(composite_model_1, SWT.NONE);
		lblDos.setText("Dos");
		
		tableComboVwr_Dosmat = new TableComboViewer(composite_model_1, SWT.NONE);
		TableCombo tableCombo_1_1 = tableComboVwr_Dosmat.getTableCombo();
		tableCombo_1_1.setEditable(false);
		tableCombo_1_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo_1_1.defineColumns(StaticUiObjects.MaterialColumns);
		tableComboVwr_Dosmat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_Dosmat.setLabelProvider(matLabelProvider);
		tableComboVwr_Dosmat.setInput(getMaterials());
		//
		btnDosmatLibre_1 = new Button(composite_model_1, SWT.CHECK);
		btnDosmatLibre_1.setText("Libre");
		btnDosmatLibre_1.setSelection(design.isSecondMaterialFree());
		//
		tableComboVwr_Dosmat.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_Dosmat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if(se2!=null &&se2 instanceof Material ) {
					Material mat=(Material) se2;
					if(mat.isApplyTexture()&& mat.getImage()!=null && !mat.getImage().isEmpty()) {
						SceneTexture texture=ModelProvider.getMaterialSceneTexture(mat);
						if(texture!=null)
						{
							dosMaterialType.getTableComboViewerTexture().setSelection(new StructuredSelection(texture), true);
						}
						
					}
				}
			}
		});
		Button btnList3 = new Button(composite_model_1, SWT.CENTER);
		GridData gd_btnList3 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList3.widthHint = 30;
		gd_btnList3.heightHint = 30;
		btnList3.setLayoutData(gd_btnList3);
		btnList3.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow=new MaterialListWindow(getShell(), null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret=listWindow.open();
				if(ret==Window.OK) {
					tableComboVwr_Dosmat.setInput(getMaterials());
					tableComboVwr_Dosmat.refresh();
					tableComboVwr_Dosmat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList3.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		
		//
		dosMaterialType = new MaterialTypeInstanceComposite(composite_model_1,SWT.NONE);
		dosMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		dosMaterialType.setSize(dosMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	
		//
		btnDosmatLibre_1.addSelectionListener(new SelectionAdapter() {
	
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnDosmatLibre_1.getSelection()) {
					tableComboVwr_Dosmat.getControl().setEnabled(true);
					dosMaterialType.setEnabled(true);
				}else {
					tableComboVwr_Dosmat.getControl().setEnabled(false);
					dosMaterialType.setEnabled(false);
				}
			}
			
		});
		//
		
		tableComboVwr_Eltmat.setSelection(design.getPrincipalmaterial()==null? null: new StructuredSelection(design.getPrincipalmaterial()), true );
		tableComboVwr_Eltmat.getControl().setEnabled(true);
		tableComboVwr_facademat.setSelection(design.getFacadeMaterial()==null? null: new StructuredSelection(design.getFacadeMaterial()), true );
		tableComboVwr_facademat.getControl().setEnabled(true);
		tableComboVwr_Dosmat.setSelection(design.getSecondmaterial()==null? null: new StructuredSelection(design.getSecondmaterial()), true );
		tableComboVwr_Dosmat.getControl().setEnabled(true);
		//
		if(design.getFacadeMaterialType()!=null) {
			facadeMaterialType.setMaterial(design.getFacadeMaterialType());
			facadeMaterialType.setEnabled(true);
		}else {
			facadeMaterialType.setEnabled(false);
		}
		facadeMaterialType.setEnabled(design.isFacadeMaterialFree());
		tableComboVwr_facademat.getControl().setEnabled(design.isFacadeMaterialFree());
		//
		if(design.getPrincipalMaterialType()!=null) {
			elementMaterialType.setMaterial(design.getPrincipalMaterialType());
			elementMaterialType.setEnabled(true);
		}else {
			elementMaterialType.setEnabled(false);
		}
		elementMaterialType.setEnabled(design.isPrincipalMaterialFree());
		tableComboVwr_Eltmat.getControl().setEnabled(design.isPrincipalMaterialFree());
	
		//
		if(design.getSecondMaterialType()!=null) {
			dosMaterialType.setMaterial(design.getSecondMaterialType());
			dosMaterialType.setEnabled(true);
		}else {
			dosMaterialType.setEnabled(false);
		}
		dosMaterialType.setEnabled(design.isSecondMaterialFree());
		tableComboVwr_Dosmat.getControl().setEnabled(design.isSecondMaterialFree());
		
		groupChant = new Group(composite_model_1, SWT.NONE);
		groupChant.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 5, 1));
		groupChant.setText("Chants");
		groupChant.setLayout(new GridLayout(3, false));
		
		Label lblChantFacade = new Label(groupChant, SWT.NONE);
		lblChantFacade.setText("Façade");
		btnChantFacadeLibre = new Button(groupChant, SWT.CHECK);
		btnChantFacadeLibre.setText("Libre");
		btnChantFacadeLibre.setSelection(design.isChantFacadeFree());
		
		tableComboVwr_ChantFacade = new TableComboViewer(groupChant, SWT.NONE);
		TableCombo tableComboChantFacade = tableComboVwr_ChantFacade.getTableCombo();
		tableComboChantFacade.setEditable(false);
		tableComboChantFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboChantFacade.defineColumns(StaticUiObjects.ChantColumns);
		tableComboVwr_ChantFacade.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_ChantFacade.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_ChantFacade.setInput(ResourceManagers.getIntance().getChants().getChant());
		if(design.getChantFacade()!=null) {
			tableComboVwr_ChantFacade.setSelection(new StructuredSelection(design.getChantFacade()), true );
		}
		tableComboChantFacade.setEnabled(design.isChantFacadeFree());
		Label lblChantElement = new Label(groupChant, SWT.NONE);
		lblChantElement.setText("Élément");
		
		btnChantElementLibre = new Button(groupChant, SWT.CHECK);
		btnChantElementLibre.setText("Libre");
		btnChantElementLibre.setSelection(design.isChantElementFree());
		
		tableComboVwr_ChantElement = new TableComboViewer(groupChant, SWT.NONE);
		TableCombo tableComboChantElement = tableComboVwr_ChantElement.getTableCombo();
		tableComboChantElement.setEditable(false);
		tableComboChantElement.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboChantElement.defineColumns(StaticUiObjects.ChantColumns);
		tableComboVwr_ChantElement.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_ChantElement.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_ChantElement.setInput(ResourceManagers.getIntance().getChants().getChant());
		if(design.getChantElement()!=null) {
			tableComboVwr_ChantElement.setSelection(new StructuredSelection(design.getChantElement()), true );
		}
		btnChantFacadeLibre.addSelectionListener(new SelectionAdapter() {
	
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnChantFacadeLibre.getSelection()) {
					tableComboChantFacade.setEnabled(true);
	
				}else {
					tableComboChantFacade.setEnabled(false);
				}
			}
			
		});
		btnChantElementLibre.addSelectionListener(new SelectionAdapter() {
	
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnChantElementLibre.getSelection()) {
					tableComboChantElement.setEnabled(true);
				}else {
					tableComboChantElement.setEnabled(false);
				}
			}
			
		});
		tableComboChantElement.setEnabled(design.isChantElementFree());
		
		composite_model_1.setTabList(new Control[]{tableCombo, tableCombo_1, tableCombo_1_1});
		model_scrolledComposite.setContent(composite_model_1);
		model_scrolledComposite.setMinSize(composite_model_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		return composite_model_1;
	}
	public List<Material> getMaterials(){
		List<Material> materials=new ArrayList<Material>();
		materials.addAll(ResourceManagers.getIntance().getMaterials());
		materials.sort(new Comparator<Material>() {
			@Override
			public int compare(Material o1, Material o2) {
				return o1.getName().compareTo(o2.getName());
			}
			
		});
		return materials;
	}
	public Composite createPieceModelTab() {
		tbtmModelElements = new CTabItem(tabFolder, SWT.NONE);
		tbtmModelElements.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmModelElements.setText("Modèle des pièces");
		pieceModel_Composite =new ListPieceModelComoposite(tabFolder, SWT.NONE, design,rootspace);
		pieceModel_Composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		pieceModel_Composite.setLayout(new GridLayout(1, false));
		tbtmModelElements.setControl(pieceModel_Composite);
		pieceModel_Composite.setSize(pieceModel_Composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	
		return pieceModel_Composite;
	}
	
	public Composite createAssemblageTab() {
		CTabItem tbtmModelAssemblyPreferences = new CTabItem(tabFolder, SWT.NONE);
		tbtmModelAssemblyPreferences.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmModelAssemblyPreferences.setText("Assemblage");
		AssemblyPreferencesComposite assemblyPreferences_Composite =new AssemblyPreferencesComposite(tabFolder, SWT.NONE, design);
		assemblyPreferences_Composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
//		assemblyPreferences_Composite.setLayout(new GridLayout(1, false));
		tbtmModelAssemblyPreferences.setControl(assemblyPreferences_Composite);
		assemblyPreferences_Composite.setSize(assemblyPreferences_Composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	
		return assemblyPreferences_Composite;
	}
	
	public MechanicDesign getDesign() {
		return design;
	}

	public void setDesign(MechanicDesign design) {
		this.design = design;
	}

	public Map<MechanicPublicParam, PublicParamEditorComposite> getDirtyParams() {
		return dirtyParams;
	}

	public void setDirtyParams(Map<MechanicPublicParam, PublicParamEditorComposite> dirtyParams) {
		this.dirtyParams = dirtyParams;
	}

	public DesignObject3D getRootspace() {
		return rootspace;
	}

	public void setRootspace(DesignObject3D rootspace) {
		this.rootspace = rootspace;
	}

	public Composite getComposite_model_1() {
		return composite_model_1;
	}

	public Composite getComposite_general() {
		return composite_general;
	}

}