package dressing.ui;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.MDFThickness;
import param.Nature_panneaux;
import param.ParamFactory;

public class EppaisseurPanneauxListWindow extends ListEditorWindow {

	IEventBroker eventBroker;
	public EppaisseurPanneauxListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
		this.eventBroker=eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Éppaisseurs Panneaux");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof MDFThickness ) {
					return ((MDFThickness)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		//
		ColumnLabelProvider codeLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof MDFThickness ) {
					return String.valueOf(((MDFThickness)element).getThickness());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Éppaisseur", true, null, SWT.LEFT, codeLabelProvider, new StringViewerComparator(codeLabelProvider));
		
	}
	
	@Override
	protected void Add() {
		MDFThickness eppaisseur=ParamFactory.eINSTANCE.createMDFThickness();
		eppaisseur.setName("");
		EppaisseurEditorWindow eppaisseur_panneauxEditorWindow = new EppaisseurEditorWindow(getShell(),eppaisseur,EditorWindow.create);
		eppaisseur_panneauxEditorWindow.create();
		int ret=eppaisseur_panneauxEditorWindow.open();
		if(ret==Window.OK) {
			refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof MDFThickness) {
			MDFThickness eppaisseur=(MDFThickness) selection.getFirstElement();
			EppaisseurEditorWindow eppaisseur_panneauxEditorWindow = new EppaisseurEditorWindow(getShell(),eppaisseur,EditorWindow.update);
			eppaisseur_panneauxEditorWindow.create();
			int ret=eppaisseur_panneauxEditorWindow.open();
			if(ret==Window.OK) {
				refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof MDFThickness) {
						ResourceManagers.getIntance().getGestion().getMdfThicknesses().remove(obj);
						ResourceManagers.getIntance().saveGestion();
					}
				}
				refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Nature_panneaux) {
			MDFThickness ep=(MDFThickness) selection.getFirstElement();
			EppaisseurEditorWindow eppaisseur_panneauxEditorWindow = new EppaisseurEditorWindow(getShell(),ep,EditorWindow.View);
			eppaisseur_panneauxEditorWindow.create();
			eppaisseur_panneauxEditorWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getGestion().getMdfThicknesses();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
