package dressing.ui.Assemblage;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.*;

public class AssemblySystemClusterEditorWindow extends EditorWindow {

	private AssemblySystemCluster cluster;
	private Text txtName;
	private TableViewer tableViewer;

	public AssemblySystemClusterEditorWindow(Shell parentShell, AssemblySystemCluster cluster, int mode) {
		super(parentShell, mode);
		this.cluster = cluster != null ? cluster : ParamFactory.eINSTANCE.createAssemblySystemCluster();
	}

		
		@Override
	protected Composite createClientArea(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(1, false));
	
		// Cluster Name
		Composite nameRow = new Composite(container, SWT.NONE);
		nameRow.setLayout(new GridLayout(2, false));
		nameRow.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		new Label(nameRow, SWT.NONE).setText("Nom:");
		txtName = new Text(nameRow, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		txtName.setText(cluster.getName() != null ? cluster.getName() : "");
	
		// TableViewer for AssemblySystems
		Group tableGroup = new Group(container, SWT.NONE);
		tableGroup.setText("Systems d'Assemblages ");
		tableGroup.setLayout(new GridLayout(2, false));
		tableGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	
		tableViewer = new TableViewer(tableGroup, SWT.BORDER | SWT.FULL_SELECTION | SWT.SINGLE);
		Table table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableViewer.setInput(cluster.getAssemblySystems());
	
		// Column: Name
		createColumn("Nom", 300, AssemblySystem::getName, (s, v) -> s.setName(v));
	
		// Column: Min Range
		createColumn("Min Range", 100,
			s -> Double.toString(s.getMinRange()),
			(s, v) -> {
				try { s.setMinRange(Double.parseDouble(v)); } catch (NumberFormatException ignored) {}
			}
		);
	
		// Column: Max Range
		createColumn("Max Range", 100,
			s -> Double.toString(s.getMaxRange()),
			(s, v) -> {
				try { s.setMaxRange(Double.parseDouble(v)); } catch (NumberFormatException ignored) {}
			}
		);
	
		// Add/Remove Buttons
		Composite buttons = new Composite(tableGroup, SWT.NONE);
		buttons.setLayout(new GridLayout(1, true));
		buttons.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false));
	
		Button btnAdd = new Button(buttons, SWT.PUSH);
		btnAdd.setText("Ajouter");
		btnAdd.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1);
		gd_btnRun.heightHint = 50;
		btnAdd.setLayoutData(gd_btnRun);
//		btnAdd.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		btnAdd.addListener(SWT.Selection, e -> {
			AssemblySystem newSys=null;
			IStructuredSelection selection = tableViewer.getStructuredSelection();
			if (!selection.isEmpty()) {
				newSys = EcoreUtil.copy((AssemblySystem) selection.getFirstElement());
			}else
			{
				newSys = ParamFactory.eINSTANCE.createAssemblySystem();
				newSys.setPublicparamgroup(ParamFactory.eINSTANCE.createPublicParamGroup());
			}
			 // Calculate max of existing maxRange
		    double max = cluster.getAssemblySystems().stream()
		        .mapToDouble(AssemblySystem::getMaxRange)
		        .max()
		        .orElse(0.0);
			newSys.setName("System " + UUID.randomUUID().toString().substring(0, 4));
			newSys.setMinRange(max+1);
		    newSys.setMaxRange(max + 100);
		    AssemblySystemEditorWindow editor = new AssemblySystemEditorWindow(shell, newSys, EditorWindow.create);
		    if (editor.open() == Window.OK) {
		    	cluster.getAssemblySystems().add(newSys);
				tableViewer.refresh();
		    }
			
		});
		//
		Button btnModify = new Button(buttons, SWT.PUSH);
		btnModify.setText("Modifier");
		btnModify.setImage(ResourceManager.getPluginImage("Dressing", "icons/icons8-edit-16.png"));
		GridData gd_btnModify = new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1);
		gd_btnModify.heightHint = 50;
		btnModify.setLayoutData(gd_btnModify);
//		btnAdd.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		btnModify.addListener(SWT.Selection, e -> {
			IStructuredSelection selection = tableViewer.getStructuredSelection();
			if (!selection.isEmpty()) {
				AssemblySystem newSys = (AssemblySystem) selection.getFirstElement();
			    AssemblySystemEditorWindow editor = new AssemblySystemEditorWindow(shell, newSys, EditorWindow.update);
			    editor.open();
			    tableViewer.refresh();
			}	
			
		});
		//
		Button btnRemove = new Button(buttons, SWT.PUSH);
		btnRemove.setText("Supprimer");
		btnRemove.setImage(ResourceManager.getPluginImage("Dressing", "icons/cancel_22X22.png"));
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1);
		gd_btnFermer.heightHint = 50;
		btnRemove.setLayoutData(gd_btnFermer);
//		btnRemove.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		btnRemove.addListener(SWT.Selection, e -> {
			IStructuredSelection selection = tableViewer.getStructuredSelection();
			if (!selection.isEmpty()) {
				cluster.getAssemblySystems().remove(selection.getFirstElement());
				tableViewer.refresh();
			}
		});
		tableViewer.refresh();
		return container;
	}

	private void createColumn(String title, int width, Function<AssemblySystem, String> getter,
			BiConsumer<AssemblySystem, String> setter) {

		TableViewerColumn column = new TableViewerColumn(tableViewer, SWT.LEFT);
		column.getColumn().setText(title);
		column.getColumn().setWidth(width);

		column.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				return getter.apply((AssemblySystem) element);
			}
		});
		
	}
	@Override
	public boolean check() {
		errorMessage = "";
		if (txtName.getText().trim().isEmpty()) {
			errorMessage = "Le nom du cluster est requis.";
			return false;
		}
		return true;
	}

	@Override
	protected void cancel() {
		// Optional cleanup
	}

	@Override
	public boolean terminer() {
		if (!super.terminer()) return false;

		cluster.setName(txtName.getText().trim());
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getApplication().getAssemblySystems().getAssemblyClusters().add(cluster);
		}
		ResourceManagers.getIntance().saveApplication();
		finish();
		return true;
	}

	public AssemblySystemCluster getEditedCluster() {
		return cluster;
	}
}
