package dressing.ui.Assemblage;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.ElementComboSelect;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.AssemblySystemCluster;
import param.Country;
import param.Finition;
import param.ParamFactory;

public class AssemblySystemClusterComboSelect extends ElementComboSelect {

	public AssemblySystemClusterComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		return ResourceManagers.getIntance().getApplication().getAssemblySystems().getAssemblyClusters();
	}

	@Override
	public void addElement() {
		AssemblySystemCluster cluster=ParamFactory.eINSTANCE.createAssemblySystemCluster();
		cluster.setName("");
		AssemblySystemClusterEditorWindow assemblyClusterEditorWindow = new AssemblySystemClusterEditorWindow(getShell(),cluster,EditorWindow.create);
		assemblyClusterEditorWindow.create();
		int ret=assemblyClusterEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(cluster), true);
		}
	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof AssemblySystemCluster) {
			AssemblySystemCluster cluster=(AssemblySystemCluster) selection;
			AssemblySystemClusterEditorWindow assemblyClusterEditorWindow = new AssemblySystemClusterEditorWindow(getShell(),cluster,EditorWindow.update);
			assemblyClusterEditorWindow.create();
			int ret=assemblyClusterEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		// TODO Auto-generated method stub
		return new AssemblySystemClusterListWindow(getShell(),null);
	}
}
