package dressing.ui.Assemblage;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.DoubleViewerComparator;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Assembly;
import param.ParamFactory;

public class AssemblyListWindow extends ListEditorWindow {

	public AssemblyListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Assemblages");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Assembly ) {
					return ((Assembly)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));

		ColumnLabelProvider eppaisseurColumnLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Assembly && ((Assembly)element).getArticle()!=null) {
					return ((Assembly)element).getArticle().getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Accessoire", true, null, SWT.CENTER, eppaisseurColumnLabelProvider, new StringViewerComparator(eppaisseurColumnLabelProvider));
		
		//
		ColumnLabelProvider longeurColumnLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Assembly ) {
					return String.valueOf(((Assembly)element).getWidth());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Longueur", true, null, SWT.CENTER, longeurColumnLabelProvider, new DoubleViewerComparator(longeurColumnLabelProvider));
		
		//
		ColumnLabelProvider hauteurColumnLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Assembly ) {
					return String.valueOf(((Assembly)element).getLength());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Hauteur", true, null, SWT.CENTER, hauteurColumnLabelProvider, new DoubleViewerComparator(hauteurColumnLabelProvider));
		//
		ColumnLabelProvider profondeurColumnLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Assembly ) {
					return String.valueOf(((Assembly)element).getLength());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Profondeur", true, null, SWT.CENTER, profondeurColumnLabelProvider, new DoubleViewerComparator(profondeurColumnLabelProvider));

	}
	@Override
	protected void Add() {
		Assembly assembly=ParamFactory.eINSTANCE.createAssembly();
		assembly.setName("");
		AssemblyEditorWindow mechanicDesignWindow = new AssemblyEditorWindow(shell,assembly,EditorWindow.create);
		mechanicDesignWindow.create();
		int ret=mechanicDesignWindow.open();
		if(ret==Window.OK) {
			refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Assembly) {
			AssemblyEditorWindow mechanicDesignWindow = new AssemblyEditorWindow(shell,(Assembly) selection.getFirstElement(),EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Assembly) {
						ResourceManagers.getIntance().getApplication().getAssemblies().getAssemblies().remove(obj);
						ResourceManagers.getIntance().saveApplication();
					}
				}
				refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Assembly) {
			AssemblyEditorWindow mechanicDesignWindow = new AssemblyEditorWindow(shell,(Assembly) selection.getFirstElement(),EditorWindow.View);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getApplication().getAssemblies().getAssemblies();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
