package dressing.ui.Assemblage;

import java.util.ArrayList;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.ElementComboSelect;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Assembly;
import param.Country;
import param.Finition;
import param.ParamFactory;

public class AssemblyComboSelect extends ElementComboSelect {

	public AssemblyComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll( ResourceManagers.getIntance().getApplication().getAssemblies().getAssemblies());
		return input;
	}

	@Override
	public void addElement() {
		
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof Assembly) {
			Assembly assembly=(Assembly) selection;
			Assembly copy=EcoreUtil.copy(assembly);
			copy.setName(assembly.getName()+"_2");
			AssemblyEditorWindow coutryEditorWindow = new AssemblyEditorWindow(getShell(),copy,EditorWindow.create);
			coutryEditorWindow.create();
			int ret=coutryEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().setInput(getinput());
				getComboViewer().refresh();
				getComboViewer().setSelection(new StructuredSelection(copy), true);
			}
		}
		
	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof Assembly) {
			Assembly assembly=(Assembly) selection;
			AssemblyEditorWindow assemblyEditorWindow = new AssemblyEditorWindow(getShell(),assembly,EditorWindow.update);
			assemblyEditorWindow.create();
			int ret=assemblyEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		// TODO Auto-generated method stub
		return new AssemblyListWindow(getShell(),null);
	}
}
