package dressing.model.debitage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.stock.Article;
import param.AccessoireInstance;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.QuincaillerieInstance;

public class ArticleGenericDebitageFormula extends GenericDebitageFormula {

	public ArticleGenericDebitageFormula() {
		// TODO Auto-generated constructor stub
		super();
	}

	public static void filldebitagesequations(DesignObject3D parent, Article article, Object emf,List<MechanicPrivateParam> privateparams,
			List<MechanicPublicParam> publicparams, ArrayList<Equation> equations) throws DesignException {
		if (article == null)
			throw new DesignException("Formule de debitage : child null");
		Bindings globalBindings = GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE);
		Bindings engineBindings = GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE);
		if(globalBindings != null)
		{
			globalBindings.clear();
			
		}else {
			GeomtericEngine.getLogicalEngine().setBindings(new SimpleBindings(), ScriptContext.GLOBAL_SCOPE);
		}
		if(engineBindings != null)
		{
			engineBindings.clear();
		}else {
			GeomtericEngine.getLogicalEngine().setBindings(new SimpleBindings(), ScriptContext.ENGINE_SCOPE);
		}
		if (parent != null) {
			GeomtericEngine.getLogicalEngine().put("PARENT", parent);
			GeomtericEngine.getLogicalEngine().put("CHILD", article);
			GeomtericEngine.getEngine().put("PARENT", parent);
			GeomtericEngine.getEngine().put("CHILD", article);
			for (Entry<Object, Object> prop : parent.entrySet()) {
				if (prop.getKey().toString().startsWith("$")) {
					try {
						GeomtericEngine.getLogicalEngine().eval(parent.get(prop.getKey()).toString());
						GeomtericEngine.getEngine().eval(parent.get(prop.getKey()).toString());
					} catch (ScriptException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new DesignException("La fonction " + prop.getKey().toString() + " cannot be evaluated");
					}
				} else {
					GeomtericEngine.getLogicalEngine().put((String) prop.getKey(), parent.get(prop.getKey()));
				}

			}
		}

		// check exist logic
		try {

			fillequationsfromprivateparam(equations, privateparams);
			fillequationsfrompublicparam(equations, publicparams);
			fillequationsfromparent(parent, equations);
			boolean res = true;
			// evaluer seulement si il ya exist expression
			if (article.containsKey("EXIST_EXPRESSION")) {
				res = (boolean) GeomtericEngine.getLogicalEngine().eval(article.get("EXIST_EXPRESSION").toString());
			}

			if (!res) {
				article.put("EXIST", false);
			} else {
				article.put("EXIST", true);
				boolean isstatic=false;
				double number=0;
				if (emf instanceof AccessoireInstance) {
					isstatic =((AccessoireInstance) emf).isStatic();
					if(isstatic)
					{
						number=((AccessoireInstance) emf).getNombreFix();
					}
				}else if (emf instanceof QuincaillerieInstance) {
					isstatic =((QuincaillerieInstance) emf).isStatic();
					if(isstatic)
					{
						number=((QuincaillerieInstance) emf).getNombreFix();
					}
				}
				if(!isstatic) {
					fillequationsfromemfmodel(equations, emf);
				}else {
					String tempkey = "@this.number@";
					ADDOrUpdateEquation(tempkey, number+"", Equation.CALCULATION_MANUAL,equations);	

				}

			}

		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			article.put("EXIST", false);
			throw new DesignException(
					" Existence expression cannot be evaluated " + article.get("EXIST_EXPRESSION").toString());
		} finally {
			if(globalBindings != null)
				globalBindings.clear();
			if(engineBindings != null)
				engineBindings.clear();
		}

	}

	private static void fillequationsfromemfmodel(ArrayList<Equation> equations, Object emf) throws DesignException {

		if (emf instanceof AccessoireInstance) {
			List<param.Equation> articleEquationequations = new ArrayList<param.Equation>();
			articleEquationequations.add(((AccessoireInstance) emf).getNombre());
			fillequationsfromgenericequations(equations, articleEquationequations);

		}
		if (emf instanceof QuincaillerieInstance) {
			List<param.Equation> articleEquationequations = new ArrayList<param.Equation>();
			articleEquationequations.add(((QuincaillerieInstance) emf).getNombre());
			fillequationsfromgenericequations(equations, articleEquationequations);

		}

	}

}
