package dressing.model;

import java.util.ArrayList;
import java.util.List;

import dressing.model.types.IntersectionType;

public class PieceSplitManagerImp implements PieceSplitManager{

	private Piece2D owner;
	private final ArrayList<Piece2D> parts = new ArrayList<Piece2D>();
	
	
	public PieceSplitManagerImp(Piece2D owner) {
		super();
		this.owner = owner;
	}

	public Piece2D getOwner() {
		return owner;
	}

	public void setOwner(Piece2D owner) {
		this.owner = owner;
	}

	public void clearParts() {
		parts.stream().forEach(e->
		{
		try {
			e.clearautomatique(true);
			e.setParentdesign(null);
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}});
		parts.clear();
		parts.trimToSize();
	}
	
	@Override
	public List<Piece2D> getParts(){
		if(!parts.isEmpty()) {
			return parts;
		}
		List<Usinage> cavities=owner.getCavities();
		clearParts();
		if(cavities.isEmpty()) {
			return parts;
		}
		
		parts.add(owner);
		boolean split = true;
		while(split) {
			List<Piece2D> resultparts=null;
			Piece2D target=null;
			pieces:
			for(Piece2D piece:parts) {
				for(Usinage cavity:cavities) {
					 resultparts =split(piece,cavity);
					 target=piece;
					 if(resultparts.size()>0) {
						 break pieces;
					 }
				}
			}
			if(resultparts.size()>0) {
				parts.addAll(resultparts);
				parts.remove(target);
				split=true;
			}else {
				split=false;
			}
			
		}
		parts.remove(owner);
		return parts;
	}
	private List<Piece2D> split(Piece2D part, Usinage cavity) {
		List<Piece2D> resultparts=new ArrayList<Piece2D>();
		Plan3D intersection=part.getIntersect(cavity);
		IntersectionType type=	Plan3D.getPlan3DType(intersection);
		
		if(type.equals(IntersectionType.INTERSECTION)) {
			double xlong=intersection.getXinter().getlong();
			double ylong=intersection.getYinter().getlong();
			double zlong=intersection.getZinter().getlong();

			if(((xlong<ylong ||Math.abs(part.getHauteurext()-ylong)<0.0001) 
					&& (xlong<zlong ||Math.abs(part.getProfondeurext()-zlong)<0.0001)
					&& Math.abs(part.getLongeurext()-xlong)>0.0001)) {
				resultparts =splitX(part, cavity);
				if(resultparts.size()>0) {
					return resultparts;
				}
			}
			if((ylong<zlong||Math.abs(part.getProfondeurext()-zlong)<0.0001) && Math.abs(part.getHauteurext()-ylong)>0.0001){
				resultparts =splitY(part, cavity);
				if(resultparts.size()>0) {
					return resultparts;
				}
			}			
			if(Math.abs(part.getProfondeurext()-zlong)>0.0001){
				resultparts =splitZ(part, cavity);
				if(resultparts.size()>0) {
					return resultparts;
				}
			}
//			//left side
//			if (cavity.getXPosABS() > part.getXPosABS()) {
//				Piece2D piece = createPiece();
//				piece.setXpos(part.getXpos());
//				piece.setYpos(part.getYPosABS()-getYPosABS());
//				piece.setZpos(part.getZPosABS()-getZPosABS());
//				piece.setLongeurext(cavity.getXPosABS() - part.getXPosABS());
//				piece.setHauteurext(part.getHauteurext());
//				piece.setProfondeurext(part.getProfondeurext());
//				resultparts.add(piece);
//			}
//			//right side
//			if (cavity.getXPosABS()+cavity.getLongeurext() < part.getXPosABS()+part.getLongeurext()) {
//				Piece2D piece = createPiece();
//				piece.setXpos(cavity.getXpos()+cavity.getLongeurext());
//				piece.setYpos(part.getYPosABS()-getYPosABS());
//				piece.setZpos(part.getZPosABS()-getZPosABS());
//				piece.setLongeurext((part.getXPosABS()+part.getLongeurext())-(cavity.getXPosABS()+cavity.getLongeurext()));
//				piece.setHauteurext(part.getHauteurext());
//				piece.setProfondeurext(part.getProfondeurext());
//				resultparts.add(piece);
//			}
//			//bottom side
//			if (cavity.getYPosABS() > part.getYPosABS()) {
//				Piece2D piece = createPiece();
//				piece.setXpos(cavity.getXpos());
//				piece.setYpos(part.getYPosABS()-getYPosABS());
//				piece.setZpos(cavity.getZpos());
//				piece.setLongeurext(cavity.getLongeurext());
//				piece.setHauteurext(cavity.getYPosABS()-part.getYPosABS());
//				piece.setProfondeurext(cavity.getProfondeurext());
//				resultparts.add(piece);
//			}
//			//top side
//			if (cavity.getYPosABS()+cavity.getHauteurext() < part.getYPosABS()+part.getHauteurext()) {
//				Piece2D piece = createPiece();
//				piece.setXpos(cavity.getXpos());
//				piece.setYpos(cavity.getYpos()+cavity.getHauteurext());
//				piece.setZpos(cavity.getZpos());
//				piece.setLongeurext(cavity.getLongeurext());
//				piece.setHauteurext((part.getYPosABS()+part.getHauteurext())-(cavity.getYPosABS()+cavity.getHauteurext()));
//				piece.setProfondeurext(cavity.getProfondeurext());
//				resultparts.add(piece);
//			}
//			//back side
//			if (cavity.getZPosABS() > part.getZPosABS()) {
//				Piece2D piece = createPiece();
//				piece.setXpos(cavity.getXpos());
//				piece.setYpos(part.getYPosABS()-getYPosABS());
//				piece.setZpos(part.getZPosABS()-getZPosABS());
//				piece.setLongeurext(cavity.getLongeurext());
//				piece.setHauteurext(part.getHauteurext());
//				piece.setProfondeurext(cavity.getZPosABS()-part.getZPosABS());
//				resultparts.add(piece);
//			}
//			//front side
//			if (cavity.getZPosABS()+cavity.getProfondeurext() < part.getZPosABS()+part.getProfondeurext()) {
//				Piece2D piece = createPiece();
//				piece.setXpos(cavity.getXpos());
//				piece.setYpos(part.getYPosABS()-getYPosABS());
//				piece.setZpos(cavity.getZpos()+cavity.getProfondeurext());
//				piece.setLongeurext(cavity.getLongeurext());
//				piece.setHauteurext(part.getHauteurext());
//				piece.setProfondeurext((part.getZPosABS()+part.getProfondeurext())-(cavity.getZPosABS()+cavity.getProfondeurext()));
//				resultparts.add(piece);
//			}
		}
		return resultparts;
	}
	public List<Piece2D> splitX(Piece2D part, Usinage cavity) {
		List<Piece2D> resultparts=new ArrayList<Piece2D>();
		//left side
		if (cavity.getXPosABS() > part.getXPosABS()) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext(cavity.getXPosABS() - part.getXPosABS());
			piece.setHauteurext(part.getHauteurext());
			piece.setProfondeurext(part.getProfondeurext());
			resultparts.add(piece);
		}
		//middle side
		if (cavity.getZPosABS() > part.getZPosABS() 
				|| (cavity.getZPosABS()+cavity.getProfondeurext()) < (part.getZPosABS()+part.getProfondeurext())
				|| cavity.getYPosABS() > part.getYPosABS()
				||(cavity.getYPosABS()+cavity.getHauteurext()) < (part.getYPosABS()+part.getHauteurext())) {
			Piece2D piece = createPiece();
			piece.setXpos(cavity.getXpos());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext(cavity.getLongeurext());
			piece.setHauteurext(part.getHauteurext());
			piece.setProfondeurext(part.getProfondeurext());
			resultparts.add(piece);
		}
		//right side
		if (cavity.getXPosABS()+cavity.getLongeurext() < part.getXPosABS()+part.getLongeurext()) {
			Piece2D piece = createPiece();
			piece.setXpos(cavity.getXpos()+cavity.getLongeurext());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext((part.getXPosABS()+part.getLongeurext())-(cavity.getXPosABS()+cavity.getLongeurext()));
			piece.setHauteurext(part.getHauteurext());
			piece.setProfondeurext(part.getProfondeurext());
			resultparts.add(piece);
		}
		return resultparts;
	}
	public List<Piece2D> splitY(Piece2D part, Usinage cavity) {
		List<Piece2D> resultparts=new ArrayList<Piece2D>();
		//bottom side
		if (cavity.getYPosABS() > part.getYPosABS()) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext(part.getLongeurext());
			piece.setHauteurext(cavity.getYPosABS() - part.getYPosABS());
			piece.setProfondeurext(part.getProfondeurext());
			resultparts.add(piece);
		}
		//middle side
		if (cavity.getZPosABS() > part.getZPosABS() 
				|| (cavity.getZPosABS()+cavity.getProfondeurext()) < (part.getZPosABS()+part.getProfondeurext())
				|| cavity.getXPosABS() > part.getXPosABS()
				||(cavity.getXPosABS()+cavity.getLongeurext()) < (part.getXPosABS()+part.getLongeurext())) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(cavity.getYpos());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext(part.getLongeurext());
			piece.setHauteurext(cavity.getHauteurext());
			piece.setProfondeurext(part.getProfondeurext());
			resultparts.add(piece);
		}
		//top side
		if (cavity.getYPosABS()+cavity.getHauteurext() < part.getYPosABS()+part.getHauteurext()) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(cavity.getYpos()+cavity.getHauteurext());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext(part.getLongeurext());
			piece.setHauteurext((part.getYPosABS()+part.getHauteurext())-(cavity.getYPosABS()+cavity.getHauteurext()));
			piece.setProfondeurext(part.getProfondeurext());
			resultparts.add(piece);
		}
		return resultparts;
	}
	public List<Piece2D> splitZ(Piece2D part, Usinage cavity) {
		List<Piece2D> resultparts=new ArrayList<Piece2D>();
		//back side
		if (cavity.getZPosABS() > part.getZPosABS()) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(part.getZPosABS()-owner.getZPosABS());
			piece.setLongeurext(part.getLongeurext());
			piece.setHauteurext(part.getHauteurext());
			piece.setProfondeurext(cavity.getZPosABS() - part.getZPosABS());
			resultparts.add(piece);
		}
		//middle side
		if (cavity.getYPosABS() > part.getYPosABS() 
				|| (cavity.getYPosABS()+cavity.getHauteurext()) < (part.getYPosABS()+part.getHauteurext())
				|| cavity.getXPosABS() > part.getXPosABS()
				||(cavity.getXPosABS()+cavity.getLongeurext()) < (part.getXPosABS()+part.getLongeurext())) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(cavity.getZpos());
			piece.setLongeurext(part.getLongeurext());
			piece.setHauteurext(part.getHauteurext());
			piece.setProfondeurext(cavity.getProfondeurext());
			resultparts.add(piece);
		}
		//front side
		if (cavity.getZPosABS()+cavity.getProfondeurext() < part.getZPosABS()+part.getProfondeurext()) {
			Piece2D piece = createPiece();
			piece.setXpos(part.getXPosABS()-owner.getXPosABS());
			piece.setYpos(part.getYPosABS()-owner.getYPosABS());
			piece.setZpos(cavity.getZpos()+cavity.getProfondeurext());
			piece.setLongeurext(part.getLongeurext());
			piece.setHauteurext(part.getHauteurext());
			piece.setProfondeurext((part.getZPosABS()+part.getProfondeurext())-(cavity.getZPosABS()+cavity.getProfondeurext()));
			resultparts.add(piece);
		}
		return resultparts;
	}
	public Piece2D createPiece() {
		Piece2D	piece = new Piece2D();
		piece.setNotificationon(false);
		piece.setMechanicDesignDefinition(owner.getMechanicDesignDefinition());
		piece.setMechanicDesignElementDefinition(owner.getMechanicDesignElementDefinition());

		MechanicDesignMaterialsHelper.updateDesignElement(owner.getMechanicDesignDefinition(), owner.getMechanicDesignElementDefinition(), piece);
		////////
		piece.setParentdesign(owner);
		piece.setXpos(0);
		piece.setZpos(0);
		piece.setYpos(0);
		dressing.model.types.PieceType type = dressing.model.types.PieceType.GENERIC;
		if (owner.getMechanicDesignElementDefinition().getTypedef() != null && owner.getMechanicDesignElementDefinition().getTypedef().getKey().contentEquals("PieceType")
				&& owner.getMechanicDesignElementDefinition().getTypedefelement() != null && owner.getMechanicDesignElementDefinition().getTypedefelement().getKey() != null
				&& !owner.getMechanicDesignElementDefinition().getTypedefelement().getKey().isEmpty()) {
			String typedefElment = owner.getMechanicDesignElementDefinition().getTypedefelement().getKey();
			try {
				type = dressing.model.types.PieceType.valueOf(typedefElment);
			} catch (Exception e) {
				type = dressing.model.types.PieceType.valueOf(owner.getMechanicDesignElementDefinition().getName());
			}
		} else {

			try {
				type = dressing.model.types.PieceType.valueOf(owner.getMechanicDesignElementDefinition().getName());
			} catch (Exception e) {
			}
		}
		piece.setPiecetype(type);
		piece.setName(owner.getMechanicDesignElementDefinition().getName());
		piece.setID(owner.getMechanicDesignElementDefinition().getId());

		return piece;
	}

	public static List<Piece2D> getParts(Piece2D piece) {
		if(piece==null) {
			return new ArrayList<Piece2D>();
		}
		if (piece.getPartsManager() == null) {
			piece.setPartsManager(new PieceSplitManagerImp(piece));
		}
		List<Piece2D> parts = piece.getPartsManager().getParts();
		return parts;
	}
}
