package dressing.model;

import org.eclipse.emf.ecore.util.EcoreUtil;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import param.MechanicDesign;

public class MechanicDesignScriptManager {

	/**
	 * @param rootspace
	 * @param mechanicdesign
	 */
	public static void excuteStructureActions(DesignObject3D rootspace, MechanicDesign mechanicdesign) {
		if(!mechanicdesign.getStructureAction().isCreated()&& mechanicdesign.getStructureAction().getCreateAction()!=null && !mechanicdesign.getStructureAction().getCreateAction().isEmpty() ) {
			MechanicDesignScriptManager.createStructure(mechanicdesign);
		}else if(mechanicdesign.getStructureAction().getUpdateStructureAction()!=null && !mechanicdesign.getStructureAction().getUpdateStructureAction().isEmpty() ){
			MechanicDesignScriptManager.updateStructure(mechanicdesign,rootspace);
		}
	}
	
	public static void createStructure(MechanicDesign design) {

		Binding binding = new Binding();
		binding.setVariable("parent", design.getStructureAction().getContainer());
		binding.setVariable("structureAction", design.getStructureAction());
		binding.setVariable("deisgns", design.getStructureAction().getMechanicDesigns());
		binding.setVariable("EcoreUtil", EcoreUtil.class);
		binding.setVariable("List", java.util.List.class);
		binding.setVariable("ArrayList", java.util.ArrayList.class);
		binding.setVariable("MechanicDesign", param.MechanicDesign.class);

		GroovyShell shell = new GroovyShell(binding);
		try {
			Script script = shell.parse(design.getStructureAction().getCreateAction());
			Object ret = script.run();
			design.getStructureAction().setCreated(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * execute the update script for the structure of the MechanicDesign
	 * 
	 * @param design
	 * @param rootspace2
	 */
	public static void updateStructure(MechanicDesign design, DesignObject3D rootspace2) {

		Binding binding = new Binding();
		binding.setVariable("parent", design.getStructureAction().getContainer());
		binding.setVariable("structureAction", design.getStructureAction());
		binding.setVariable("deisgns", design.getStructureAction().getMechanicDesigns());
		binding.setVariable("EcoreUtil", EcoreUtil.class);
		binding.setVariable("List", java.util.List.class);
		binding.setVariable("ArrayList", java.util.ArrayList.class);
		binding.setVariable("Space3D", dressing.model.Space3D.class);

		binding.setVariable("MechanicDesign", param.MechanicDesign.class);

		binding.setVariable("space", rootspace2);

		GroovyShell shell = new GroovyShell(binding);
		try {
			Script script = shell.parse(design.getStructureAction().getUpdateStructureAction());
			Object ret = script.run();
			design.getStructureAction().setCreated(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
