package dressing.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import param.MechanicDesign;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.PieceType;

public class MechanicDesignObstaclesManager {

	static void updateObstacles(DesignObject3D parent, List<MechanicDesign> obstacles, int update) throws Exception {
		//update the obstacles 
		for(MechanicDesign obstacle:obstacles) {
			MechanicDesignCreator.getInstance().constructObject(parent, null, obstacle, update,!MechanicDesignCreator.createUsinage,MechanicDesignCreator.isDirectParent ,MechanicDesignCreator.isCreatedFromParentChilds);
		}
		//get the obstacles intances to compare and get the intersected pieces later
		List<DesignObject3D> obstaclesdesigns=new ArrayList<DesignObject3D>();
		getObstacles(parent, obstaclesdesigns);

		//update just the size of the intersected pieces
		for(DesignObject3D obstacle:obstaclesdesigns) {
			List<Piece2D> intesectedPiece = MechanicDesignObstaclesManager.getIntersectedPieces((Space3D) obstacle,
					obstacle.getRoot());
			intesectedPiece=intesectedPiece.stream().filter(p-> !p.getMechanicDesignDefinition().getType().equals(PieceType.OBSTACLE)).collect(Collectors.toList());
			for(Piece2D piece:intesectedPiece) {
				updateSizeIntersectedPieceWithObstacle(obstacle, piece);
			}
		}
		//add cavity to intersected Pieces with obstacles
		for(DesignObject3D obstacle:obstaclesdesigns) {
			List<Piece2D> intesectedPiece = MechanicDesignObstaclesManager.getIntersectedPieces((Space3D) obstacle,
					obstacle.getRoot());
			for(Piece2D piece:intesectedPiece) {
				try {
					updateIntersectedPieceWithObstacleExtraction(obstacle, piece);
				} catch (DesignException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (GeometricEngineException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}

		}
		//update just the size of the intersected obstacles and the their pieces
		for(DesignObject3D obstacle:obstaclesdesigns) {
			for(DesignObject3D obstacle2:obstaclesdesigns) {
				if(!obstacle.equals(obstacle2)&& obstacle.isIntersect(obstacle2).equals(IntersectionType.INTERSECTION) ) {
					updateSizeIntersectedPieceWithObstacle(obstacle, obstacle2);
					updatePieces(obstacle2,update);
				}
			}
		}
	}

	private static void updatePieces(DesignObject3D rootspace, int update ) throws Exception {
		MechanicDesign mechanicdesign=rootspace.getMechanicDesignDefinition();
		EList<MechanicPrivateParam> privateparams = mechanicdesign.getPrivateparamgroup().getMechanicprivateparam();
		EList<MechanicPublicParam> publicparams = mechanicdesign.getPublicparamgroup().getMechanicpublicparam();
		// build elements (pieces)
		rootspace.clearautomatique(true);
		List<Piece2D> pieces = MechanicDesignCreator.buildDesignElements(rootspace, mechanicdesign, privateparams, publicparams, update,
				false);
		for (DesignObject3D piece : pieces) {
			rootspace.addElement(piece);
		}
	}

	/**
	 * @param root
	 * @param piece
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public static void checkPieceIntersectionWithObstacles(DesignObject3D root, Piece2D piece)
			throws DesignException, GeometricEngineException {
		List<DesignObject3D> obstacles=new ArrayList<DesignObject3D>();
		getObstacles(root, obstacles);
		obstacles=obstacles.stream().filter(obs-> !obs.hasMember(piece)).collect(Collectors.toList());
//		//update size
		for(DesignObject3D obstacle:obstacles) {
			if(obstacle.isIntersect(piece).equals(IntersectionType.INTERSECTION)) {
				updateSizeIntersectedPieceWithObstacle(obstacle, piece);
			}
		}
		//add exctraction
		for(DesignObject3D obstacle:obstacles) {
			if(obstacle.isIntersect(piece).equals(IntersectionType.INTERSECTION)) {
				updateIntersectedPieceWithObstacleExtraction(obstacle, piece);
			}
		}
	}

	
	public static void getObstacles(DesignObject3D root,List<DesignObject3D> obstacles){
		for(DesignObject3D ob:root.getChilds()) {
			if(ob.getMechanicDesignDefinition()!=null&&ob.getMechanicDesignDefinition().getType().equals(PieceType.OBSTACLE)) {
				obstacles.add(ob);
			}else if(!(ob instanceof Usinage) && !(ob instanceof Accessoire)) {
				getObstacles(ob, obstacles);
			}
		}
		
	}
	/**
	 * @param obstacle
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	@SuppressWarnings("unused")
	private void checkIntersectedPiecesWithObstacle(DesignObject3D obstacle)
			throws DesignException, GeometricEngineException {
		List<Piece2D> intesectedPiece = MechanicDesignObstaclesManager.getIntersectedPieces((Space3D) obstacle,
				obstacle.getRoot());
		for (Piece2D piece : intesectedPiece) {
			updateSizeIntersectedPieceWithObstacle(obstacle, piece);
			updateIntersectedPieceWithObstacleExtraction(obstacle, piece);
		}
	}

	/**
	 * @param obstacle
	 * @param piece
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	private static void updateIntersectedPieceWithObstacleExtraction(DesignObject3D obstacle, Piece2D piece)
			throws DesignException, GeometricEngineException {
		Plan3D plan=piece.getIntersect(obstacle);
		Intervale xint = plan.getXinter();
		Intervale yint = plan.getYinter();
		Intervale zint = plan.getZinter();
		double x=xint.getMininter()-piece.getXPosABS();
		double l=xint.getlong();
		double y=yint.getMininter()-piece.getYPosABS();
		double h=yint.getlong();
		double z=zint.getMininter()-piece.getZPosABS();
		double p=zint.getlong();
		boolean intersectionPartiel=false;
		//check if the is horizontal and obstacle pass through the height and the intersection in L and P is not total
		if((piece.getPieceOrientation().equals(Orientation.HORIZONTAL)&& Math.round(h)==Math.round(piece.getHauteurext()))
				&& (Math.round(l)!=Math.round(piece.getLongeurext())) 
				&& (Math.round(p)!=Math.round(piece.getProfondeurext()))
			) {
			intersectionPartiel=true;
		}
		// check if the is VERTICAL and obstacle pass through the length and the intersection in H and P is not total
		if ((piece.getPieceOrientation().equals(Orientation.VERTICAL)
				&& Math.round(l) == Math.round(piece.getLongeurext()))
				
				&& (Math.round(h) != Math.round(piece.getHauteurext()))
				&& (Math.round(p) != Math.round(piece.getProfondeurext()))) {
			intersectionPartiel = true;
		}
		// check if the is VERTICAL and obstacle pass through the length and the
		// intersection in H and P is not total
		if ((piece.getPieceOrientation().equals(Orientation.PROUFOUND)
				&& Math.round(p) == Math.round(piece.getProfondeurext()))

				&& (Math.round(h) != Math.round(piece.getHauteurext()))
				&& (Math.round(l) != Math.round(piece.getLongeurext()))) {
			intersectionPartiel = true;
		}
		if(intersectionPartiel){
			dressing.model.Cavity cav=new dressing.model.Cavity();
			cav.setName("intersetion "+obstacle.getName()+" et "+piece.getName());
			cav.setID(UUID.randomUUID());
			cav.setXpos(x);
			cav.setLongeurext(l);
			cav.setYpos(y);
			cav.setHauteurext(h);
			cav.setZpos(z);
			cav.setProfondeurext(p);
			piece.addElement(cav);
		}
	}
	
	private static void updateSizeIntersectedPieceWithObstacle(DesignObject3D obstacle, DesignObject3D piece) {
		Plan3D plan=piece.getIntersect(obstacle);
		Intervale xint = plan.getXinter();
		Intervale yint = plan.getYinter();
		Intervale zint = plan.getZinter();
		double x=xint.getMininter()-piece.getXPosABS();
		double l=xint.getlong();
		double y=yint.getMininter()-piece.getYPosABS();
		double h=yint.getlong();
		double z=zint.getMininter()-piece.getZPosABS();
		double p=zint.getlong();
		
		double rainureProf = MechanicDesignHelper.getRainureProf(piece);
		boolean isDosInterieur = piece instanceof Piece2D 
		    && ((Piece2D) piece).getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR);
		double tolerance = isDosInterieur ? rainureProf : 0.01;
		
		// Now comparisons use the adjusted tolerance
		if (MechanicDesignHelper.isClose(l, piece.getLongeurext(), tolerance*2) && MechanicDesignHelper.isClose(h, piece.getHauteurext(), tolerance*2)
		        && (MechanicDesignHelper.isClose(z, 0, tolerance) || MechanicDesignHelper.isClose(z + p, piece.getProfondeurext(), tolerance))) {
		    
		    piece.setProfondeurext(piece.getProfondeurext() - p + rainureProf);
		    if (MechanicDesignHelper.isClose(z, 0, tolerance)) {
		        double delta = p - rainureProf;
		        piece.setZpos(piece.getZpos() + delta);
		        shiftChildren(piece, "z", delta);
		    }

		} else if (MechanicDesignHelper.isClose(l, piece.getLongeurext(), tolerance*2) && MechanicDesignHelper.isClose(p, piece.getProfondeurext(), tolerance*2)
		        && (MechanicDesignHelper.isClose(y, 0, tolerance) || MechanicDesignHelper.isClose(y + h, piece.getHauteurext(), tolerance))) {
		    
		    piece.setHauteurext(piece.getHauteurext() - h + rainureProf);
		    if (MechanicDesignHelper.isClose(y, 0, tolerance)) {
		        double delta = h - rainureProf;
		        piece.setYpos(piece.getYpos() + delta);
		        shiftChildren(piece, "y", delta);
		    }

		} else if (MechanicDesignHelper.isClose(p, piece.getProfondeurext(), tolerance*2) && MechanicDesignHelper.isClose(h, piece.getHauteurext(), tolerance*2)
		        && (MechanicDesignHelper.isClose(x, 0, tolerance) || MechanicDesignHelper.isClose(x + l, piece.getLongeurext(), tolerance))) {
		    
		    piece.setLongeurext(piece.getLongeurext() - l + rainureProf);
		    if (MechanicDesignHelper.isClose(x, 0, tolerance)) {
		        double delta = l - rainureProf;
		        piece.setXpos(piece.getXpos() + delta);
		        shiftChildren(piece, "x", delta);
		    }
		}
	}
	private static void shiftChildren(DesignObject3D piece, String axis, double delta) {
	    for (DesignObject3D child : piece.getChilds()) {
	        switch (axis) {
	            case "x": child.setXpos(child.getXpos() + delta); break;
	            case "y": child.setYpos(child.getYpos() + delta); break;
	            case "z": child.setZpos(child.getZpos() + delta); break;
	        }
	    }
	}

	public static List<Piece2D> getIntersectedPieces(Space3D space,DesignObject3D frere) {
		 List<Piece2D> intesectedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D && !child.equals(space)) {
				intesectedPiece.addAll(MechanicDesignObstaclesManager.getIntersectedPieces(space, child)) ;
			}
			if(child instanceof Piece2D && !space.equals(child) && !space.hasMember(child)) {
				if(space.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
					intesectedPiece.add((Piece2D) child);
				}
			}
		}
		return intesectedPiece;
		
	}
}
