package dressing.model;

import param.MechanicDesign;
import param.MechanicPublicParam;

public class MechanicDesignHelper {

	public static double getRainureProf(DesignObject3D piece) {
		if (piece instanceof Piece2D
				&& ((Piece2D) piece).getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)) {
			try {
				String sRainureProf = piece.getMechanicDesignDefinition().getPublicParam("usin.dosRainureProf")
						.getDefaultvalue();
				return Double.parseDouble(sRainureProf);
			} catch (Exception e) {
				System.err.println(
						"Warning: Failed to parse rainureProf for piece " + piece.getName() + ". Defaulting to 0.");
			}
		}
		return 0;
	}
	
	public static boolean getbooleanParam(MechanicDesign design , String key) {
		try {
			MechanicPublicParam param =design.getPublicParam(key);
			if(param.getTypedef()!=null && param.getTypedef().getKey()!=null && 
					param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				return Boolean.valueOf(param.getTypedefelement().getKey());
			}
		} catch (Exception e) {
			
		}
		return false;
	}
	
	public static boolean isClose(double a, double b, double tolerance) {
		return Math.abs(a - b) <= tolerance;
	}

	public static boolean isClose(double a, double b) {
		return isClose(a, b, 0.01);
	}
}
