package dressing.model;

import java.util.ArrayList;
import java.util.List;

import dressing.config.persistence.ResourceManagers;
import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import param.EngineStrategy;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.PieceType;

public class MechanicDesignCollusionsHelper {


	/**
	 * @param src
	 * @param parentDesign
	 * @param rootModule
	 * @return 
	 * @throws Exception
	 */
	public static DesignObject3D checkPiecesCollusions(DesignObject3D src, DesignObject3D parentDesign, Space3D rootModule)
			throws Exception {
		if(src instanceof Piece2D ) {
			if(((Piece2D) src).getMechanicDesignElementDefinition().getType().equals(param.PieceType.ACCESOIRE)){
				return null;
			}
		}
		if(src instanceof Piece2D && !((Piece2D) src).getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)&& !((Piece2D) src).getPiecetype().equals(dressing.model.types.PieceType.SEPARATOR_FACADE)) {
			if(!MechanicDesignHelper.getbooleanParam(src.getMechanicDesignDefinition(), "allow_Collision")) {
				List<Piece2D> intesectedPiece =Piece2D.getIntersectedPieces(src, rootModule);
				 if(intesectedPiece!=null && !intesectedPiece.isEmpty()) {
					 for(Piece2D piece:intesectedPiece) {
						 
						 if(piece.getMechanicDesignElementDefinition().getType().equals(param.PieceType.ACCESOIRE)){
								continue;
						 }
						 
						 boolean isPieceDos = piece.getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR);
							Plan3D intersection= src.getIntersect(piece);
							if(piece.equals(parentDesign)) {
								continue;
							}
							
							if(intersection!=null && intersection.getXinter()!=null && intersection.getYinter()!=null && intersection.getZinter()!=null 
									&&  !isPieceDos && !piece.getPiecetype().equals(dressing.model.types.PieceType.PARTITION_FACADE))
							{
								if(MechanicDesignHelper.getbooleanParam(piece.getMechanicDesignDefinition(), "allow_Collision")) {
									continue;
								}

								if(ResourceManagers.getIntance().getPieceCollistionStrategy().equals(EngineStrategy.DELETE)) {
									parentDesign.deletechild(src, true);
									System.err.println("src "+src.getName()+" deleted for intersection with "+piece.getName() );
									return src;
								}else if(ResourceManagers.getIntance().getPieceCollistionStrategy().equals(EngineStrategy.SPLIT)) 
								{
									if(rootModule.getDependenceController().splitDos(src.getMechanicDesignDefinition(),piece.getMechanicDesignDefinition()))
									{
										return src;
									}else {
										src.setErrorexist(true);
										src.setErrormsg(!src.getErrormsg().isEmpty()? (src.getErrormsg()+"\n"):""+ "Pièce "+src.getName() +" est en intersection avec Pièce "+piece.getName());
										piece.setErrorexist(true);
										piece.setErrormsg(!src.getErrormsg().isEmpty()? (src.getErrormsg()+"\n"):""+ "Pièce "+piece.getName() +" est en intersection avec Pièce "+src.getName());
									}
								}else {
									src.setErrorexist(true);
									src.setErrormsg(!src.getErrormsg().isEmpty()? (src.getErrormsg()+"\n"):""+ "Pièce "+src.getName() +" est en intersection avec Pièce "+piece.getName());
									piece.setErrorexist(true);
									piece.setErrormsg(!src.getErrormsg().isEmpty()? (src.getErrormsg()+"\n"):""+ "Pièce "+piece.getName() +" est en intersection avec Pièce "+src.getName());
								}
							}
					 }
				 }
			}
			
		}
		return null;
	}

	/**
	 * @param src
	 * @param parentDesign
	 * @param rootModule
	 * @return 
	 * @throws Exception
	 */
	public static DesignObject3D checkDosCollusions(DesignObject3D src, DesignObject3D parentDesign, Space3D rootModule)
			throws Exception {
		if ( src instanceof Piece2D
				&& ((Piece2D) src).getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)) {
			List<Piece2D> intesectedPiece = Piece2D.getIntersectedPieces(src, rootModule);
			if (intesectedPiece != null && !intesectedPiece.isEmpty()) {
				for (Piece2D piece : intesectedPiece) {
					if (piece.getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)) {
						parentDesign.deletechild(src, true);
						return src;
					}else if(piece.getMechanicDesignDefinition().getType().equals(PieceType.PIECE2D) ){
						Plan3D intersection= src.getIntersect(piece);
						if(intersection!=null&& intersection.getXinter()!=null &&intersection.getYinter()!=null 
								&&(	(piece.getPieceOrientation().equals(Orientation.HORIZONTAL)&&Math.round(intersection.getYinter().getlong())==Math.round(piece.getHauteurext()))
										||(piece.getPieceOrientation().equals(Orientation.VERTICAL)&& Math.round(intersection.getXinter().getlong())==Math.round(piece.getLongeurext())) ) )
						{
							if(rootModule.getDependenceController().splitDos(src.getMechanicDesignDefinition(),piece.getMechanicDesignDefinition()))
							{
								return src;
							}
						}
					}
				}
			}
		}
		return null;
	}

	/**
	 * @param src
	 * @param rootModule
	 * @param root
	 * @throws Exception
	 */
	public static void checkPieceCollusionWithDos(DesignObject3D src, Space3D rootModule) throws Exception {
		if( src instanceof Piece2D && !((Piece2D) src).getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)) {
			 List<Piece2D> intesectedPiece =Piece2D.getIntersectedPieces(src, rootModule);
			 if(intesectedPiece!=null && !intesectedPiece.isEmpty()) {
				 for(Piece2D piece:intesectedPiece) {
					 
					 if(piece.getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)) {
						Plan3D intersection= src.getIntersect(piece);
						if(intersection!=null&& intersection.getXinter()!=null &&intersection.getYinter()!=null 
								&&((Math.round(intersection.getYinter().getlong())==Math.round(src.getHauteurext())&&Math.round(intersection.getXinter().getlong())==Math.round(src.getLongeurext())	)
								||(Math.round(intersection.getXinter().getlong())==Math.round(src.getLongeurext())&&Math.round(intersection.getZinter().getlong())==Math.round(src.getProfondeurext()) )
								||(Math.round(intersection.getZinter().getlong())==Math.round(src.getProfondeurext())&&Math.round(intersection.getYinter().getlong())==Math.round(src.getHauteurext()) )
								||(Math.round(intersection.getZinter().getlong())==Math.round(src.getProfondeurext())&&Math.round(intersection.getXinter().getlong())==Math.round(src.getLongeurext()) )

								))
						{
							rootModule.getDependenceController().splitDos(piece.getMechanicDesignDefinition(),src.getMechanicDesignDefinition());
//							 break;
						}
						
					 }
				 }
			 }
		}
	}

	/**
	 * @param separatorFacadePiece
	 * @param rootModule
	 * @throws Exception
	 */
	public static void checkSeparatorFacadePieceCollusion(DesignObject3D separatorFacadePiece, Space3D rootModule) throws Exception {
		if( separatorFacadePiece instanceof Piece2D && ((Piece2D) separatorFacadePiece).getPiecetype().equals(dressing.model.types.PieceType.SEPARATOR_FACADE)) {
			 List<Piece2D> intesectedPiece =Piece2D.getIntersectedPieces(separatorFacadePiece, rootModule);
			 if(intesectedPiece!=null && !intesectedPiece.isEmpty()) {
				 for(Piece2D piece:intesectedPiece) {
					 
					 if(piece.getPiecetype().equals(dressing.model.types.PieceType.PARTITION_FACADE)) {
						Plan3D intersection= separatorFacadePiece.getIntersect(piece);
						if(intersection!=null&& intersection.getXinter()!=null &&intersection.getYinter()!=null 
								&&(intersection.getYinter().getlong()==separatorFacadePiece.getHauteurext()
								|| intersection.getXinter().getlong()==separatorFacadePiece.getLongeurext())  )
						{
							rootModule.getDependenceController().splitDos(piece.getMechanicDesignDefinition(),separatorFacadePiece.getMechanicDesignDefinition());
//							 break;
						}
						
					 }
				 }
			 }
		}
	}

	/**
	 * @param partitionFacade
	 * @param parentDesign
	 * @param rootModule
	 * @return 
	 * @throws Exception
	 */
	public static DesignObject3D checkPartitionFacedeCollusions(DesignObject3D partitionFacade, DesignObject3D parentDesign,
			Space3D rootModule) throws Exception {
		//check if the src is PARTITION_FACADE and intersect with a SEPARATOR_FACADE then we split PARTITION_FACADE
		if( partitionFacade instanceof Piece2D && ((Piece2D) partitionFacade).getPiecetype().equals(dressing.model.types.PieceType.PARTITION_FACADE)) {
			 List<Piece2D> intesectedPiece =Piece2D.getIntersectedPieces(partitionFacade, rootModule);
			 if(intesectedPiece!=null && !intesectedPiece.isEmpty()) {
				 for(Piece2D piece:intesectedPiece) {
					 
					 if(piece.getPiecetype().equals(dressing.model.types.PieceType.SEPARATOR_FACADE)) {
						Plan3D intersection= partitionFacade.getIntersect(piece);
						if(intersection!=null&& intersection.getXinter()!=null &&intersection.getYinter()!=null 
								&&(	intersection.getYinter().getlong()==piece.getHauteurext()|| intersection.getXinter().getlong()==piece.getLongeurext())  )
						{
							rootModule.getDependenceController().splitDos(partitionFacade.getMechanicDesignDefinition(),piece.getMechanicDesignDefinition());
//							 break;
						}
						
					 }
					 else if(piece.getPiecetype().equals(dressing.model.types.PieceType.PARTITION_FACADE)){
							parentDesign.deletechild(partitionFacade, true);
							return partitionFacade;
					 }
				 }
			 }
		}
		return null;
	}

	/**
	 * @param mechanicdesign
	 * @param space
	 * @param parentDesign
	 * @throws Exception
	 */
	public static void removeIntersectDosWithSpace(MechanicDesign mechanicdesign, DesignObject3D space,
			DesignObject3D parentDesign) throws Exception {
		if(space instanceof Space3D &&(mechanicdesign.getType().equals(PieceType.SPACE3D) 
				|| mechanicdesign.getType().equals(PieceType.CAISSON))){
			if(parentDesign.getChilds().size()>0) {
				List<DesignObject3D> dosToBeDeleted = new ArrayList<DesignObject3D>();
				for(DesignObject3D child:parentDesign.getChilds()){
					if(child instanceof Piece2D && ((Piece2D) child).getPiecetype().equals(dressing.model.types.PieceType.DOS_INTERIEUR)) {
						if(space.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
							dosToBeDeleted.add(child);
						}
					}
				}
				if(!dosToBeDeleted.isEmpty())
				{
					for(DesignObject3D dos:dosToBeDeleted){
						parentDesign.deletechild(dos, true);
					}
				}
			}
		}
	}

	/**
	 * @param mechanicdesign
	 * @param src
	 * @param parentDesign
	 * @param rootModule
	 * @throws Exception
	 */
	public static void separateFacadeCoulissant(MechanicDesign mechanicdesign, DesignObject3D src,
			DesignObject3D parentDesign, Space3D rootModule) throws Exception {
		MechanicPublicParam pieceType=mechanicdesign.getPublicParam("Piece_Type");
		if(pieceType!=null && pieceType.getTypedefelement()!=null
				&& pieceType.getTypedefelement().getKey().contentEquals("SEPARATOR_FACADE")) {
			if(parentDesign.getChilds().size()>0) {
				for(DesignObject3D child:parentDesign.getChilds()){
					if(child instanceof Piece2D && ((Piece2D) child).getPiecetype().equals(dressing.model.types.PieceType.PARTITION_FACADE)) {
						if(src.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
							if(rootModule.getDependenceController().splitDos(child.getMechanicDesignDefinition(),src.getMechanicDesignDefinition()))
							{
								break;
							}
						}
					}
				}
				
			}
		}
	}
	
}
