package dressing.handlers.cam;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.cam.model.MachineCodeHandler;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignUsinageManager;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.ui.util.SupercadProgressMonitorDialog;
import param.cam.MachineEngine;

public class SaveAsGcodeHandler {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	
	@Inject 
	EPartService partService;
	
	@Execute
	public void execute(Shell shell,ParameterizedCommand command){
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		Object selected=null;
		if(command.getParameterMap().get("dressing.commandparameter.context")!=null)
		{
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.context");
			if(persp!=null&& persp.contentEquals("global")) {
				SuperCadProject project=ProjectManager.getManager().getCurrentProject();
				selected=project;			
			}
		}
		if(selected==null) {
			Object o = selectionService.getSelection("dressing.part.projectexplorer");
			if(o!=null && (o instanceof Kitchen || o instanceof SuperCadProject|| o instanceof Space3DFree)) {
				selected =o;
			}
		}
		final Object target=selected;
		
			FileDialog dialog = new FileDialog(shell,SWT.SAVE);
			dialog.setFilterPath(dirpath);
			dialog.setFileName("gcode");
			String filepath = dialog.open();
			if (filepath != null && !filepath.isEmpty() && target !=null) {
				SupercadProgressMonitorDialog progressmonitor =new SupercadProgressMonitorDialog(shell);
				IRunnableWithProgress operation =	new IRunnableWithProgress() {
					// This is the method that gets invoked when the operation runs.
					//
					@Override
					public void run(IProgressMonitor monitor)throws InvocationTargetException, InterruptedException  {
						// Save the resources to the file system.
						try {
							// Imed bug 0001710 changer l'exportation dxf dynamyque pour tout les design3D
							 GcodeFileManager manager = new GcodeFileManager(MachineCodeHandler.getInstance().getExtension());
							 if(target instanceof Kitchen) {
								 manager.saveGcode((Kitchen)target,filepath);
							 }else
								 if(target instanceof SuperCadProject) {
								 manager.saveGcode((SuperCadProject)target,filepath);
							 }else
								 if(target instanceof Space3DFree) {
									 try {
										 MechanicDesignUsinageManager.createUsinage(((Space3DFree) target), false);
									} catch (Exception e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
								 manager.saveGcode((Space3DFree)target,filepath);
							 }
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						//save file path to preference for future use
						File file = new File(filepath);
						String dirpath = file.getParent();
						 projectpref.put("directoryWrite", dirpath);
						 try {
							projectpref.flush();
						 } catch (BackingStoreException e) {
							e.printStackTrace();
						 }
						//open saved file
						try {
							Desktop.getDesktop().open(file);
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				};
				try {
					// This runs the options, and shows progress.
					//
					progressmonitor.run(true, false, operation);

				}
				catch (Exception exception) {
					// Something went wrong that shouldn't.
					//
					exception.printStackTrace();
				}	
				
			}
		
		
	}
	@CanExecute
	public boolean check(ParameterizedCommand command)
	{ 
		MachineEngine engine = ResourceManagers.getIntance().getPreference().getConfig().getEngine();
		String code = engine.getCode();
		if (code.contentEquals(MachineCodeHandler.SCM)) {
			return false;
		}
		if(command.getParameterMap().get("dressing.commandparameter.context")!=null)
		{
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.context");
			if(persp!=null&& persp.contentEquals("global")) {
				SuperCadProject project=ProjectManager.getManager().getCurrentProject();
				if(project !=null) {
					return true;
				}
			}
		}

		
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		
		if(o!=null && (o instanceof Kitchen || o instanceof SuperCadProject || o instanceof DesignObject3D)) 
		{
			return true;
		}
		
		return false;
		
	}
}
