package dressing.handlers;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;

public class CopyPiecesNomenclatureToExcellHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	
	String groupby=Piece2DCoupe.GROUPBY_NONE;

	@Execute
	public void execute(Shell shell,ParameterizedCommand cmd ){
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		
		//Determiner la nature de groupement
		if(cmd!=null)
		{
			if(cmd.getParameterMap()!=null)
			{
				String s = (String) cmd.getParameterMap().get("dressing.commandparameter.copyexcell.groupby");
				if(s!=null)
				{
					groupby=s;
				}
			}
		}
		//Voire l element de l arbre selectionne
		if(o instanceof DesignObject3D || o instanceof Object[] || o instanceof Kitchen)
		{
			
			
			
			if(check())
			{
				StringBuilder builder = new StringBuilder();
				Object[] list =null;
				
				if(o instanceof Object[])
				{
					list = (Object[]) o;
				}
				else if(o instanceof Kitchen) {
					list = ((Kitchen) o).getElements().toArray();
				}
				else {
					list =new Object[] {o};
				}
				if(list instanceof Object[]) //Pour suppertorter la selectio multiple
				{
					List<Piece2D> exportedlist = new ArrayList<Piece2D>();
					List<Piece2DCoupe> coupelist = new ArrayList<Piece2DCoupe>();
					for(Object design : (Object[])list)
					{
						if( design instanceof Space3DFree)
						{
							copyCaissonToExcell((Space3D) design, builder,exportedlist,coupelist);
						}
						
						else if(design instanceof Piece2D)
						{
							copyPiece2DToExcell((Piece2D) design, builder,exportedlist,coupelist);
						}
					}
					if(groupby!=Piece2DCoupe.GROUPBY_NONE)
					{
						writePiecestoStringBuilder(builder, coupelist);
					}
					exportedlist.clear();
					coupelist.clear();
					exportedlist=null;
					coupelist=null;
				}


				//Le string builder est termioner on cree le data transfer								
				Clipboard clipboard = new Clipboard(Display.getCurrent());
	    	    String textData = builder.toString();
	    	    TextTransfer textTransfer = TextTransfer.getInstance();
	    	    Transfer[] transfers = new Transfer[]{textTransfer};
	    	    Object[] data = new Object[]{textData};
	    	    clipboard.setContents(data, transfers);
	    	    clipboard.dispose();
			}
			

		}		
	}

	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if(o instanceof Kitchen || o instanceof Piece2D || o instanceof Space3DFree)
		{
			return true;
		}
		if(o instanceof Object[])
		{
			return true;
		}
		return false;
	}
	
	private void writePiecestoStringBuilder(StringBuilder builder,List<Piece2DCoupe> coupelist)
	{
		for(Piece2DCoupe piece : coupelist)
		{
//			builder.append(piece.getFullname());
//			builder.append("\t");
			
			builder.append(piece.getProjetname());
			builder.append("\t");
			builder.append(piece.getEtagename());
			builder.append("\t");
			builder.append(piece.getAppartementname());
			builder.append("\t");
			builder.append(piece.getDressingname());
			builder.append("\t");
			builder.append(piece.getCaissonname());
			builder.append("\t");
//			builder.append(piece.getParentname());
//			builder.append("\t");
			builder.append(piece.getPiecename());
			builder.append("\t");			
			builder.append(piece.getMaterial());
			builder.append("\t");			
			builder.append(piece.getPieceL());
			builder.append("\t");
			builder.append(piece.getPieceH());
			builder.append("\t");	
			builder.append(piece.getQty());
			builder.append("\t");	
			builder.append(piece.getChants());
			builder.append("\t");
			builder.append("\n");
		if(piece.getEtagename()== null||piece.getAppartementname()==null||piece.getEtagename().isEmpty()||piece.getAppartementname().isEmpty()) {
			System.out.println("erroooooooooooooooooooooooooooooooooooooooooooooooooooor");
		}
		}
	}	
	private void copyPiece2DToExcell(Piece2D piece,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist)
	{	
		if(!exportedlist.contains(piece))
		{
			exportedlist.add(piece);
		}
		else
		{
			return; //pour ne pas exporter le m�me elemnt 2 fois
		}		
		//Assembler les pieces par nothing
		 
		
		if(groupby!=Piece2DCoupe.GROUPBY_NONE)
		{
			Piece2DCoupe pcoupe = piece.createPieceCoupe();
			pcoupe.setGroupby(groupby);
			boolean found=false;
			for(Piece2DCoupe pc : coupelist)
			{
				if(pc.equals(pcoupe))
				{
					pc.setQty(pc.getQty()+1);
					found=true;
					break;
				}
			}
			
			if(!found)
			{
				coupelist.add(pcoupe);
			}
			return;//pas besoin de contionuer on doit pas remplir le strigbuilder ici
		}

		
//		if(piece.getParentdesign()!=null && piece.getParentdesign().getParentdesign()!=null && piece.getParentdesign().getParentdesign().getParentdesign()!=null)
//		{	
//			builder.append(piece.getParentdesign().getParentdesign().getParentdesign().getName());
//			builder.append("\t");
//			if(piece.getParentdesign().getParentdesign() instanceof Dressing) {
//				builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getEtage());
//				builder.append("\t");
//				builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getAppartement());
//				builder.append("\t");
//			}
//		
//			builder.append(piece.getParentdesign().getParentdesign().getName());
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getName());
//			builder.append("\t");
//		}
//		else if(piece.getParentdesign()!=null && piece.getParentdesign().getParentdesign()!=null)
//		{
//			if(piece.getParentdesign().getParentdesign() instanceof Dressing) {
//			builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getEtage());
//			builder.append("\t");
//			builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getAppartement());
//			builder.append("\t");
//			}
//			builder.append(" ");
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getParentdesign().getName());
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getName());
//			builder.append("\t");
//		}
//		else if(piece.getParentdesign()!=null)
//		{
//			builder.append(" ");
//			builder.append("\t");
//			builder.append(" ");
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getName());
//			builder.append("\t");
//		}
		DesignObject3D parent=piece.getParentdesign();
		List<String> strings=new ArrayList<String>();
		while( parent !=null)
		{	
				if(parent instanceof Space3D&& !(parent instanceof Space3DFree) ) {
					parent =parent.getParentdesign();
				}
				else if(parent instanceof Space3DFree) {
//					builder.append(parent.getName());
//					builder.append("\t");
					strings.add(parent.getName());
					strings.add("\t");
					parent =parent.getParentdesign();
				}			
			
		}
		for(int i=strings.size()-1;i>=0;i--) {
			builder.append(strings.get(i));
		}
		builder.append("\t");
		
		builder.append(piece.getName());
		builder.append("\t");
		
		builder.append(piece.getMaterial().getName());
		builder.append("\t");

		builder.append(piece.getPieceL());
		builder.append("\t");
		
		
		builder.append(piece.getPieceH());
		builder.append("\t");
		
		builder.append(1);
		builder.append("\t");
		
		builder.append(piece.getChants());
		builder.append("\t");
		
		builder.append("\n");
	}
	private void copyCaissonToExcell(Space3D o,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist)
	{		
		for(DesignObject3D p : o.getChilds())
		{	
			
			
			if(p instanceof Piece2D)
			{
				copyPiece2DToExcell((Piece2D) p,builder,exportedlist,coupelist);
			}
		}	
		
	}
}
