 
package dressing.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignUsinageManager;
import dressing.model.Piece2D;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.profiling.TimeProfiler;
import dressing.ui.SuperCadMessageDialog;
import dressing.ui.util.SupercadProgressMonitorDialog;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javax.inject.Inject;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class AddUsinageTrou {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell) {
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if (o != null && (o instanceof DesignObject3D || o instanceof Kitchen || o instanceof SuperCadProject )) {
			SupercadProgressMonitorDialog progressmonitor = new SupercadProgressMonitorDialog(shell);

			IRunnableWithProgress operation = new IRunnableWithProgress() {

				@Override
				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					// TODO Auto-generated method stub

					// Save the resources to the file system.
					try {
						monitor.beginTask("Génération d'usinage", IProgressMonitor.UNKNOWN);
						if(o instanceof SuperCadProject)
						{
							createdesignsUsinage((SuperCadProject)o,false,true);
						}else if (o instanceof Kitchen) {
							createdesignsUsinage((Kitchen)o,false,true);

						}else {
							createdesignsUsinage((DesignObject3D)o,false,true);

						}
						monitor.done();
					} catch (Exception e) {
						SuperCadMessageDialog.openMessage(MessageDialog.ERROR, shell, "Une erreur dans la création d'Usinage", e.getMessage());
						e.printStackTrace();
					}
				}

			};
			try {
				// This runs the options, and shows progress.
				//
				progressmonitor.run(true, false, operation);

			} catch (Exception exception) {
				// Something went wrong that shouldn't.
				//
				exception.printStackTrace();
			}
		}	
	}
	
	
	@CanExecute
	public boolean canExecute() {
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if(o != null && (o instanceof Space3DFree || o instanceof Piece2D || o instanceof Kitchen || o instanceof SuperCadProject ))
		{
			return true;
		}	
			return false;
	}

	public static void createdesignsUsinage(SuperCadProject target, boolean cavityOnly,boolean notify) {
		for (Kitchen kitchen : target.getKitchens()) {
			createdesignsUsinage(kitchen, cavityOnly, notify);
		}
	}
	public static void createdesignsUsinage(Kitchen target, boolean cavityOnly,boolean notify) {
		Date deb=new Date();
		for (DesignObject3D designObject : target.getElements()) {
			createdesignsUsinage(designObject, cavityOnly, notify);
		}
		Date fin=new Date();
		System.err.println("****create usinage for "+target.getName()+"in "+(fin.getTime()-deb.getTime()));

	}
	public static void createdesignsUsinage(DesignObject3D target, boolean cavityOnly,boolean notify) {
		try {
			TimeProfiler.getInstance().start("create usinage for"+target.getName());
			ProjectManager.getInstance().getRoot().setNotificationon(false);
			
			MechanicDesignUsinageManager.createUsinage(target,cavityOnly);
			
			ProjectManager.getInstance().getRoot().setNotificationon(true);
			TimeProfiler.getInstance().stop("create usinage for"+target.getName());

			if(notify)
			{
				ProjectManager.getInstance().getRoot().firePropertyChange("project.modify", 1, 2);
			}
//			System.err.println("****create usinage in "+(new Date().getTime()-deb.getTime()));
		} catch (Exception e) {
			
			e.printStackTrace();
			MessageDialog.openError(null, "Une erreur dans la création d'Usinage", e.getMessage());
		}
	}
	public static void createdesignsUsinage(Object target, boolean cavityOnly,boolean notify) throws DesignException {
		throw new DesignException("Type d'objet invalide"); 
	}
		
}