package dressing.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class WorkspaceConfiguration {

	private final static String root=System.getenv("ProgramData") + File.separator + "supercad";
	public static final String APP_DATA = System.getProperty("user.home") + File.separator + "AppData" + File.separator + "Local" + File.separator +
			 "Super3Designer";
	
	//
	public final static String ROOT_DRESSING=System.getenv("ProgramData") + File.separator + "superDressing";
	public final static String DRESSING_DATA=ROOT_DRESSING+File.separator + "Data";
	//
	private final static String modelsDir = root + File.separator + "assets" + File.separator + "models";
	public final static String TEXTURES_FOLDER = root + File.separator + "pictures";
	public final static String RESIZE_TOOLS = root + File.separator + "resize_tools";
	public final static String TEXTURES2D_FOLDER = root + File.separator + "pictures2d";
	public final static String minifiedPictureFolders =  APP_DATA + File.separator + "tmp" + File.separator + "pictures";
	public final static String MINIFIED_LABEL_PICTURE_FOLDERS =  APP_DATA + File.separator + "tmp" + File.separator + "label_pictures";

    public static final String UI_SKIN = root + File.separator + "assets" + File.separator + "skins" + File.separator + "skin" + File.separator + "cloud-form-ui.json";
    public static final String SHADERS_PATH = root + File.separator + "shaders";
	public static final String CONTAINMENTS  = root + File.separator + "containments.xml";
	public static String handlers = root + File.separator + "assets" + File.separator + "handlers";
	public static String ICONS = root+ File.separator + "icons";
	public static final String SETTING_PATH = APP_DATA + File.separator + "config" + File.separator + "user-preferences.xml";
	public static final String key = APP_DATA + File.separator + "config" + File.separator + "cad.key";
	public static final String padding = APP_DATA + File.separator + "config" + File.separator + "moon.txt";
	public static final String WALL_STYLES = root + File.separator + "WallStyles.json";
	public static final String MATERIALS_FOLDER = root + File.separator + "materials";
	public static final String MATERIALS_FILE = root + File.separator + "materials.json";
	public static final String FONT = root + File.separator + "assets"  + File.separator + "fonts" + File.separator + "arial narrow sd.fnt";
	public static final String FONT_IMAGE = root + File.separator + "assets"  + File.separator + "fonts" + File.separator + "arial narrow sd.png";
	public static final String Large_FONT_IMAGE = root + File.separator + "assets"  + File.separator + "fonts" + File.separator + "arial_black48.png";
	public static final String LARGE_FONT = root + File.separator + "assets"  + File.separator + "fonts" + File.separator + "arial_black48.fnt";
	public static final String RENDERER_PATH = root + File.separator + "supercad renderer" + File.separator + "cadrenderer.exe";
	public static final String DOT_OBJ_FOLDER = APP_DATA + File.separator + "dotobj";
	public static final String MONKEY_ENGINE = root + File.separator + "sMonkeyEngine" + File.separator + "sMonkeyEngine.exe";
	public static final String MATERIALSWall = MATERIALS_FOLDER + File.separator + "WallTexture";
	public static final String PREF = root + File.separator +"pref";
	public static final String REPORTINGPROPS = PREF + File.separator +"reporting.properties";
	public static final String ACCESSOIRES_IMAGES=root + File.separator+ "accesoires_images";
	public static final String JETTY_HOST = "http://localhost:8080";
	private final static String DATA=root + File.separator + "Data";
	private final static String KITCHEN_DATA=DATA + File.separator + "kitchen";
	public static final String MATERIALS = DATA + File.separator + "materials.data";
	public static final String SYSTEM_MATERIALS = DATA + File.separator + "system_materials.data";
	public static final String GESTION = DATA + File.separator + "gestion.data";

	public static final String CHANTS = DATA + File.separator + "chants.data";
	public static final String MATERIAL_TYPES = DATA + File.separator + "materialTypes.data";
	private static final String KITCHEN_PROJECTS=KITCHEN_DATA+ File.separator +"projects";
	private final static String KITCHEN_LIBRARIES = KITCHEN_DATA + File.separator + "libraries";
	private final static String library = KITCHEN_LIBRARIES + File.separator + "ModelPrams.library";

	public static final String APP_CONFIG = DATA + File.separator +"app.config";
	public static final String PARAMETERS = DATA + File.separator +"app.params";
	public static final String COMPANY_CONFIG = DATA + File.separator +"company.config";
	public static final String CATALOGS = KITCHEN_DATA + File.separator +"catalogs";
	public static final String APP_PREFERENCE = PREF + File.separator +"app.pref";
	public static final String ACCESSOIRES=DATA + File.separator+ "accesoires.data";
	public static final String ARTICLE_FAMILIES=DATA + File.separator+ "articlesFamilies.data";
	public static final String QUINCAILLERIES=DATA + File.separator+ "quincailleries.data";

	public static final String SUPERCOUPEPROPS = PREF + File.separator +"supercoupe.properties";
	public static final String MODULESPROPS = PREF + File.separator +"modules.properties";

	public static final String BIBLIOTEQUEAccessoire =root + File.separator + "accessoire";
	public static final String ELEMENT_FOOT_PATH = root + File.separator + "assets" + File.separator + "feet" +  File.separator + "foot.obj";
	public static String TMP_FOLDER = APP_DATA + File.separator + "tmp";
	
	public static final String LOG_PATH = APP_DATA + File.separator + "log";

	public WorkspaceConfiguration() {
		super();
	}
	
	public static String getLibraryPath() {
		File file=new File(library);
		if(!file.exists()) {
			file.mkdirs();
		}
		return library;
	}
	public static String getLibrariesPath() {
		File file=new File(KITCHEN_LIBRARIES);
		if(!file.exists()) {
			file.mkdirs();
		}
		return KITCHEN_LIBRARIES;
	}
	public static File getDefaultConfDir() {
		File file=new File(root);
		if(!file.exists()) {
			file.mkdirs();
		}
		return file;
	}
	public static String getModelsDir() {
		File file = new File(modelsDir);
		if(!file.exists())
			file.mkdirs();
		return modelsDir;
	}
	public static String getConfDirpath() {
		return getDefaultConfDir().getAbsolutePath();
	}
	
	
	public static String getProjectsBackupFolder() {
		return WorkspaceConfiguration.getProjectsPath() +File.separator+"backup";
	}
	public static String getProjectsPath() {
		File projectsDir = new File(WorkspaceConfiguration.KITCHEN_PROJECTS);
		if (!projectsDir.exists()) {
			projectsDir.mkdirs();
			 System.err.println(projectsDir.setExecutable(true));	
		        System.err.println(projectsDir.setReadable(true));
		        System.err.println(projectsDir.setWritable(true,false));
		}
		return projectsDir.getAbsolutePath();
	}
	public static String getAccessoireImagesPath() {
		File accessoiresPathImagesDir = new File(WorkspaceConfiguration.ACCESSOIRES_IMAGES);
		if (!accessoiresPathImagesDir.exists()) {
			accessoiresPathImagesDir.mkdirs();
			 System.err.println(accessoiresPathImagesDir.setExecutable(true));	
		        System.err.println(accessoiresPathImagesDir.setReadable(true));
		        System.err.println(accessoiresPathImagesDir.setWritable(true,false));
		}
		return accessoiresPathImagesDir.getAbsolutePath();
	}
	public static String getIconsPath() {
		File accessoiresPathImagesDir = new File(WorkspaceConfiguration.ICONS);
		if (!accessoiresPathImagesDir.exists()) {
			accessoiresPathImagesDir.mkdirs();
			 System.err.println(accessoiresPathImagesDir.setExecutable(true));	
		        System.err.println(accessoiresPathImagesDir.setReadable(true));
		        System.err.println(accessoiresPathImagesDir.setWritable(true,false));
		}
		return accessoiresPathImagesDir.getAbsolutePath();
	}
	public static String getCatalogsPath() {
		String path=WorkspaceConfiguration.CATALOGS;
		File projectsDir = new File(path);
		if (!projectsDir.exists()) {
			projectsDir.mkdirs();
			 System.err.println(projectsDir.setExecutable(true));	
		        System.err.println(projectsDir.setReadable(true));
		        System.err.println(projectsDir.setWritable(true,false));
		}
		return path;
	}
	public static String getARTICLE_FAMILIES() {
		String path=WorkspaceConfiguration.ARTICLE_FAMILIES;
		File families = new File(path);
		if (!families.exists()) {
			families.mkdirs();
			 System.err.println(families.setExecutable(true));	
		        System.err.println(families.setReadable(true));
		        System.err.println(families.setWritable(true,false));
		}
		return path;
	}
	public static String  getAccessoiresPath() {
		File accessoirefile=new File(WorkspaceConfiguration.ACCESSOIRES);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.ACCESSOIRES;
	}
	
	//
	public static String getGestionsPath() {
		File accessoirefile=new File(WorkspaceConfiguration.GESTION);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.GESTION;
	}
	//
	public static String  getMaterialsPath() {
		File accessoirefile=new File(WorkspaceConfiguration.MATERIALS);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.MATERIALS;
	}
	//
	public static String  getSystemMaterialsPath() {
		File accessoirefile=new File(WorkspaceConfiguration.SYSTEM_MATERIALS);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.SYSTEM_MATERIALS;
	}
	public static String  getMaterialsTypesPath() {
		File accessoirefile=new File(WorkspaceConfiguration.MATERIAL_TYPES);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.MATERIAL_TYPES;
	}
	public static String  getChantsPath() {
		File accessoirefile=new File(WorkspaceConfiguration.CHANTS);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.CHANTS;
	}
	
	
	//
	public static String  getConfigurationPreferencePath() {
		File accessoirefile=new File(WorkspaceConfiguration.APP_PREFERENCE);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.APP_PREFERENCE;
	}
	public static String  getQuincailleriesPath() {
		File accessoirefile=new File(WorkspaceConfiguration.QUINCAILLERIES);
		if(!accessoirefile.exists()) {
			accessoirefile.getParentFile().mkdirs();
		}
		return WorkspaceConfiguration.QUINCAILLERIES;
	}
	
	public static String  getLogPath() {
		File logpath=new File(WorkspaceConfiguration.LOG_PATH);
		if(!logpath.exists()) {
			logpath.mkdirs();
		}
		return WorkspaceConfiguration.LOG_PATH;
	}
	
	/**
	 * cette méthode
	 * 
	 * @param path
	 * @param isfromworkspace
	 * @param display
	 * @return
	 */
	public static File getimage(String path, boolean isfromworkspace, Display display) {
		File testImage = null;
		if (isfromworkspace) {
			testImage = new File(getDefaultConfDir().getAbsoluteFile() + File.separator + path);
			if (!testImage.exists()) {
				loadPictures();
			}
			return testImage;
		} else {
			testImage = new File(getDefaultConfDir().getAbsoluteFile() + File.separator + path);
		}
		return testImage;
	}
	
	
	public static String getTexturesFolder() {
		return TEXTURES_FOLDER;
	}

	public static  void loadPictures() {
		@SuppressWarnings("deprecation")
		Bundle bundle = Platform.getBundle("Dressing");
		File pictures = null;
		String pp = bundle.getLocation();
		String p2 = pp.substring(bundle.getLocation().indexOf("file:"));
		p2 = p2.substring(5, p2.length());
		pictures = new File(p2 + "pictures/");

		// }
		if (pictures.exists()) {
			System.err.println("exist");

			File origin = new File(WorkspaceConfiguration.getDefaultConfDir() + "/pictures");

			try {
				if (!origin.exists()) {
					origin.mkdirs();
					System.err.println(origin.setExecutable(true));
					System.err.println(origin.setReadable(true));
				}
				
				File[] files = pictures.listFiles();
				for (File file : files) {

					File destFile = new File(origin.getAbsolutePath() + File.separator + file.getName());
				
					if (!destFile.exists()) {
						System.err.println(destFile.setExecutable(true));
						System.err.println(destFile.setReadable(true));
						Files.copy(file.toPath(), new FileOutputStream(destFile));
					}
				}

			} catch (IOException e) {
				e.printStackTrace();
			}
			System.err.println("completed");
		}
	
	}
	public static File getimage(String path, boolean isfromworkspace) {
		return getimage(path, isfromworkspace, null);
	}

	public static void main(String[] args) {
		WorkspaceConfiguration wc = new WorkspaceConfiguration();
		String path = wc.getDefaultConfDir().getAbsolutePath();
		System.out.println(path);
	}
	public static String getReportingPrefs() {
		String prefdir=WorkspaceConfiguration.PREF;
		File projectsDir = new File(prefdir);
		if (!projectsDir.exists()) {
			projectsDir.mkdirs();
			 System.err.println(projectsDir.setExecutable(true));	
		        System.err.println(projectsDir.setReadable(true));
		        System.err.println(projectsDir.setWritable(true,false));
		}
		return WorkspaceConfiguration.REPORTINGPROPS;
	}
	
	public static String getModulesPrefs() {
		String prefdirPath = WorkspaceConfiguration.PREF;
		File prefdir = new File(prefdirPath);
		if (!prefdir.exists()) {
			prefdir.mkdirs();
			System.err.println(prefdir.setExecutable(true));
			System.err.println(prefdir.setReadable(true));
			System.err.println(prefdir.setWritable(true, false));
		}
		return WorkspaceConfiguration.MODULESPROPS;
	}
	
	public static String getSupercoupePrefs() {
		String prefdir=WorkspaceConfiguration.PREF;
		File projectsDir = new File(prefdir);
		if (!projectsDir.exists()) {
			projectsDir.mkdirs();
			 System.err.println(projectsDir.setExecutable(true));	
		        System.err.println(projectsDir.setReadable(true));
		        System.err.println(projectsDir.setWritable(true,false));
		}
		return WorkspaceConfiguration.SUPERCOUPEPROPS;
	}
}
