package dressing.cam.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import dressing.model.Trou;
import dressing.model.Usinage;

public class Operation implements Cloneable{

	private Usinage usin;
	CamShape shape;
	PlanUsinage plan;

	public Operation( Usinage usin) {
		super();
		this.usin = usin;
	}
	
	public Operation() {
		super();
	}

	public Usinage getUsin() {
		return usin;
	}

	public void setUsin(Usinage usin) {
		Usinage oldValue=this.usin;
		this.usin = usin;
		firePropertyChange("usin", oldValue, this.usin);
	}

	public PlanUsinage getPlan() {
		return plan;
	}
	public void setPlan(PlanUsinage plan) {
		this.plan = plan;
	}
	public CamShape getShape() {
		if(shape==null) {
			if(usin instanceof Trou) {
				 shape =new Cercle2D((Trou) getUsin(), plan);
			}else {
				shape=new Cuboid(getUsin(), plan);
			}
		}
		return shape;
	}
	
	public void setShape(CamShape shape) {
		this.shape = shape;
	}
	public PropertyChangeSupport getPropertyChangeSupport() {
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		if(propertyChangeSupport==null) {
			propertyChangeSupport = new PropertyChangeSupport(this);
		}
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}
	@Override
	public Operation clone() throws CloneNotSupportedException {
		Operation op=(Operation) super.clone();
		op.usin=null;
		return op;
	}
	
}
