package dressing.cam.model;

import java.awt.Desktop;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.frs.debitage.cam.dxf.model.DXF_Assembler;
import org.frs.debitage.cam.dxf.model.Rotationangle;

import com.badlogic.gdx.math.Vector3;

import dressing.config.ReportingPreferences;
import dressing.io.IOUtilities;
import dressing.mathutils.CoordinateSystem;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Rainure;
import dressing.model.SuperCadProject;
import param.PieceType;

/**
 *
 * @author Administrator
 */
public class DXFFileManager {

	String extension = "dxf";
	String filepath = "";

	public DXFFileManager(String extension) {
		this.extension = extension;
	}

	private void savemodel(Piece2D piece, String filepath) throws Exception {
		savemodel(piece, filepath, 1);
	}

	private int savemodel(Piece2D piece, String filepath, int index) throws Exception {

		Rotationangle angleRotation = Rotationangle.angleRotation0;
		List<PlanUsinage> primaryPlans = new ArrayList<PlanUsinage>();
		boolean isLateralVisible = ReportingPreferences.getInstance().getProperty("DXF.showLateral", true);
		boolean isReduceFaces = ReportingPreferences.getInstance().getProperty("DXF.reducefaces", true);
		boolean isoriented = ReportingPreferences.getInstance().getProperty("DXF.oriented", false);
		boolean isRotatePiece = ReportingPreferences.getInstance().getProperty("DXF.RotatepiecetoFeetMachine", true);
		if (!isoriented) {

			PlanUsinage plan1 = piece.getPrimaryPrespective();
			PlanUsinage plan2 = piece.getSecondaryPrespective();

			List<Cuboid> cuboidsPlan1 = Util.getcuboidsforPlan(plan1, piece);
			List<Cercle2D> cereclesPlan1 = Util.gettrousforPlan(plan1, piece);
			List<Cuboid> cuboidsPlan2 = Util.getcuboidsforPlan(plan2, piece);
			List<Cercle2D> cereclesPlan2 = Util.gettrousforPlan(plan2, piece);
			PlanUsinage plan = plan1;

			int nb1 = 0;
			if (cuboidsPlan1 != null) {
				nb1 += cuboidsPlan1.size();
			}
			if (cereclesPlan1 != null) {
				nb1 += cereclesPlan1.size();
			}
			int nb2 = 0;
			if (cuboidsPlan2 != null) {
				nb2 += cuboidsPlan2.size();
			}
			if (cereclesPlan2 != null) {
				nb2 += cereclesPlan2.size();
			}

			if (nb1 > nb2) {
				plan = plan1;
				primaryPlans.add(plan1);
				if (nb2 > 0) {
     				if(cereclesPlan2.size()>0 ||testerexistencediffextrusion(cuboidsPlan2)==true	) {
     					primaryPlans.add(plan2);
     					
     				}
				}
			} else {
				plan = plan2;
				if (nb2 > 0) {
					primaryPlans.add(plan2);
				}
				if (nb1 > 0) {
     				if(cereclesPlan1.size()>0 ||testerexistencediffextrusion(cuboidsPlan1)==true	) {

     					primaryPlans.add(plan1);
     				}
				}
			}
			if (!isReduceFaces) {
				primaryPlans.clear();
				primaryPlans = Arrays.asList(PlanUsinage.values());
			}
			int i = 1;
			for (PlanUsinage pl : primaryPlans) {

				DXF_Assembler dxfassembler = new DXF_Assembler();
				dxfassembler.setChuteDisk(1);
				dxfassembler.setWidth(Util.getDesignWidth(piece,pl));
				dxfassembler.setHigh(Util.getDesignHeight(piece,pl));
				dxfassembler.setSCALEYValue(0);
				if (isRotatePiece) {
					if (dxfassembler.getHigh() > dxfassembler.getWidth()) {
						angleRotation = Rotationangle.angleRotation90;
					}
				}

				dxfassembler.addEntity(DXFUtils.getDXFLineEntetity(pl, pl.equals(plan) && isLateralVisible, angleRotation,
						isRotatePiece, piece));
				dxfassembler.assemble();
				String s = filepath;
				s = s.replace("@DIM@",
						"PL" + i + "_" + pl.name() + "_" + (int) Util.getDesignWidth(piece,pl) + "X" + (int) Util.getDesignHeight(piece,pl));
				s = s.replace("@ITERATION@", "" + index);
				PrintWriter writer = new PrintWriter(s, "UTF-8");
				writer.print(dxfassembler.getOutput());
				writer.close();
				i++;
			}
			if (i > 1) {
				index = index + i - 1;
			}
			return index;
		} else {
			Map<String, String> codes = DXFGcodeGenerator.getInstance().generateCode(piece);
			Vector3 dimension = CoordinateSystem.getPieceDimension(piece);
			int i = 1;
			for (String key : codes.keySet()) {
				DXF_Assembler dxfassembler = new DXF_Assembler();
				dxfassembler.setChuteDisk(1);
				dxfassembler.setWidth(dimension.x);
				dxfassembler.setHigh(dimension.y);
				dxfassembler.setSCALEYValue(0);
				dxfassembler.addEntity(codes.get(key));
				dxfassembler.assemble();
				String s = filepath;
				s = s.replace("@DIM@", "PL" + i + "_" + key + "_" + (int) dimension.x + "X" + (int) dimension.y);
				s = s.replace("@ITERATION@", "" + index);
				PrintWriter writer = new PrintWriter(s, "UTF-8");
				writer.print(dxfassembler.getOutput());
				writer.close();
				i++;
			}
			if (i > 1) {
				index++;
			}
			return index;
		}
	}
 		
 	
 	
 	private boolean testerexistencediffextrusion(List<Cuboid> cuboidsPlan2) {
 		boolean existancerainnotpenetrant =false;
 		for(Cuboid cuboid : cuboidsPlan2) {
 			if (cuboid.getUsin() instanceof Rainure) {
 				existancerainnotpenetrant=true;
 				break;
 				
 			}
 			else existancerainnotpenetrant=false;
 		}
		return existancerainnotpenetrant;
		// TODO Auto-generated method stub
		
	}
	
	public String saveworkspace(Shell shell, DesignObject3D guilltinesolution) {

		if (!filepath.equals("")) {
			try {
				if (guilltinesolution instanceof Piece2D) {
					this.savemodel((Piece2D) guilltinesolution, filepath);
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			return filepath;
		} else {
			try {
				FileDialog dialog = new FileDialog(shell);
				dialog.setFilterExtensions(new String[] { "*.dxf" });
				String filepath = dialog.open();
				if (filepath != null && !filepath.isEmpty()) {
					// Imed bug 0001710 changer l'exportation dxf dynamyque pour tout les design3D
					createDxfFolder(filepath, guilltinesolution, 1);
					File file = new File(filepath);
					Desktop.getDesktop().open(file);
					return filepath;
				}

				return "";

			} catch (Exception err) {
				err.printStackTrace();
			}
		}
		return "";

	}

	/**
	 * @author Imed
	 * @bug 0001710
	 * @param filepath le path de dossier donner par l'utilisateur
	 * @param design   la racine d'arbre des piece a exporter vers dxf méthode
	 *                 récurive pour créer l'arbre des dossier pour l'objet
	 *                 spécifier et ces fisse
	 * @throws Exception
	 */
	public int createDxfFolder(String filepath, DesignObject3D design, int index) throws Exception {

		if (filepath != null && !filepath.isEmpty() && design != null) {

			if (design instanceof Piece2D) {
				if (((Piece2D) design).getMaterialType() != null
						&& ((Piece2D) design).getMaterialType().getMaterial() != null
						&& ((Piece2D) design).getMaterialType().getMaterial().isProduction() && (((Piece2D) design)
								.getMechanicDesignElementDefinition().getType().equals(PieceType.PIECE2D))) {
					File file = new File(filepath);
					if (!file.exists()) {
						file.mkdirs();
					}
					String monFichier = filepath + File.separator + "P@ITERATION@_" + design.getName().trim() + "_@DIM@"
							+ extension; // R?cup?rer le
					// chemin du
					// fichier
					// sp?cifi?
					index = this.savemodel((Piece2D) design, monFichier, index);
				}
			} else {

				for (DesignObject3D sapce : design.getChilds()) {

					index = createDxfFolder(filepath, sapce, index);
				}
			}
				
		}
		return index;
		}
	
	public void saveKitchenDXF(String filepath,Kitchen kitchen) throws Exception {
    	kitchen.generateElementsUsinage();
    	if(filepath!=null && !filepath.isEmpty()&& kitchen!=null ) {
    		File file=new File(filepath);
			if(!file.exists()) {
    			file.mkdirs();
			}else {
				IOUtilities.deleteFolder(file);
    			file.mkdirs();
			}
			
			String root = "";
			List<DesignObject3D> elements=kitchen.getElementsWithoutFausseFacades();
			int index =1;
			for (DesignObject3D element : elements) {
				root = filepath + File.separator +'N'+( index)+"_"+ element.getName()+"_"+element.getLongeurext() +"_"+element.getProfondeurext()+"_"+element.getHauteurext();
				createDxfFolder(root,element,1);
				index++;
			}
    	}

    }
	public void saveSuperCadProjectDXF(String filepath,SuperCadProject project) throws Exception {
    	if(filepath!=null && !filepath.isEmpty()&& project!=null ) {
    		File file=new File(filepath);
			if(!file.exists()) {
    			file.mkdirs();
			}else {
				IOUtilities.deleteFolder(file);
    			file.mkdirs();
			}
			String root = "";
			for (int i =0;i<project.getKitchens().size();i++) {
				Kitchen kitchen= project.getKitchens().get(i);
				root = file.getAbsolutePath() + File.separator + kitchen.getName() + " N" + i;
				saveKitchenDXF(root, kitchen);
			}
    	}

    }
     
     public String getFilepath() {
         return filepath;
     }

     public void setFilepath(String filepath) {
         this.filepath = filepath;
     }
       
}