package com.frs.supercad.dressing.provider;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.eclipse.emf.ecore.util.EcoreUtil;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.math.Vector3;

import dressing.config.WorkspaceConfiguration;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.persistence.mappers.MapperProvider;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import gdxapp.assets.ModelExporter;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.shaders.PbrMaterial;
import param.MechanicDesign;
import param.impl.MaterialTypeImpl;
import param.impl.MaterialTypeInstanceImpl;
import param.impl.Vertice3Impl;
import supercad.persistence.databinding.XmlMapper;

public class PreviewModelProvider {
	
	private PbrMaterial defaultMaterial;
	private static PreviewModelProvider provider;
	private final HashMap<String, Map> previews = new HashMap<String, Map>();
	
	private PreviewModelProvider() {
		init();
	}
	
	
	
	public void init() {
		createDefaultMaterial();
		scanCaheFolder();
	}

	private void createDefaultMaterial() {
		defaultMaterial = new PbrMaterial();
		defaultMaterial.setAlbedo(new Vector3(1,1,1));
		defaultMaterial.setMetalness(0.04f);
		defaultMaterial.setRoughness(0.4f);
		defaultMaterial.setOpacity(1);		
	}

	
	public void scanCaheFolder() {
		String dir = WorkspaceConfiguration.DOT_OBJ_FOLDER;
		File folder = new File(dir);
		if(!folder.exists()) {
			folder.mkdirs();
		}
		FileFilter folderFilter = new FileFilter() {
			@Override
			public boolean accept(File pathname) {
				return pathname.isDirectory();
			}
		};
		for(var subFolder: folder.listFiles(folderFilter)){
			String infoFile = null;
			for(var fileX: subFolder.listFiles()) {
				if(fileX.isFile() && fileX.getName().endsWith("info.xml")) {
					infoFile = fileX.getAbsolutePath();
					break;
				}
			}
			if(infoFile != null) {
				File infoF = new File(infoFile);
				Map<String, Object> info = MapperProvider.getXmlMapper().fromXml(infoF, HashMap.class);
				previews.put(subFolder.getName(), info);
			}
		}
	}


	
	
	public DesignObject3D createPreviewDesignObject(MechanicDesign design) {
		MechanicDesign clone =  EcoreUtil.copy(design);
		Vertice3Impl v3= new Vertice3Impl();
		v3.setR(defaultMaterial.getAlbedo().x);
		v3.setG(defaultMaterial.getAlbedo().y);
		v3.setB(defaultMaterial.getAlbedo().z);
		MaterialTypeInstanceImpl mtlImpl = new MaterialTypeInstanceImpl();
		MaterialTypeImpl materialImpl = new MaterialTypeImpl();
		materialImpl.setAlbedo(v3);
		materialImpl.setMetalness(defaultMaterial.getMetalness());
		materialImpl.setRoughness(defaultMaterial.getRoughness());
		materialImpl.setOpacity(defaultMaterial.getOpacity());
		mtlImpl.setMaterial(materialImpl);
		clone.setFacadeMaterialType(EcoreUtil.copy(mtlImpl));
		clone.setPrincipalMaterialType(EcoreUtil.copy(mtlImpl));
		clone.setSecondMaterialType(EcoreUtil.copy(mtlImpl));
		DesignObject3D designobject=null;
		try {
			designobject = MechanicDesignCreator.getInstance().constructObject(clone);
		} catch (Exception e) {
			System.out.println("un erreur est servenue lors de création du model " + design.toString());
			e.printStackTrace();
		}	
		return designobject;
	}
	
	public Map<String, Object> getOrCreatePreviewPath(MechanicDesign design) {
		String modelName = design.getName().trim();
		Map<String, Object> info  = previews.get(modelName);
		if(info == null) {
			info = new HashMap<String, Object>();
			DesignObject3D designObject =  createPreviewDesignObject(design);
			KitchenElement element = WorldObjectFactory.getFactory().createObjectFromDefinition(designObject,
					false);
			if(element.getDoorHandles() != null) {
				PbrMaterial doorHandleMtl = new PbrMaterial();
				doorHandleMtl.setAlbedo(new Vector3());
				doorHandleMtl.setMetalness(0.5f);
				doorHandleMtl.setRoughness(0.1f);
				element.getDoorHandles().values().forEach(handle -> handle.setMaterial(doorHandleMtl));
			}
			String dir = WorkspaceConfiguration.DOT_OBJ_FOLDER + File.separator + modelName;
			ModelExporter exporter = new ModelExporter();
			exporter.exportMechanicKitchenElement(element, dir, modelName, "");
			String path = dir + File.separator + modelName + ".obj";
			info.put("value", path);
			Vector3 modelSize = designObject.getSize().scl(0.001f); 
    		info.put("size", new float[] { modelSize.x, modelSize.y, modelSize.z});
    		File infoFile = new File(dir + File.separator + "info.xml");
    		MapperProvider.getXmlMapper().write(info, infoFile);
			previews.put(modelName.trim(), info);
		}
		return info;
	}
	
	
	
	public static PreviewModelProvider getProvider() {
		if(provider == null)
			provider = new PreviewModelProvider();
		return provider;
	}

	public static void setProvider(PreviewModelProvider provider) {
		PreviewModelProvider.provider = provider;
	}
}
