package gdxapp.screens.ObjectEditor;

import java.util.HashMap;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;

import dressing.events.Event;
import dressing.events.EventHandler;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.Object3D;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.ObjectEditor.uicomponents.BottomBar;
import gdxapp.screens.ObjectEditor.uicomponents.LeftBar;
import gdxapp.screens.ObjectEditor.uicomponents.RightBar;
import gdxapp.screens.ObjectEditor.uicomponents.TopBar;

public class ObjectEditorUILayer extends Table implements EventHandler{
	
	TopBar topBar;
	LeftBar leftBar;
	RightBar rightBar;
	BottomBar bottomBar;
	
	public ObjectEditorUILayer() {
		super();
		createContent();
		subscribe(SceneEvent.MSG.name(), SceneEvent.LAYOUT_BTN_PRESSED.name(),
				SceneEvent.MODELING_BTN_PRESSED.name(), SceneEvent.DISPLAY_ACTIONS_MENU.name(),
				SceneEvent.CLEAR_KEYBOARD_FOCUS.name());
	}
	
	public void createContent() {
		createTopBar();
		createLeftBar();
		createRightBar();
		createBottomBar();
		add(topBar).colspan(2).expandX().height(100);
		row();
		add(leftBar).expand().fillY().width(100).left();
		add(rightBar).expand().fillY().width(100).right();
		row();
		add(bottomBar).colspan(2).expandX().height(100);
	}

	private void createBottomBar() {
		bottomBar = new BottomBar();
	}

	private void createRightBar() {
		rightBar = new RightBar();
	}

	private void createLeftBar() {
		leftBar = new LeftBar();
	}

	private void createTopBar() {
		topBar = new TopBar();
	}

	@Override
	public void handle(Event event) {
		SceneEvent eventX = SceneEvent.valueOf(event.getTopic());
		switch(eventX) {
		case LAYOUT_BTN_PRESSED:
			leftBar.setForLayout();
			break;
		case MODELING_BTN_PRESSED:
			leftBar.setForModeling();
			break;
		case DISPLAY_ACTIONS_MENU:
			displayRightClickMenu(event);
			break;
		case MSG:
			bottomBar.getNameLabel().setText((String) event.getData());
			break;
		case CLEAR_KEYBOARD_FOCUS:
			getStage().setKeyboardFocus(null);
			break;
		}
	}

	private void displayRightClickMenu(Event event) {
		HashMap<String,Object> info = (HashMap<String, Object>) event.getData();
		Vector2 location = (Vector2) info.get("location");
		Object3D target = (Object3D) info.get("object");
		Object3DRightClickMenu.getInstance().setPosition(location.x, location.y);
		Object3DRightClickMenu.getInstance().setSubject(target);
		getStage().addActor(Object3DRightClickMenu.getInstance());
		Object3DRightClickMenu.getInstance().makeKeyBoardFocus();
	}
	
}
