package dressing.ui.util;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.ui.project.SocleSettingComposite;
import gdxapp.object3d.PlinthObject;
import gdxapp.scenes.SceneEvent;

public class PlinthCreationWindow extends Window {
    
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 280;
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 280;
    
    private PlinthObject plinthObject;
    private SocleSettingComposite composite;

    public PlinthCreationWindow(Shell parentShell, PlinthObject object) {
        super(parentShell);
        setShellStyle(SWT.CLOSE | SWT.TITLE | SWT.RESIZE | SWT.APPLICATION_MODAL);
        setBlockOnOpen(true);
        this.plinthObject = object;
    }
    
    @Override
    protected Control createContents(Composite parent) {
        // Configure shell
        Shell shell = parent.getShell();
        shell.setText("Création du socle");
        shell.setLayout(new FillLayout());
        
        // Create main composite
        composite = new SocleSettingComposite(parent, SWT.NONE, plinthObject, () -> {
        	Display.getDefault().asyncExec(() -> close());
        }, true);
        
        // Add resize listener to handle minimum size
        shell.addControlListener(new ControlAdapter() {
            @Override
            public void controlResized(ControlEvent e) {
                enforceMinimumSize(shell);
            }
        });
        
        // Center window and set initial size
        centerShell(shell);
        
        return composite;
    }
    
    
    
    
    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(MIN_WIDTH, MIN_HEIGHT);
    }
    
    private void centerShell(Shell shell) {
        Rectangle parentBounds = shell.getParent().getBounds();
        int x = (parentBounds.width - DEFAULT_WIDTH) / 2 + parentBounds.x;
        int y = (parentBounds.height - DEFAULT_HEIGHT) / 2 + parentBounds.y;
        shell.setBounds(x, y, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    
    private void enforceMinimumSize(Shell shell) {
        Point size = shell.getSize();
        if (size.x < MIN_WIDTH || size.y < MIN_HEIGHT) {
            shell.setSize(
                Math.max(MIN_WIDTH, size.x),
                Math.max(MIN_HEIGHT, size.y)
            );
        }
    }
    
    @Override
    public boolean close() {
        return super.close();
    }
}