package dressing.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.cam.model.Usinage;
import dressing.handlers.AddUsinageTrou;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import param.Material;
import param.MechanicPublicParam;
import param.PublicParamGroup;


public class Space3DFree extends Space3D {
	
	protected  ArrayList<ModelAccessoire> accessoires = new ArrayList<ModelAccessoire>();
	protected  ArrayList<ModelQuincaillerie> quincailleries = new ArrayList<ModelQuincaillerie>();

	@Override
	public void addElement(DesignObject3D child) throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		if(child ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}
		if(canHold(child))
		{						
			if(child!=null)
			{
				child.addPropertyChangeListener(new PropertyChangeListener() {
					
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						// TODO Auto-generated method stub
						if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
							firePropertyChange("project.modify", null, child);
						}
						
					}
				});
			}
			
			childs.add(child);
			child.setParentdesign(this);			
			firePropertyChange("project.child.added", null, child);
		}
		else
		{
			throw new DesignException("Impossible d'ajouter "+child.getName());
		}

	}

	@Override
	public DesignObject3D clone() {
		Space3DFree space=new Space3DFree();
		try {
			space=(Space3DFree) this.copy((Space3DFree)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return space;
	}

	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Space3DFree space=(Space3DFree) object;
		space=(Space3DFree) super.copy((Space3D)space);
		
		
		List<Usinage> usins = getUsinages(space);
		for (Usinage usin : usins) {
			DesignObject3D mother = DesignObject3D.getUsinageMother(usin, space.getRootCaisson());
			usin.setMother(mother);
			if (mother != null) {
				mother.addBaby(usin);
			}
		}
		return super.copy(object);
	}
	public ArrayList<ModelAccessoire> getAccessoires() {
		if(accessoires==null) {
			accessoires=new ArrayList<ModelAccessoire>();
		}
		return accessoires;
	}

	public void setAccessoires(ArrayList<ModelAccessoire> accessoires) {
		this.accessoires = accessoires;
	}

	public ArrayList<ModelQuincaillerie> getQuincailleries() {
		if(quincailleries==null) {
			quincailleries=new ArrayList<ModelQuincaillerie>();
		}
		return quincailleries;
	}

	public void setQuincailleries(ArrayList<ModelQuincaillerie> quincailleries) {
		this.quincailleries = quincailleries;
	}

	public void addAccessoire(ModelAccessoire accessoire) {
		if(accessoires!=null && accessoire!=null)
		{
			ModelAccessoire accessoireold=null;
			for(ModelAccessoire access:accessoires) {
				if(access.getAccessoire().getAccessoire().equals(accessoire.getAccessoire().getAccessoire())) {
					accessoireold=access;
					break;
				}
			}
			if(accessoireold!=null) {
				accessoireold.setNumber(accessoireold.getNumber()+accessoire.getNumber());
			}else {
				accessoires.add(accessoire);
			}
		}
	}
	public void addQuincaillerie(ModelQuincaillerie quincaillerie) {
		if(quincailleries!=null && quincaillerie!=null)
		{
			ModelQuincaillerie quincaillerieold=null;
			for(ModelQuincaillerie access:quincailleries) {
				if(access.getQuincaillerie().getQuincaillerie().equals(quincaillerie.getQuincaillerie().getQuincaillerie())) {
					quincaillerieold=access;
					break;
				}
			}
			if(quincaillerieold!=null) {
				quincaillerieold.setNumber(quincaillerieold.getNumber()+quincaillerie.getNumber());
			}else {
				quincailleries.add(quincaillerie);
			}
		}
	}

	@Override
	public DesignObject3D getRoot() {
		if(mechanicDesignDefinition!=null) {
			return this;
		}
		return super.getRoot();
	}
	public DesignObject3D update() throws Exception {

		PublicParamGroup publicparams = this.mechanicDesignDefinition.getPublicparamgroup();

		MechanicPublicParam ep = publicparams.getParam("global.ep");
		MechanicPublicParam epback = publicparams.getParam("global.epback");
		MechanicPublicParam epface = publicparams.getParam("global.epface");

		ep.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getPrincipalmaterial().getEpaisseur()));
		epback.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getSecondmaterial().getEpaisseur()));
		epface.setDefaultvalue(String.valueOf(this.mechanicDesignDefinition.getFacadeMaterial().getEpaisseur()));

		DesignObject3D parent = this.getParentdesign();
		clearautomatique(false);
		MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), parent, this,
				this.mechanicDesignDefinition, MechanicDesignCreator.update,false);

		return this;
	}
	
	public void updateMaterials() throws Exception {
		Material principal = mechanicDesignDefinition.getPrincipalmaterial();
		Material secondary = mechanicDesignDefinition.getSecondmaterial();
		Material facade = mechanicDesignDefinition.getFacadeMaterial();

		double currentEp = principal != null ? principal.getEpaisseur() : 0.0;
	    double currentEpBack = secondary != null ? secondary.getEpaisseur() : 0.0;
	    double currentEpFace = facade != null ? facade.getEpaisseur() : 0.0;
	    
		PublicParamGroup publicParams = mechanicDesignDefinition.getPublicparamgroup();

		double defaultEp = MechanicDesignCreator.getInstance().safeParseParam(publicParams, "global.ep",currentEp);
		double defaultEpBack = MechanicDesignCreator.getInstance().safeParseParam(publicParams, "global.epback",currentEpBack);
		double defaultEpFace = MechanicDesignCreator.getInstance().safeParseParam(publicParams, "global.epface",currentEpFace);

		boolean hasChanged = Double.compare(currentEp, defaultEp) != 0
				|| Double.compare(currentEpBack, defaultEpBack) != 0
				|| Double.compare(currentEpFace, defaultEpFace) != 0;

		if (hasChanged) {
			update(); // assumes this updates all affected pieces
		} else {
			for (Piece2D piece : getListPieces()) {
				MechanicDesignCreator.getInstance().updateDesignElement(mechanicDesignDefinition,
						piece.getMechanicDesignElementDefinition(), piece);
			}
		}
	}
	
	public DesignObject3D refresh() throws Exception {
		AddUsinageTrou.createUsinage(this, false);
//		DesignObject3D parent = this.getParentdesign();
//		clearautomatique(false);
//		MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), parent, this,
//				this.mechanicDesignDefinition, MechanicDesignCreator.update,true);

		return this;
	}
	
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
		if(accessoires!=null)accessoires.clear();
		if(quincailleries!=null)quincailleries.clear();
		accessoires=null;
		quincailleries=null;
	}
}


