package dressing.io;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import dressing.model.persistence.dpos.Object3D;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import jakarta.xml.bind.JAXBException;
import param.MechanicDesign;
import param.MechanicPublicParam;

public class ProjectRecoveryTool {

	private Shell shell;

	private File projectFile, sceneFile, elementsFile;
	private boolean SCENE_FILE_MISSING = true;
	private boolean PROJECT_FILE_MISSING = true;
	private boolean ELEMENSTS_FILE_MISSING = true;
	private SuperCadProject project;
	private Kitchen kitchen;
	private Scene scene;
	private ArrayList<MechanicDesign> designs;
	HashMap<UUID, KitchenElement> objectIdentifiers = new HashMap<>();

	private ArrayList<Object3D> objectsFromSceneFile;

	private static ProjectRecoveryTool recoveryTool;

	private ProjectRecoveryTool() {
	}

	// only recover the elements of the kitchen for now.
	// to do: extend the tool to recover marble, walls and other scene objects
	public void recoverProject(String path) {

		File root = new File(path);
		scanForFiles(path);
		if (SCENE_FILE_MISSING && ELEMENSTS_FILE_MISSING) {
			MessageDialog.openError(shell, "Project Recovery Tool", "Can not recover the project!");
			return;
		}
		if (!ELEMENSTS_FILE_MISSING) {
			recoverDesigns();
		}
		if (!SCENE_FILE_MISSING) {
			Object data;
			try {
				data = MapperProvider.getXmlMapper().fromXml(sceneFile, Object.class);
				if (data instanceof Scene) {
					scene = (Scene) data;
					for (Object3D object : scene.getObjects()) {
						if (object.getObjectType() == ObjectType.DEFINED) {
							KitchenElement element = objectIdentifiers.get(object.getUuid());
							if (element != null) {
								MechanicPublicParam paramL;
								try {
									paramL = element.getMechanicDesign().getPublicParam("global.l");
									if (paramL != null) {
										paramL.setDefaultvalue(String.valueOf((int) (object.getDimension().x * 1000)));
									}
									MechanicPublicParam paramH = element.getMechanicDesign().getPublicParam("global.h");
									if (paramH != null) {
										paramH.setDefaultvalue(String.valueOf((int) (object.getDimension().y * 1000)));
									}
									MechanicPublicParam paramP = element.getMechanicDesign().getPublicParam("global.p");
									if (paramP != null) {
										paramP.setDefaultvalue(String.valueOf((int) (object.getDimension().z * 1000)));
									}
									MechanicPublicParam paramlargeur = element.getMechanicDesign()
											.getPublicParam("global.largeur");
									if (paramlargeur != null) {
										paramlargeur.setDefaultvalue(
												String.valueOf((int) (object.getDimension().w * 1000)));
									}
									Space3DFree space = ((Space3DFree) element.getDesignObject());
									space.update();
								} catch (Exception e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
								element.setRealWorldDimension(object.getDimension());
								element.setRealWorldPosition(object.getPosition());
								element.setRotation(object.getRotation());
								element.setRequireRefrech(true);
								scene.addActor(element, false);
							}
						}
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if (PROJECT_FILE_MISSING) {
			project = new SuperCadProject();
		} else {
			project =  MapperProvider.getXmlMapper().fromXml(projectFile, SuperCadProject.class);
			project.initAfterRead();

			if (project.getName() == null || project.getName().contentEquals(""))
				project.setName(root.getName());
			project.setProjectDirectory(WorkspaceConfiguration.getProjectsPath() + File.separator + project.getName());
			project.getKitchens().get(0).setElements(kitchen.getElements());
			project.getKitchens().get(0).setScene(scene);

			// project.getKitchens().get(0).getScene().setSceneObjects(scene.getSceneObjects());
			String pathX = WorkspaceConfiguration.getProjectsPath() + "\\" + project.getName();
			// ProjectManager.getManager().saveProject(project, pathX, false, false);
			ProjectManager.getManager().setCurrentProject(project, false);
		}

		MessageDialog.openConfirm(shell, "project recovery tool", "Project recovered, restart!");
		System.err.println("project recovered ");
	}

	private void scanForFiles(String path) {
		File root = new File(path);
		if (!root.exists()) {
			MessageDialog.openError(shell, "Project Recovery Tool", "not a project folder");
			return;
		}
		ArrayList<File> files = IOUtilities.listFilesRec(root);
		for (File fileX : files) {
			if (fileX.getName().contentEquals("scene.xml")) {
				sceneFile = fileX;
				SCENE_FILE_MISSING = false;
			}
			if (fileX.getName().contentEquals("elements.xml")) {
				elementsFile = fileX;
				ELEMENSTS_FILE_MISSING = false;
			}
			if (fileX.getName().contentEquals("proj.xml")) {
				projectFile = fileX;
				PROJECT_FILE_MISSING = false;
			}
		}
	}

	private void recoverDesigns() {
		Resource resource = ResourceManagers.getIntance()
				.loadResource(URI.createFileURI(elementsFile.getAbsolutePath()),true);
		kitchen = new Kitchen(project);
		for (Object obj : resource.getContents()) {
			if (obj instanceof MechanicDesign) {
				MechanicDesign md = (MechanicDesign) obj;
				MechanicDesign mdFromLibraryByID = ModelProvider.getMechanicDesignById(md.getModelId());
				MechanicDesign mdFromLibraryByName = ModelProvider.getMechanicDesignByName(md.getName());
				MechanicDesign usedDesign = md;
				DesignObject3D designobject;
				try {
					designobject = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(),
							null, null, md, MechanicDesignCreator.open, false);
				} catch (DesignException | GeometricEngineException e) {
					try {
						designobject = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(),
								null, null, mdFromLibraryByID, MechanicDesignCreator.create, false);
					} catch (NullPointerException | DesignException | GeometricEngineException ex) {
						try {
							designobject = MechanicDesignCreator.getInstance().constructObject(
									ModelProvider.getModelroot(), null, null, mdFromLibraryByName,
									MechanicDesignCreator.create, false);
						} catch (NullPointerException | DesignException | GeometricEngineException exc) {
							exc.printStackTrace();
							System.err.println("recovery of " + md.getName() + " has failed");
							continue;
						}
					}
				}
				try {
					kitchen.addElement(designobject);
					kitchen.getElementDefinitions().add(usedDesign);
					KitchenElement element = WorldObjectFactory.getFactory().createObjectFromDefinition(designobject);
					objectIdentifiers.put(md.getId(), element);

				} catch (DesignException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}

	}

	public Shell getShell() {
		return shell;
	}

	public void setShell(Shell shell) {
		this.shell = shell;
	}

	public static ProjectRecoveryTool getRecoveryTool() {
		if (recoveryTool == null)
			recoveryTool = new ProjectRecoveryTool();
		return recoveryTool;
	}

}
