package gdxapp.Commun;

import java.util.ArrayList;
import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.model.ProjectManager;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;

public class ActionProcessor {
	
	private Scene scene;
	
	private boolean showTop = true;
	private boolean showBottom = true;
	private boolean showColonne = true;
	private boolean freezeTop = false;
	private boolean freezeBottom = false;
	private boolean freezeColonne = false;
	private static boolean showInnerQuotations = false;
	private static boolean showOuterQuotations = false;
	
	private final static ActionProcessor processor = new ActionProcessor(); 
	
	public void process() {
		
	}
	
	public void toggleShowTop() {
		scene = ProjectManager.getManager().getCurrentScene();
		ArrayList<KitchenElement> objects = scene.getWorldObjectsByFamilyType(WorldObjectFactory.haut);
		for(KitchenElement wObject : objects) {
			if(showTop) {
				scene.unhide(wObject);
			}else {
				scene.hide(wObject);
			}
		}
	}
	
	public void toggleShowBottom() {
		scene = ProjectManager.getManager().getCurrentScene();
		ArrayList<KitchenElement> objects = scene.getWorldObjectsByFamilyType(WorldObjectFactory.Bas);
		for(KitchenElement wObject : objects) {
			if(showBottom) {
				scene.unhide(wObject);
			}else {
				scene.hide(wObject);
			}
		}
	}
	
	public void toggleShowColonne() {
		scene = ProjectManager.getManager().getCurrentScene();
		ArrayList<KitchenElement> objects = scene.getWorldObjectsByFamilyType(WorldObjectFactory.colonne);
		for(KitchenElement wObject : objects) {
			if(showColonne) {
				scene.unhide(wObject);
			}else {
				scene.hide(wObject);
			}
		}
	}
	
	public void toggleFreezeTop() {
		freezeTop=!freezeTop;
		scene = ProjectManager.getManager().getCurrentScene();
		ArrayList<KitchenElement> objects = scene.getWorldObjectsByFamilyType(WorldObjectFactory.haut);
		for(KitchenElement wObject : objects) {
			wObject.setMoveable(!freezeTop);
		}
	}
	
	public void toggleFreezeBottom() {
		freezeBottom=!freezeBottom;
		scene = ProjectManager.getManager().getCurrentScene();
		ArrayList<KitchenElement> objects = scene.getWorldObjectsByFamilyType(WorldObjectFactory.Bas);
		for(KitchenElement wObject : objects) {
			wObject.setMoveable(!freezeBottom);
		}
	}
	
	public void toggleFreezeColonne() {
		freezeColonne=!freezeColonne;
		scene = ProjectManager.getManager().getCurrentScene();
		ArrayList<KitchenElement> objects = scene.getWorldObjectsByFamilyType(WorldObjectFactory.colonne);
		for(KitchenElement wObject : objects) {
			wObject.setMoveable(!freezeColonne);
		}
	}
	private void toggleShowInnerQuotation() {
//		scene = ProjectManager.getManager().getCurrentScene();
//		for(WorldObject wObject : scene.getSceneObjects()) {
//			if(!(wObject instanceof Wall)){
//				wObject.setDrawInnerQuotations(showInnerQuotations);
//			}
//		}
	}
	
	private void toggleShowOuterQuotation() {
		showOuterQuotations = !showOuterQuotations;
		if(showOuterQuotations) {
			EventDriver.getDriver().deliverEvent(SceneEvent.QUOTS_REQUEST, null);
		}else {
			EventDriver.getDriver().deliverEvent(SceneEvent.HIDE_QUOTS, null);

		}
	}
	


	public static ActionProcessor getProcessor() {
		return processor;
	}

	public boolean isShowTop() {
		return showTop;
	}

	public void setShowTop(boolean value) {
		boolean changed=false;
		if(showTop != value) {
			changed=true;

		}
		this.showTop = value;
		if(changed)
		{
			toggleShowTop();
		}

	}

	public boolean isShowBottom() {
		return showBottom;
	}

	public void setShowBottom(boolean value) {
		boolean changed=false;
		if(showBottom != value) {
			changed=true;
		}
		showBottom = value;
		if(changed)
		{
			toggleShowBottom();
		}

	}

	public boolean isShowColonne() {
		return showColonne;
	}

	public void setShowColonne(boolean value) {
		boolean changed=false;
		if(showColonne != value){
			changed=true;
		}
		this.showColonne = value;
		if(changed) {
			toggleShowColonne();
		}

	}

	public static boolean isShowInnerQuotations() {
		return showInnerQuotations;
	}

	public void setShowInnerQuotations(boolean value) {
		boolean changed=false;
		
		if(showInnerQuotations != value) 
		{
			changed=true;
		}
		showInnerQuotations = value;

		if(changed) 	
		{
			toggleShowInnerQuotation();
		}
	}

	public static boolean isShowOuterQuotations() {
		return showOuterQuotations;
	}

	public void setShowOuterQuotations(boolean value) {
		boolean changed=false;
		if(value != showOuterQuotations) 
		{
			changed=true;
		}			
		if(changed) 	
		{
			toggleShowOuterQuotation();
		}
	}

	public void hideSelected() {
		if(GroupSelection.getInstance().getSelection() != null) {
			for(Object object: GroupSelection.getInstance().getSelection()) {
				if(object instanceof Object2D) {
					ProjectManager.getManager().getCurrentScene().hide(((Object2D) object).getWorldObject());
				}
			}
		}
		
	}
	
	public void showHiddenElements() {
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.UNHIDE_ALL.name(), null));
	}

}
