package test;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.badlogic.gdx.backends.lwjgl.LwjglAWTCanvas;

import java.awt.Canvas;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;

import javax.swing.*;

public class LibGdGridZoomOKI extends ApplicationAdapter {
    static Canvas lastcanvass=null;
    static int lastwidth,lasthight;
    static float lastzoom= 1.0f; 
    static Vector3 lastcameraposition = new Vector3();
    private ShapeRenderer shapeRenderer;
    private OrthographicCamera camera;
    private final Vector3 tmp = new Vector3();
    private final Vector3 tmp2 = new Vector3();

    // Circles
    private float circle1X = 200, circle1Y = 200, radius1 = 50;
    private float circle2X = 500, circle2Y = 300, radius2 = 70;

    // Drag state
    private boolean draggingCircle = false;
    private int selectedCircle = -1; 
    private float dragOffsetX = 0f, dragOffsetY = 0f;

    // Camera pan state
    private boolean panning = false;
    private int lastPanX, lastPanY;

    // Grid settings
    private float gridSize = 20f; // change for finer/coarser snapping
    private boolean snapEnabled = true;

    private boolean cameraInitialized = false;
    
    // UI
    private SpriteBatch batch;
    private BitmapFont font;
    private SpriteBatch batch2;
    
    private Stage stage;
    ScreenViewport screenviewport ;
    // Memory monitor
    private static final Runtime runtime = Runtime.getRuntime();
    
//    @Override
    public void resize(int width, int height) {
        // This is called after the canvas has proper size, even on first show
        if (!cameraInitialized) {
            camera = new OrthographicCamera(width, height);
            camera.setToOrtho(false);
            camera.update();
            cameraInitialized = true;
            screenviewport =new ScreenViewport(camera) {
            	@Override
            	public void update(int screenWidth, int screenHeight, boolean centerCamera) {
            		// TODO Auto-generated method stub
//            		super.update(screenWidth, screenHeight, centerCamera);
                    setScreenBounds(0, 0, screenWidth, screenHeight);

            	}
            };
            screenviewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            stage.setViewport(screenviewport);
//            stage.act();
        } else {
            // Optional: handle dynamic resize if needed (e.g. window resize)
            camera.viewportWidth = width;
            camera.viewportHeight = height;
            camera.update();
            screenviewport.update(width, height);
        }
        camera.zoom=lastzoom;
        camera.position.set(lastcameraposition);

    }
    
    @Override
    public void create() {
        shapeRenderer = new ShapeRenderer();
        if(camera==null) {
            camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            camera.setToOrtho(false);
            camera.update();
            screenviewport =new ScreenViewport(camera) {
            	@Override
            	public void update(int screenWidth, int screenHeight, boolean centerCamera) {
            		// TODO Auto-generated method stub
            		//super.update(screenWidth, screenHeight, centerCamera);
            		  // Set screen bounds so isInsideViewport() works correctly
                    setScreenBounds(0, 0, screenWidth, screenHeight);
            	}
            };
            screenviewport.update(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
          
 
        }
        if(stage==null) {
        	  //Initialize stage with screen viewport
            stage = new Stage(screenviewport);
        }
        
        // Set input processor to handle stage input
//        Gdx.input.setInputProcessor(stage);
        
        
        batch = new SpriteBatch();
        font = new BitmapFont(); // default font
        batch2 = new SpriteBatch();

	
     
//		stage.addActor(actor);
        Gdx.input.setInputProcessor(new InputAdapter() {
            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                if (button == Input.Buttons.LEFT) {
                    // Left button → try to grab circle
                    tmp.set(screenX, Gdx.graphics.getHeight() - screenY, 0);
                    camera.unproject(tmp);
                    float worldX = tmp.x;
                    float worldY = tmp.y;

                    if (isInsideCircle(worldX, worldY, circle1X, circle1Y, radius1)) {
                        selectedCircle = 1;
                        draggingCircle = true;
                        dragOffsetX = worldX - circle1X;
                        dragOffsetY = worldY - circle1Y;
                    } else if (isInsideCircle(worldX, worldY, circle2X, circle2Y, radius2)) {
                        selectedCircle = 2;
                        draggingCircle = true;
                        dragOffsetX = worldX - circle2X;
                        dragOffsetY = worldY - circle2Y;
                    }
                } else if (button == Input.Buttons.RIGHT) {
                    // Right button → start panning
                    panning = true;
                    lastPanX = screenX;
                    lastPanY = screenY;
                }
                return true;
            }

            @Override
            public boolean touchDragged(int screenX, int screenY, int pointer) {
                if (draggingCircle) {
                    tmp.set(screenX, Gdx.graphics.getHeight() - screenY, 0);
                    camera.unproject(tmp);
                    float worldX = tmp.x;
                    float worldY = tmp.y;

                    if (selectedCircle == 1) {
                        circle1X = snap(worldX - dragOffsetX);
                        circle1Y = snap(worldY - dragOffsetY);
                    } else if (selectedCircle == 2) {
                        circle2X = snap(worldX - dragOffsetX);
                        circle2Y = snap(worldY - dragOffsetY);
                    }
                } else if (panning) {
                    int dx = screenX - lastPanX;
                    int dy = screenY - lastPanY;

                    // Move camera opposite to drag
                    float newX = camera.position.x - dx * camera.zoom;
                    float newY = camera.position.y + dy * camera.zoom;

                    camera.position.set(snap(newX), snap(newY), 0);
                    camera.update();
                    lastcameraposition = camera.position.cpy();
                    lastPanX = screenX;
                    lastPanY = screenY;
                }
                return true;
            }

            @Override
            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                if (button == Input.Buttons.LEFT) {
                    draggingCircle = false;
                    selectedCircle = -1;
                } else if (button == Input.Buttons.RIGHT) {
                    panning = false;
                }
                return true;
            }

            @Override
            public boolean scrolled(int amount) {
                final float zoomFactor = 1.1f;

                int mx = Gdx.input.getX();
                int my = Gdx.input.getY();

                // World coords under mouse BEFORE zoom
                tmp.set(mx, Gdx.graphics.getHeight() - my, 0);
                camera.unproject(tmp);
                float beforeX = tmp.x;
                float beforeY = tmp.y;

                // Apply zoom
                if (amount > 0) {
                    camera.zoom *= zoomFactor; // zoom out
                } else if (amount < 0) {
                    camera.zoom /= zoomFactor; // zoom in
                }
                camera.zoom = MathUtils.clamp(camera.zoom, 0.005f, 200f);
                camera.update();
                lastzoom =camera.zoom;
                // World coords under mouse AFTER zoom
                tmp2.set(mx, Gdx.graphics.getHeight() - my, 0);
                camera.unproject(tmp2);

                // Adjust camera so mouse focus stays fixed
                camera.position.add(beforeX - tmp2.x, beforeY - tmp2.y, 0);
                camera.update();
                lastcameraposition = camera.position.cpy();
                return true;
            }
        });
        
        
        
        // Create custom rectangle actor
        RectangleActor rect = new RectangleActor(100, 100, 200, 150, Color.BLUE,shapeRenderer);
        rect.setPosition(50, 100); // Set position on screen
        stage.addActor(rect);
        
        // Add another rectangle for demonstration
        RectangleActor rect2 = new RectangleActor(50, 50, 100, 100, Color.RED,shapeRenderer);
        rect2.setPosition(300, 200);
        stage.addActor(rect2);
        
        
        
    }

    private boolean isInsideCircle(float px, float py, float cx, float cy, float r) {
        float dx = px - cx;
        float dy = py - cy;
        return dx * dx + dy * dy <= r * r;
    }

    private float snap(float value) {
        if (!snapEnabled) return value;
        return Math.round(value / gridSize) * gridSize;
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.3f, 1);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

        camera.update();
        shapeRenderer.setProjectionMatrix(camera.combined);

        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);

        // Circle 1: red
        shapeRenderer.setColor(1, 0, 0, 1);
        shapeRenderer.circle(circle1X, circle1Y, radius1);

        // Circle 2: green
        shapeRenderer.setColor(0, 1, 0, 1);
        shapeRenderer.circle(circle2X, circle2Y, radius2);

        shapeRenderer.end();

        // Draw grid
        drawGrid();
        
//        batch.setProjectionMatrix(camera.combined);
        batch.begin();
        int mx = Gdx.input.getX();
        int my = Gdx.input.getY();
        tmp.set(mx, Gdx.graphics.getHeight() - my, 0);
        camera.unproject(tmp);

        // snap coordinates for the hint
        float snappedX = snap(tmp.x);
        float snappedY = snap(tmp.y);

        String coords = String.format("X: %.2f  Y: %.2f w:%d h:%d", snappedX, snappedY,Gdx.graphics.getWidth(),Gdx.graphics.getHeight());
        font.draw(batch, coords, 10, 20); // bottom-left


        
        batch.end();
        

        batch2.begin();
        font.draw(batch2, getMemoryUsageString(), Gdx.graphics.getWidth()-150, 20); // bottom-left
        batch2.end();
        
        
        
        // Update stage (handles input, actions, etc.)
        stage.act(Gdx.graphics.getDeltaTime());
        
        // Draw stage
        stage.draw();
        
        
    }

    private String getMemoryUsageString() {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        float usedMB = usedMemory / (1024f * 1024f);
        float maxMB = maxMemory / (1024f * 1024f);
        return String.format("Mem: %.1f / %.0f MB", usedMB, maxMB);
    }
    private void drawGrid() {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(0.3f, 0.3f, 0.3f, 1);

        float left = camera.position.x - camera.viewportWidth * camera.zoom / 2f;
        float right = camera.position.x + camera.viewportWidth * camera.zoom / 2f;
        float bottom = camera.position.y - camera.viewportHeight * camera.zoom / 2f;
        float top = camera.position.y + camera.viewportHeight * camera.zoom / 2f;

        // Vertical lines
        for (float x = snap(left); x <= right; x += gridSize) {
            shapeRenderer.line(x, bottom, x, top);
        }
        // Horizontal lines
        for (float y = snap(bottom); y <= top; y += gridSize) {
            shapeRenderer.line(left, y, right, y);
        }

        shapeRenderer.end();
    }

    @Override
    public void dispose() {
        shapeRenderer.dispose();
        batch.dispose();
        font.dispose();
//        stage.dispose();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("LibGDX + JFrame Drag + Zoom + Pan + Snap Grid");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setSize(800, 600);
      
//            LwjglAWTCanvas canvas = new LwjglAWTCanvas(new LibGdxJFrameSnapGridExample3());
//            frame.add(canvas.getCanvas());

	          frame.addComponentListener(new ComponentAdapter() {
	          @Override
	          public void componentResized(ComponentEvent e) {
	        	  if(lasthight!=frame.getContentPane().getHeight()||lastwidth!=frame.getContentPane().getWidth()) {
	        		  lastwidth=frame.getContentPane().getWidth();
	        		  lasthight=frame.getContentPane().getHeight();
		        	  if(lastcanvass!=null ) {
		        		  frame.remove(lastcanvass);
		        	  }
		        	
		              LwjglAWTCanvas canvas = new LwjglAWTCanvas(new LibGdGridZoomOKI());
		              lastcanvass =canvas.getCanvas();
		              frame.add(lastcanvass);
		              frame.validate();
	        	  }


	          }
	      });
            frame.setVisible(true);
        });
    }
}


// Custom Actor class for drawing rectangles
 class RectangleActor extends Actor {
    private float width, height;
    private Color color;
    private ShapeRenderer shapeRenderer;

    public RectangleActor(float width, float height, Color color,ShapeRenderer shapeRenderer ) {
        this.width = width;
        this.height = height;
        this.color = color;
        this.shapeRenderer = shapeRenderer;
        
        // Set size for hit detection and layout
        setSize(width, height);
    }

    public RectangleActor(float x, float y, float width, float height, Color color,ShapeRenderer shapeRenderer ) {
        this(width, height, color,shapeRenderer );
        setPosition(x, y);
    }

    @Override
    public void draw(com.badlogic.gdx.graphics.g2d.Batch batch, float parentAlpha) {
        // Actors are drawn with SpriteBatch by default, but we need ShapeRenderer
        // End SpriteBatch before using ShapeRenderer
        batch.end();
        
        // Set color with parent alpha
        Color c = getColor();
        shapeRenderer.setColor(c.r, c.g, c.b, c.a * parentAlpha);
        
        // Begin shape rendering
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.rect(getX(), getY(), getWidth(), getHeight());
        shapeRenderer.end();
        
        // Resume SpriteBatch
        batch.begin();
    }


}