package gdxapp.object3d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;

import org.eclipse.e4.core.internal.services.about.UserPreferences;
import org.eclipse.emf.common.util.EList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.math.Vector3;

import dressing.config.UserPreference;
import dressing.config.WorkspaceConfiguration;
import dressing.mathutils.Vector4;
import dressing.model.Cavity;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.ProjectManager;
import dressing.model.Space3D;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import dressing.model.types.CaissonType;
import dressing.model.types.Orientation;
import dressing.model.types.PieceType;
import dressing.model.types.PoigneePosition;
import dressing.model.types.PoigneeType;
import dressing.model.types.PortType;
import dressing.model.types.PositionReferenceType;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;
import param.DesignClasse;
import param.MechanicDesign;
import param.MechanicDesignGroup;

public class WorldObjectFactory {
	
	public static final int model=0;
	public static final int Bas=1;
	public static final int colonne=2;
	public static final int haut=3;
	public static HashMap<MechanicDesignGroup, ArrayList<WorldObject>> mechanicDesignGroups = new HashMap<MechanicDesignGroup, ArrayList<WorldObject>>();
	
	private static WorldObjectFactory factory;
	
	private WorldObjectFactory() {}
		
	public  ModeledObject createObjectFromModel(ObjectModel objectModel) throws IOException {
		ModeledObject wObject = new ModeledObject();
		wObject.setType(ObjectType.MODELED);
		wObject.setName(objectModel.getInfo().getName());
		wObject.setModel(objectModel);
		ModelInfo info = objectModel.getInfo();
		wObject.setRealWorldDimension(new Vector4(info.getWidth(),info.getHeight(),info.getDepth(),0));
		wObject.setRealWorldPosition(info.getTranslation());
		wObject.setProperties(info.getProperties());
		wObject.setStaticobject( Boolean.valueOf((String) wObject.getProperties().getOrDefault("isStatic", "false")));
		wObject.setUuid(objectModel.getInfo().getUuid());
		if(info.getProperties() != null)
			wObject.setConstraint(Boolean.valueOf(info.getProperties().getProperty("constraint","false")));
		return wObject;
	}
	
	public static WorldObject create(Object3D object3d) {
		WorldObject worldObject = new WorldObject();
		worldObject.setRealWorldPosition(object3d.getPosition());
		worldObject.setRealWorldDimension(object3d.getDimension());
		worldObject.setType(ObjectType.MODELED);
		ModelInfo info = new ModelInfo();
		info.setToDefault();
		ObjectModel objectModel = new ObjectModel(object3d.model, null);
		worldObject.setModel(objectModel);
		return worldObject;
	}
	
	
	public WorldObject loadObjectFromDefinition(KitchenElement wObject ,DesignObject3D design) {
		wObject.setType(ObjectType.DEFINED);
		wObject.setName(design.getName());
		wObject.setDesignObject(design);
		wObject.setUuid(design.getID());
		if (wObject.getRealWorldDimension() == null) {
			Vector4 dimension = new Vector4((float) design.getLongeurext() / 1000f,
					(float) design.getHauteurext() / 1000f, (float) design.getProfondeurext() / 1000f, 0);

			String caissonType = design.getDesignCaissonType();
			CaissonType positionType = design.getPositionType();
			if (caissonType != null && !caissonType.isEmpty() && positionType != null) {

				switch (caissonType) {
				case "BAS_COINS_L":
				case "HAUT_COINS_L":
					if (positionType.equals(CaissonType.EXTREME_GAUCHE)) {
						wObject.setRotation(90f);
					}

					break;
				}
			}
			if (containsFacade(design) && caissonType != null && !caissonType.isEmpty()
					&& !caissonType.contentEquals("FAUSSE_FACADE") && !caissonType.contentEquals("HAUT_COINS")
					&& !caissonType.contentEquals("BAS_COINS") && !caissonType.contentEquals("COINS_SOUS_EVIER") && !caissonType.contentEquals("COLONNE_ETAGERE_COINS")) {
				dimension.z += 0.018f;
			}
			if (caissonType.contentEquals("BAS_COINS") || caissonType.contentEquals("HAUT_COINS")
					|| caissonType.contentEquals("COINS_SOUS_EVIER")||caissonType.contentEquals("COLONNE_ETAGERE_COINS")) {
				Object retour=design.get("facade.retourL");
				if(retour !=null && retour instanceof String)
				{
					dimension.z+=Float.valueOf((String)retour)/1000.0f;
				}
			}
			
			wObject.setRealWorldDimension(dimension);
		}
		if(wObject.getRealWorldPosition()==null) {
			
			float designY=design.getDesignAltitude();
			PositionReferenceType altitudeReference = design.getDesignAltitudeReference();
			if(designY!=0) {
				designY=designY/1000f;
			}
			if(altitudeReference.equals(PositionReferenceType.HAUT)) {
				designY=ProjectManager.getManager().getCurrentScene().getPreferences().getWallHeight()/1000f-designY-wObject.getRealWorldDimension().y;
			}
			Vector3 pos=new Vector3(0, designY+wObject.getRealWorldDimension().y/2, 0);
			
			
			wObject.setRealWorldPosition(pos);
		}
		PropertyChangeListener listener=new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent arg0) {
				updateKitchenElement(design, wObject);
			}
		};
		design.addPropertyChangeListener("element.modify",listener );
		wObject.addPropertyChangeListener("dimension", listener);
		if(wObject.getProperties()==null || (wObject.getProperties()!=null && wObject.getProperties().isEmpty())
				||(wObject.getProperties()!=null && (!wObject.getProperties().containsKey("front-texture")||wObject.getProperties().get("front-texture")==null)
				||(!wObject.getProperties().containsKey("top-texture")||wObject.getProperties().get("top-texture")==null))) {
			fixtextures(design, wObject);
		}
		return wObject;
	}
	
	public  KitchenElement createObjectFromDefinition(DesignObject3D design) {
		KitchenElement wObject = new KitchenElement();
		wObject.setType(ObjectType.DEFINED);
		wObject.setName(design.getName());
		wObject.setDesignObject(design);
		wObject.setUuid(design.getID());
		Vector4 dimension = new Vector4((float)design.getLongeurext()/1000f, (float)design.getHauteurext()/1000f,
					(float)design.getProfondeurext()/1000f,0);
		String caissonType=design.getDesignCaissonType();
		design.getPoigneeType();
		CaissonType positionType=design.getPositionType();
		design.getPorteType();
		getDesignFamily(wObject);
		if(caissonType!=null && !caissonType.isEmpty()
				&&positionType!=null ) {
			switch (caissonType) {
			case "BAS_COINS_L":
			case "HAUT_COINS_L":
				if(positionType.equals(CaissonType.EXTREME_GAUCHE)) {
					wObject.setRotation(90f);
				}
				break;
			}
		}

		if(caissonType.contentEquals("BAS_COINS")|| caissonType.contentEquals("HAUT_COINS")|| caissonType.contentEquals("COINS_SOUS_EVIER")||caissonType.contentEquals("COLONNE_ETAGERE_COINS") ) {
			Object retour=design.get("facade.retourL");
			if(retour !=null && retour instanceof String)
			{
				dimension.z+=Float.valueOf((String)retour)/1000f;
			}
		}
	
		wObject.setRealWorldDimension(dimension);
		wObject.setUuid(design.getID());

		PropertyChangeListener listener=new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent arg0) {
				updateKitchenElement(design, wObject);
			}
		};
		design.addPropertyChangeListener("element.modify",listener );
		wObject.addPropertyChangeListener("dimension", listener);

		float designY = design.getDesignAltitude()/1000.0f;
		PositionReferenceType altitudeReference = design.getDesignAltitudeReference();
		float kitchenAltitude = 2.5f;
		if (ProjectManager.getManager().getCurrentScene() != null) {
			kitchenAltitude = ProjectManager.getManager().getCurrentScene().getPreferences()
					.getWallHeight();
		}
		if (altitudeReference.equals(PositionReferenceType.HAUT)) {
			designY = kitchenAltitude - designY - wObject.getRealWorldDimension().y;
		}
		
		Vector3 pos=new Vector3(0, designY+dimension.y/2, 0);
		wObject.setRealWorldPosition(pos);
		addHandlers(wObject);
		
		fixtextures(design, wObject);
		return wObject;
	}
	private void addHandlers(KitchenElement wObject) {
		var handlerType = wObject.getDesignObject().getPoigneeType();
		if(handlerType == PoigneeType.SANS_POIGNEE) {
			GolaProfile profile = new GolaProfile();
			profile.setMaterial(ModelProvider.findMaterial(CATEGORY.KNOBS, "Dore"));
			wObject.setProfile(profile);
		}else {
			var handleModel = UserPreference.getPreference().getScenePreferences().getDoorHandle();
			List<Piece2D> facades =  wObject.getDesignObject().getListPieces().stream().filter( piece -> piece.getPiecetype().isFacade()).toList();
			facades.forEach( facade -> wObject.putDoorHandle(facade.getName(), handleModel.cpy()));
			DefaultHandlePositioner.getPositioner().calculateRelativeProperties(wObject);
		}
		
	}

	public  KitchenElement createObjectFromDefinition(DesignObject3D design, boolean createRenderingModel) {
		KitchenElement element = createObjectFromDefinition(design);
		if(createRenderingModel)
			createDesignModelSynch(element);
		return element;
	}
	
	//create the design model for the element and blocks the thread untill it s done
	public void createDesignModelSynch(KitchenElement element) {
		CountDownLatch latch = new CountDownLatch(1);
		Gdx.app.postRunnable(() -> {
				try {
					Model model = DesignModelFactory.getFactory().createModelFromVertices(element);
					ModelInfo modelInfo = new ModelInfo();
					modelInfo.setToDefault();
					ObjectModel objModel = new ObjectModel(model, modelInfo);
					element.setModel(objModel);
				}finally {
					latch.countDown();
				}
			});
		try {
			latch.await();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	
		
	public void updateKitchenElement(DesignObject3D design , KitchenElement wObject) {
		Vector4 dimension = new Vector4((float)design.getLongeurext()/1000f, (float)design.getHauteurext()/1000f,
				(float)design.getProfondeurext()/1000f,0);
		String caissonType= design.getDesignCaissonType();

		if(caissonType.contentEquals("BAS_COINS")|| caissonType.contentEquals("HAUT_COINS") || caissonType.contentEquals("COINS_SOUS_EVIER")||caissonType.contentEquals("COLONNE_ETAGERE_COINS")) {
			Object retour=design.get("facade.retourL");
			if(retour !=null && retour instanceof String)
			{
				dimension.z+=Float.valueOf((String)retour)/1000f;
			}
		}		
		wObject.setRealWorldDimension(dimension);
		fixtextures(design, wObject);
		wObject.setRequireRefrech(true);
	}
	
	
	public static boolean containsFacade(DesignObject3D design) {
		String caissonType=design.getDesignCaissonType();
		if(caissonType!=null && !caissonType.isEmpty()) {
			switch (caissonType) {
			
			case "HAUT_COINS_L":
			case "BAS_COINS_L":
				return false;
			case "BLOCK_TIROIR":
				return true;
			}	
			for(Piece2D piece:design.getListPieces()) {
				PieceType type=piece.getPiecetype();
				switch (type) {
				case PORTE:
				case PORTE_BAS:
				case PORTE_HAUT:
				case PORTE_DROITE:
				case PORTE_GAUCHE:
				case FACADE:
					return true;
				}
			}
			
		}
		return false;
	}
	
	
	public static int getDesignFamily(KitchenElement wObject) {
		if(wObject.getType().equals(ObjectType.DEFINED)) {
			DesignObject3D design=wObject.getDesignObject();
			return getDesignFamily(design);
		}
		return WorldObjectFactory.model;
	}
	
	public static int getDesignFamily(DesignObject3D design) {
		String caissonType=design.getDesignCaissonType();

		if(caissonType!=null && !caissonType.isEmpty()) {
			
			switch (caissonType) {
		
			case "HAUT_COINS_L":
			case "HAUT_COINS":
			case "HAUT_COINS_ANGLE":
			case "HAUT":
			case "HAUT_NICHE_V":
			case "HAUT_NICHE_H":
				return WorldObjectFactory.haut;
			case "COLONNE_ETAGERE":
			case "COLONNE_ETAGERE_COINS":
			case "COLONNE_FOUR":
			case "COLONNE_FOUR_MICROONDE":
			case "COLONNE_FRIGO":
			case "COLONNE":
			case "COLONNE_MICROONDE":			
				return WorldObjectFactory.colonne;
			case "BAS_COINS_L":
			case "BAS_COINS":
			case "COINS_SOUS_EVIER":
			case "BAS_COINS_ANGLE":
			case "SOUS_EVIER":
			case "BLOCK_TIROIR":
			case "PORTE_BOTEILLE":
			case "BAS_FOUR":
			case "BAS":
			case "BAS_NICHE_V":
			case "BAS_NICHE_H":
				return WorldObjectFactory.Bas;
			default:
				if(design.getName().contains("Haut")) {
					return WorldObjectFactory.haut;
				}
				return WorldObjectFactory.Bas;
			}
		}
		return WorldObjectFactory.model;

	}

	public static void fixtextures(DesignObject3D design ,WorldObject wObject) {
		String caissonType=design.getDesignCaissonType();
		PoigneeType poigneetype=design.getPoigneeType();
		CaissonType positionType=design.getPositionType();
		PoigneePosition poigneePosition = design.getPoigneePosition();
		Orientation poigneeOrientation=design.getPoigneeOrientation();
		PortType porteType = null;
		try {
			porteType = design.getPorteType();
		}catch(Exception e) {
			porteType = PortType.FRANCAISE;
		}
		 
		String topTexture="element bas top view";
		String frontTexture="2port element top horizontale poignee";
		if(caissonType!=null && !caissonType.isEmpty()) {
			
			switch (caissonType) {
			case "BAS_COINS_L":
				topTexture="dark gray111";
				frontTexture = getBasCoinsLFrontTexture(poigneePosition, poigneeOrientation, positionType);
				
				break;
			case "HAUT_COINS_L":
				topTexture="light gray";
				frontTexture=getHautCoinsLFrontTexture(poigneePosition, poigneeOrientation, positionType);
				
				break;
			case "COINS_SOUS_EVIER":
			case "BAS_COINS":
				topTexture="element bas top view";
				frontTexture= getBasCoinsSimpleFrontTexture(poigneetype, poigneePosition, poigneeOrientation, positionType);
				
				break;

			case "COLONNE_ETAGERE_COINS":
				topTexture="element colonne top view";
				frontTexture=getColonneEtagereFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, positionType, porteType);
				
				break;
			case "HAUT_COINS":				
				topTexture="element haut top view";
				frontTexture=getHautCoinsSimpleFrontTexture(poigneetype, poigneePosition, poigneeOrientation, positionType);			
				break;
			case "BAS_FOUR":
				topTexture="Bas Four Top View";
				frontTexture="element bas four";
				break;
			case "HAUT_NICHE_V":
				topTexture="element haut top view";
				frontTexture="element niche V";
				break;	
			case "HAUT_NICHE_H":
				topTexture="element haut top view";
				frontTexture="element niche H";
				break;
			case "BAS_NICHE_V":
				topTexture="element bas top view";
				frontTexture="element niche V";
				break;	
			case "BAS_NICHE_H":
				topTexture="element bas top view";
				frontTexture="element niche H";
				break;	
			case "HAUT":
				topTexture="element haut top view";
				frontTexture=getHautFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, porteType);
				
				break;
			case "COLONNE_ETAGERE":
				topTexture="element colonne top view";
				frontTexture=getColonneEtagereFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, positionType, porteType);

				break;
			case "COLONNE_FOUR":
				topTexture="element colonne top view";
				frontTexture=getColonneFourFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, positionType, porteType);
				break;
			case "COLONNE_MICROONDE":
				topTexture="element colonne top view";
				frontTexture=getColonneFourFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, positionType, porteType);
				break;
			case "COLONNE_FOUR_MICROONDE":
				topTexture="element colonne top view";
				frontTexture=getColonneFourMicroondeFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, positionType, porteType);
				
				break;
			case "COLONNE_FRIGO":
				topTexture="element colonne top view";
				frontTexture=getColonneFrigoFrontTexture(design, poigneetype, poigneePosition, poigneeOrientation, positionType, porteType);
				break;

			case "BLOCK_TIROIR":
				topTexture="element bas porte pain top view";
				frontTexture=getBlockTiroirFrontTexture(design, poigneetype, poigneePosition);
				
				break;
				
			case "PORTE_BOTEILLE":
				topTexture="element bas porte pain top view";
				frontTexture=getBasFrainsaiseFrontTexteure(poigneetype, poigneePosition, poigneeOrientation);
				
				break;
			case "SOUS_EVIER":
			case "BAS":
				topTexture="element bas top view";
				frontTexture="2port element top horizontale poignee";
				if(porteType.equals(PortType.FRANCAISE)&& design.getLongeurext()<= 600) {
					frontTexture = getBasFrainsaiseFrontTexteure(poigneetype, poigneePosition, poigneeOrientation);
				}else {
					frontTexture = getBasFrainsaise2VFrontTexteure(poigneetype, poigneePosition, poigneeOrientation);
				}
			break;
			
			default:
				topTexture="1port element haut sans poignee";
				frontTexture="1port element haut sans poignee";
				break;
			}
		}
		String frontPath = WorkspaceConfiguration.TEXTURES2D_FOLDER + File.separator + frontTexture + ".png";
		String topPath = WorkspaceConfiguration.TEXTURES2D_FOLDER + File.separator + topTexture + ".png";

		wObject.getProperties().put("front-texture", frontPath);
		wObject.getProperties().put("top-texture", topPath);
	}
	
	private static String getBasFrainsaiseFrontTexteure( PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="1port top right poignee horizontale";
		if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="1port bas sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
					texture="1port bottom left poignee verticale ";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port bottom left poignee horizontale";	
					}
					break;
				case BOTTOM_MIDDLE:
					texture="1port bottom center poignee horizontale";

					break;
				case BOTTOM_RIGHT:
					texture="1port bottom right poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port bottom right poignee horizontale";	
					}

					break;
				case LEFT_MIDDLE:
					texture="1port middle left poignee verticale";

					break;
				case RIGHT_MIDDLE:
					texture="1port middle right poignee verticale";

					break;
				case TOP_LEFT:
					texture="1port top left poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port top left poignee horizontale";	
					}
					break;
				case TOP_MIDDLE:
					texture="1port top center poignee horizontale";

					break;
				case TOP_RIGHT:
					texture="1port top right poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port top right poignee horizontale";	
					}
					break;
				case CENTER:
					texture="1port middle poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port middle poignee horizontale";
					}
					break;
				}
			}
		}
		return texture;
		
	}
	private static String getBasFrainsaise2VFrontTexteure( PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="2port element top horizontale poignee";
		if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="2port element bas sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
				case BOTTOM_RIGHT:
					texture="2port bottom left verticale poignee";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="2port bottom horizontale poignee";	
					}
					break;
				case BOTTOM_MIDDLE:
					texture="2port bottom middle horizontale poignee";

					break;
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture="2port middle left verticale poignee";

					break;
				case TOP_RIGHT:
				case TOP_LEFT:
					texture="2port top left verticale poignee";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="2port top horizontale poignee";	
					}
					break;
				case TOP_MIDDLE:
					texture="2port top middle horizontale poignee";

					break;
				
				case CENTER:
					texture="2port middle verticale poignee";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="2port middle horizontale poignee";
					}
					break;
				}
			}
		}
		return texture;
		
	}
	private static String getHautFrainsaiseFrontTexteure(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="1port bottom right poignee horizontale";
		if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="1port element haut sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
					texture="1port bottom left poignee verticale ";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port bottom left poignee horizontale";	
					}
					break;
				case BOTTOM_MIDDLE:
					texture="1port bottom center poignee horizontale";

					break;
				case BOTTOM_RIGHT:
					texture="1port bottom right poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port bottom right poignee horizontale";	
					}

					break;
				case LEFT_MIDDLE:
					texture="1port middle left poignee verticale";

					break;
				case RIGHT_MIDDLE:
					texture="1port middle right poignee verticale";

					break;
				case TOP_LEFT:
					texture="1port top left poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port top left poignee horizontale";	
					}
					break;
				case TOP_MIDDLE:
					texture="1port top center poignee horizontale";

					break;
				case TOP_RIGHT:
					texture="1port top right poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port top right poignee horizontale";	
					}
					break;
				case CENTER:
					texture="1port middle poignee verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="1port middle poignee horizontale";
					}
					break;
				}
			}
		}
		return texture;
		
	}
	private static String gethautFrainsaise2VFrontTexteure(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="";
		texture="2port bottom left verticale poignee";
		if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="2port element haut sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
				case BOTTOM_RIGHT:
					texture="2port bottom left verticale poignee";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="2port bottom horizontale poignee";	
					}
					break;
				case BOTTOM_MIDDLE:
					texture="2port bottom middle horizontale poignee";

					break;
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture="2port middle left verticale poignee";

					break;
				case TOP_RIGHT:
				case TOP_LEFT:
					texture="2port top left verticale poignee";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="2port top horizontale poignee";	
					}
					break;
				case TOP_MIDDLE:
					texture="2port top middle horizontale poignee";

					break;
				
				case CENTER:
					texture="2port middle verticale poignee";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="2port middle horizontale poignee";
					}
					break;
				}
			}
		}
		return texture;
		
	}

	private static String getHautCoinsSimpleFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType) {
		String texture="coins simple haut gauche poignee horizontale";
		switch (positionType) {
		case MILIEU:
		case MONO_CAISSON:
		case EXTREME_DROITE:
			texture="coins simple droite poignee bottom left horizontale";
			if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture="coins simple droite haut sans poignee";
			}else {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case TOP_RIGHT:
					case TOP_LEFT:
						texture="coins simple droite poignee bottom left verticale";
						if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
							texture="coins simple droite poignee bottom left horizontale";	
						}
						break;
					case BOTTOM_MIDDLE:
					case TOP_MIDDLE:

						texture="coins simple droite poignee bottom middle horizontale";

						break;
					case CENTER:
					case LEFT_MIDDLE:
					case RIGHT_MIDDLE:
						texture="coins simple droite poignee left middle verticale";

						break;
					default:
						break;

					
					}
				}
			}
			break;
		case EXTREME_GAUCHE:
			texture="coins simple gauche poignee bottom right horizontale";
			if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture="coins simple gauche haut sans poignee";
			}else {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case TOP_RIGHT:
					case TOP_LEFT:
						texture="coins simple gauche poignee bottom right verticale";
						if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
							texture="coins simple gauche poignee bottom right horizontale";	
						}
						break;
					case BOTTOM_MIDDLE:
					case TOP_MIDDLE:

						texture="coins simple gauche poignee bottom middle horizontale";

						break;
					case LEFT_MIDDLE:
					case RIGHT_MIDDLE:
						texture="coins simple gauche poignee right middle verticale";

						break;
					case CENTER:
						break;
					default:
						break;

					
					}
				}
			}
			break;

		default:
			break;
		}
		return texture;
	}
	private static String getBasCoinsSimpleFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType) {
		String texture="coins simple droite bas sans poignee";
		switch (positionType) {
		case MILIEU:
		case MONO_CAISSON:
		case EXTREME_DROITE:
			texture = "coins simple droite bas sans poignee";
			if(!poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case TOP_RIGHT:
					case TOP_LEFT:
					case BOTTOM_MIDDLE:
					case TOP_MIDDLE:
						texture = "coins simple droite poignee top left verticale";
						if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
							texture="coins simple droite poignee top left horizontale";	
						}
						break;

					case LEFT_MIDDLE:
					case RIGHT_MIDDLE:
					case CENTER:
						texture = "coins simple droite poignee left middle verticale";
						break;
					default:
						break;
					}
				}
			}
			break;
		case EXTREME_GAUCHE:
			texture="coins simple gauche bas sans poignee";
			if(!poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case TOP_RIGHT:
					case TOP_LEFT:
					case BOTTOM_MIDDLE:
					case TOP_MIDDLE:
						texture = "coins simple gauche poignee top right verticale";
						if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
							texture="coins simple gauche poignee top right horizontale";	
						}
						break;

					case LEFT_MIDDLE:
					case RIGHT_MIDDLE:
					case CENTER:
						texture = "coins simple gauche poignee right middle verticale";
						break;
					default:
						break;
					}
				}
			}
			break;

		default:
			break;
		}
		
		return texture;
	}
	private static String getBasCoinsLFrontTexture(PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType) {
		String texture="coins L droite poignee top left verticale";
		switch (positionType) {
		case MILIEU:
		case MONO_CAISSON:
		case EXTREME_DROITE:
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
				case BOTTOM_RIGHT:
				case TOP_RIGHT:
				case TOP_LEFT:
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="coins L droite poignee top left horizontale";	
					}
					break;
				case BOTTOM_MIDDLE:
				case TOP_MIDDLE:
					texture = "coins L droite poignee top middle horizontale";
					break;
				case CENTER:
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture = "coins L droite poignee left middle verticale";
					break;
				default:
					break;

				}
			}
			break;
		case EXTREME_GAUCHE:
			texture="coins L gauche poignee top right verticale";
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
				case BOTTOM_RIGHT:
				case TOP_RIGHT:
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="coins L gauche poignee top right horizontale";	
					}
				break;
				case TOP_LEFT:
				case BOTTOM_MIDDLE:
				case TOP_MIDDLE:
				case CENTER:
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture = "coins L gauche poignee right middle verticale";
				default:
					break;
				}
			}
			break;

		default:
			break;
		}
		
		return texture;
	}
	private static String getHautCoinsLFrontTexture(PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType) {
		String texture="coins L droite poignee bottom left horizontale";
		switch (positionType) {
		case MILIEU:
		case MONO_CAISSON:
		case EXTREME_DROITE:
			texture="coins L droite poignee bottom left horizontale";
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
				case BOTTOM_RIGHT:
				case TOP_RIGHT:
				case TOP_LEFT:
					texture="coins L droite poignee bottom left verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="coins L droite poignee bottom left horizontale";	
					}
					break;
				case BOTTOM_MIDDLE:
				case TOP_MIDDLE:

					texture="coins L droite poignee bottom middle verticale";

					break;
				case CENTER:
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture="coins L droite poignee left middle verticale";

					break;
				
				default:
					break;

				
				}
			}
			break;
		case EXTREME_GAUCHE:
			texture="coins L gauche poignee bottom right horizontale";
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case BOTTOM_LEFT:
				case BOTTOM_RIGHT:
				case TOP_RIGHT:
				case TOP_LEFT:
					texture="coins L gauche poignee bottom right verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="coins L gauche poignee bottom right horizontale";	
					}
					break;
				case BOTTOM_MIDDLE:
				case TOP_MIDDLE:

					texture="coins L gauche poignee bottom middle horizontale";

					break;
				case CENTER:
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture="coins L gauche poignee right middle verticale";

					break;
				default:
					break;

				
				}
			}
			break;

		default:
			break;
		}
		
		
		
		return texture;
	}	

	private static String getColonneEtagereFrontTexture(DesignObject3D design, PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType,PortType porteType) {
		String texture="colonne etagere 2 porte poignee horizontale left";
		if(porteType.equals(PortType.FRANCAISE)&& design.getLongeurext()<= 600) {
			texture=getColonneEtagereFransaiseFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}else {
			texture=getColonneEtagereFransaise2VFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}
		
		return texture;
	}
	private static String getColonneEtagereFransaiseFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne etagere 1 porte poignee horizontale right";
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne etagere 1 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
					texture="colonne etagere 1 porte poignee verticale left";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne etagere 1 porte poignee horizontale left";	
					}
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne etagere 1 porte poignee horizontale middle";

					break;
				case CENTER:
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne etagere 1 porte poignee verticale right";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne etagere 1 porte poignee horizontale right";	
					}

					break;
				case LEFT_MIDDLE:
					texture="colonne etagere 1 porte poignee left middle horizontale";

					break;
				case RIGHT_MIDDLE:
					texture="colonne etagere 1 porte poignee right middle horizontale";

					break;
				}
			}
		}
		
		
		return texture;
	}
	private static String getColonneEtagereFransaise2VFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne etagere 2 porte poignee horizontale left";
		
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne etagere 2 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne etagere 2 porte poignee verticale left";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne etagere 2 porte poignee horizontale left";	
					}
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne etagere 2 porte poignee horizontale middle";

					break;
				case CENTER:
				case RIGHT_MIDDLE:
				case LEFT_MIDDLE:
					texture="colonne etagere 2 porte poignee right middle verticale";

					break;
				}
			}
		}
		
		
		return texture;
	}

	private static String getColonneFourFrontTexture(DesignObject3D design, PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType,PortType porteType) {
		String texture="colonne four 2 porte poignee horizontale left";
		if(porteType.equals(PortType.FRANCAISE)&& design.getLongeurext()<= 600) {
			texture=getColonneFourFransaiseFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}else {
			texture=getColonneFourFransaise2VFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}
		
		return texture;
	}
	private static String getColonneFourFransaiseFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne four 1 porte poignee horizontale right";
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne four 1 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
					texture="colonne four 1 porte poignee verticale left";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne four 1 porte poignee horizontale left";	
					}
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne four 1 porte poignee horizontale middle";

					break;
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne four 1 porte poignee verticale right";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne four 1 porte poignee horizontale right";	
					}

					break;
				case LEFT_MIDDLE:
					texture="colonne four 1 porte poignee left middle horizontale";

					break;
				case CENTER:
				case RIGHT_MIDDLE:
					texture="colonne four 1 porte poignee right middle horizontale";

					break;
				}
			}
		}
		
		
		return texture;
	}
	private static String getColonneFourFransaise2VFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne four 2 porte poignee horizontale left";
		
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne four 2 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne four 2 porte poignee verticale left";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne four 2 porte poignee horizontale left";	
					}
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne four 2 porte poignee horizontale middle";

					break;
				case CENTER:
				case RIGHT_MIDDLE:
				case LEFT_MIDDLE:
					texture="colonne four 2 porte poignee left middle verticale";

					break;
				}
			}
		}
		
		
		return texture;
	}	
	
	private static String getColonneFourMicroondeFrontTexture(DesignObject3D design, PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType,PortType porteType) {
		String texture="colonne four microonde 2 porte poignee horizontale left";
		if(porteType.equals(PortType.FRANCAISE)&& design.getLongeurext()<= 600) {
			texture=getColonneFourMicroondeFransaiseFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}else {
			texture=getColonneFourMicroondeFransaise2VFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}	
		
		return texture;
	}	
	private static String getColonneFourMicroondeFransaiseFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne four microonde 1 porte poignee horizontale right";
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne four microonde 1 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
					texture="colonne four microonde 1 porte poignee verticale left";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne four microonde 1 porte poignee horizontale left";	
					}
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne four microonde 1 porte poignee horizontale middle";

					break;
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne four microonde 1 porte poignee verticale right";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne four microonde 1 porte poignee horizontale right";	
					}

					break;
				case LEFT_MIDDLE:
					texture="colonne four microonde 1 porte poignee left middle verticale";

					break;
				case CENTER:
				case RIGHT_MIDDLE:
					texture="colonne four microonde 1 porte poignee right middle verticale";

					break;

				}
			}
		}
		
		
		return texture;
	}
	private static String getColonneFourMicroondeFransaise2VFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne four microonde 2 porte poignee horizontale left";
		
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne four microonde 2 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne four microonde 2 porte poignee verticale left";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)) {
						texture="colonne four microonde 2 porte poignee horizontale left";	
					}
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne four microonde 2 porte poignee horizontale middle";

					break;
				case CENTER:
				case RIGHT_MIDDLE:
				case LEFT_MIDDLE:
					texture="colonne four microonde 2 porte poignee left middle verticale";

					break;
				}
			}
		}
		
		
		return texture;
	}

	private static String getColonneFrigoFrontTexture(DesignObject3D design, PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,CaissonType positionType,PortType porteType) {
		String texture="colonne frigo 2 porte";
		if(porteType.equals(PortType.FRANCAISE)&& design.getLongeurext()<= 600) {
			texture=getColonneFrigoFransaiseFrontTexture(poigneetype, poigneePosition);
		}else {
			texture=getColonneFrigoFransaise2VFrontTexture(poigneetype, poigneePosition, poigneeOrientation);
		}	
		
		return texture;
	}
	private static String getColonneFrigoFransaiseFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition) {
		String texture="colonne frigo 1 porte poignee right";
		if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			texture="colonne frigo 1 porte sans poignee";
		}else {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
					texture="colonne frigo 1 porte poignee left verticale";
					break;
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne frigo 1 porte poignee bottom middle horizontale";
					break;
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
					texture="colonne frigo 1 porte poignee left";
					break;
				case LEFT_MIDDLE:
				case CENTER:
					break;

				}
			}
		}
		
		
		return texture;
	}
	private static String getColonneFrigoFransaise2VFrontTexture(PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation) {
		String texture="colonne frigo 2 porte sans poignee";
		if( !poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
			if(poigneePosition!=null) {
				switch (poigneePosition) {
				case TOP_LEFT:
				case BOTTOM_LEFT:
				case TOP_MIDDLE:
				case BOTTOM_MIDDLE:
					texture="colonne frigo 2 porte poignee left verticale";
					if(poigneeOrientation.equals(Orientation.HORIZONTAL)){
						texture = "colonne frigo 2 porte poignee left horizontale";
					}
					break;
				case TOP_RIGHT:
				case BOTTOM_RIGHT:
				case LEFT_MIDDLE:
				case RIGHT_MIDDLE:
					texture = "colonne frigo 1 porte poignee right middle verticale";
					break;
				case CENTER:
					texture = "colonne frigo 2 porte poignee left horizontale";
					break;
				}
			}
		}
		
		
		return texture;
	}

	private static String getHautFrontTexture(DesignObject3D design, PoigneeType poigneetype,PoigneePosition poigneePosition,Orientation poigneeOrientation,PortType porteType) {
		String texture = "2port bottom left verticale poignee";
		
		
		switch (porteType) {
		case FRANCAISE:
			texture = getHautFrainsaiseFrontTexteure(poigneetype, poigneePosition, poigneeOrientation);
			break;
		case FRANCAISE2V:
			texture =gethautFrainsaise2VFrontTexteure(poigneetype, poigneePosition, poigneeOrientation);
			break;
		case BASCULANT:
			texture="1port basculant ";
			if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture="1port element haut sans poignee";
			}
			break;
		case BASCULANT2H:
			texture="2port basculant";
			if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture="2port basculant sans poignee";
			}
			break;
		case BASCULANT2H2P:
			texture="2port element haut basculant 2H";
			if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture="2port basculant sans poignee";
			}
			break;
		default:
			break;
		}
		
		//to adjust front texture in correspondance with the width of the element
		if(design.getLongeurext()>design.getDesignMaxPorteLongeur() && porteType.equals(PortType.FRANCAISE)) {
			texture =gethautFrainsaise2VFrontTexteure(poigneetype, poigneePosition, poigneeOrientation);
		}
		
		return texture;
	}
	private static String getBlockTiroirFrontTexture(DesignObject3D design, PoigneeType poigneetype,PoigneePosition poigneePosition) {
		int nb_Tiroir = design.getNbTiroir();

		
		String texture="block tiroir 2T poignee top horizontale";
		if(nb_Tiroir==3) {
			texture="block tiroir 3T  top horizontale";
			if(poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture="block tiroir 3T sans poignee";
			}else {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case BOTTOM_MIDDLE:
						texture="block tiroir 3T poignee bottom middle horizontale";

						break;
					case LEFT_MIDDLE:	
					case RIGHT_MIDDLE:
					case CENTER:
						texture="block tiroir 3T poignee middle horizontale";
						
						break;
					case TOP_LEFT:
					case TOP_MIDDLE:
					case TOP_RIGHT:
						texture="block tiroir 3T  poignee top horizontale";
						break;
					}
				}
			}
		}else if(nb_Tiroir==2){
			
			if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture = "block tiroir 2T sans poignee";
			}else {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case BOTTOM_MIDDLE:
						texture="block tiroir 2T poignee bottom horizontale";

						break;
					case LEFT_MIDDLE:	
					case RIGHT_MIDDLE:
					case CENTER:
						texture="block tiroir 2T poignee middle horizontale";
						
						break;
					case TOP_LEFT:
					case TOP_MIDDLE:
					case TOP_RIGHT:
						texture="block tiroir 2T poignee top horizontale";
						break;
						
					
					}
				}
			}
		}else {
			if( poigneetype.equals(PoigneeType.SANS_POIGNEE)) {
				texture = "1port bas sans poignee";
			}else {
				if(poigneePosition!=null) {
					switch (poigneePosition) {
					case BOTTOM_LEFT:
					case BOTTOM_RIGHT:
					case BOTTOM_MIDDLE:
						texture="1port basculant ";

						break;
					case LEFT_MIDDLE:	
					case RIGHT_MIDDLE:
					case CENTER:
						texture="1port middle poignee horizontale";
						
						break;
					case TOP_LEFT:
					case TOP_MIDDLE:
					case TOP_RIGHT:
						texture="1port top center poignee horizontale";
						break;
						
					
					}
				}
			}
		}
		
		return texture;	
	}

	public static WorldObjectFactory getFactory() {
		if(factory == null)
			factory = new WorldObjectFactory();
		return factory;
	}
}
