package dressing.ui.project;

import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import dressing.controller.ProjectCreator;
import dressing.model.DesignException;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

public class CreateProjectWizard extends Wizard {

	@Inject
	IEventBroker eventBroker;

	private CreateProjectPage createPage;
	private CreateKitchenPage kitchenPage;
	private ElementConfigPage elementPage;
	private HandleConfigWizardPage handleConfigPage;
	private FloorConfigWizardPage floorPage;
	private WallConfigWizardPage wallPage;
	SuperCadProject project;
	private ProjectCreator creator;
	
	public CreateProjectWizard() {

		setWindowTitle("Nouveau Projet");
		this.creator=ProjectCreator.getInstance();
	}

	@Override
	public boolean performFinish() {
		try {
			SuperCadProject currentProject = ProjectManager.getManager().getCurrentProject();
			if(currentProject!=null) {
				int answer=MessageDialog.open(MessageDialog.QUESTION_WITH_CANCEL, null, "Confirmation", "Vous les vous enregistrer le projet courant",SWT.NONE , "Oui","Non","Annuler");
				if(answer==0)
				{
					ProjectManager.getManager().saveProject(currentProject,false,false);
				}
				if(answer==2)
				{
					return true;
				}
			}
			this.creator.create();
			SuperCadProject project=this.creator.getProjectInstance();
			ProjectManager.getManager().addProject(project);	
			ProjectManager.getManager().setCurrentProject(project, false);	
			
			createPage.clearlistners();
			kitchenPage.clearlistners();
			handleConfigPage.clearlistners();
			floorPage.clearlistners();
			wallPage.clearlistners();
			elementPage.clearlistners();
		} catch (DesignException | GeometricEngineException e) {
			for (IWizardPage page : getPages()) {
				((WizardPage) page).setErrorMessage(e.getMessage());
			}
			return false;
		}
		return true;
	}
	
	@Override
	public void addPages() {

		createPage = new CreateProjectPage(this.creator);
		kitchenPage = new CreateKitchenPage(this.creator);
		elementPage = new ElementConfigPage(this.creator.getPreferences());
		handleConfigPage = new HandleConfigWizardPage("", this.creator.getPreferences());
		floorPage = new FloorConfigWizardPage(this.creator.getPreferences());
		wallPage = new WallConfigWizardPage(this.creator.getPreferences());
		addPage(createPage);
		addPage(kitchenPage);
		addPage(elementPage);
		addPage(handleConfigPage);
		addPage(wallPage);
		addPage(floorPage);


	}
	
	@Override
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
	
}
