package dressing.ui.project;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.controller.ProjectCreator;
import dressing.controller.ProjectCreator.CornerType;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.ui.MaterialListWindow;
import dressing.ui.components.TableComboViewerSearch;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.util.ImageLoaderCache;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.StaticUiObjects;
import param.Material;
import param.MaterialType;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;

import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;

public class CreateKitchenComposite extends Composite{
	
	private DataBindingContext m_bindingContext;
	private PropertyChangeListener listener;
	private Spinner spinner_h;
	private Spinner spinner_w;
	private TableComboViewer tableComboViewer;
	private TableComboViewer tableComboViewer_1;
	private TableComboViewer tableComboVwr_facademat;
	private Object backMaterial;
	private Object primaryMaterial;
	private ProjectCreator creator;
	private Button btnNorthWall;
	private Button btnSouthWall;
	private Button btnWestWall;
	private Button btnEastWall;
	private Composite compositeKitchenDraw;
	private KitchenDraw2D kitchendraw;
	private Spinner spnNorthwestL;
	private Spinner spnNorthEastL;
	private Spinner spnNorthwestH;
	private Spinner spnNorthEastH;
	private Spinner spnSouthWestH;
	private Spinner spnSouthEastH;
	private Spinner spnSouthWestL;
	private Spinner spnSouthEastL;
	private Combo combo;
	private ComboViewer comboViewerNorthEastCorner;
	private Combo combo_1;
	private ComboViewer comboViewerNorthWestCorner;
	private Combo combo_2;
	private ComboViewer comboViewerSouthWestCorner;
	private Combo combo_3;
	private ComboViewer comboViewerSouthEastCorner;
	
	byte edgeSelection = 0;
	float[] cornerParameters = new float[] {0,0,0, 0,0,0, 0,0,0 ,0,0,0};
	private Label lblHauteurDesMurs;
	private Spinner spnWallHeight;
	private Label lblEpaisseurDesMurs;
	private Spinner spnWallThickness;
	private ScenePreferences preferences;
	
	
	public CreateKitchenComposite(Composite parent, int style,ProjectCreator creator) {
		super(parent, style);
		this.creator=creator;
		preferences = this.creator.getPreferences();
		
		getShell().setSize(700, 600);
		getShell().setLocation(getDisplay().getBounds().width/2-350, getDisplay().getBounds().height/2-300);
		setLayout(new GridLayout(2, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		composite.setLayout(new FillLayout(SWT.VERTICAL));
		
		Group grpGroup = new Group(composite, SWT.NONE);
		grpGroup.setText("Dimensions");
		grpGroup.setLayout(new GridLayout(2, false));
		FormData fd_text = new FormData();
		fd_text.right = new FormAttachment(100, -50);
		
		Label lblLongueur = new Label(grpGroup, SWT.NONE);
		lblLongueur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblLongueur.setText("Longeur");
		
		spinner_w = new Spinner(grpGroup, SWT.BORDER);
		spinner_w.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_w.setMaximum(10000);
		spinner_w.setMinimum(1);
		spinner_w.setSelection(Math.round(creator.getKitchenShapeBuilder().getWidth()));
		spinner_w.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				int value =  spinner_w.getSelection();
				creator.getKitchenShapeBuilder().setWidth(value);
				
			}
		});
		
		Label lblLargeur = new Label(grpGroup, SWT.NONE);
		lblLargeur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblLargeur.setText("Largeur");
		
		spinner_h = new Spinner(grpGroup, SWT.BORDER);
		spinner_h.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_h.setMaximum(10000);
		spinner_h.setMinimum(1);
		spinner_h.setSelection(Math.round(creator.getKitchenShapeBuilder().getHeight()));
		spinner_h.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				int value = spinner_h.getSelection();
				creator.getKitchenShapeBuilder().setHeight(value);
			}
		});
		
		lblHauteurDesMurs = new Label(grpGroup, SWT.NONE);
		lblHauteurDesMurs.setText("Hauteur des Murs");
		
		spnWallHeight = new Spinner(grpGroup, SWT.BORDER);
		spnWallHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnWallHeight.setMaximum(10000);
		spnWallHeight.setMinimum(10);
		float wallHeight = preferences.getWallHeight();
		spnWallHeight.setSelection(Math.round(wallHeight * 1000));
		spnWallHeight.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				preferences.setWallHeight(spnWallHeight.getSelection() / 1000.0f);
			}
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				preferences.setWallHeight(spnWallHeight.getSelection() / 1000.0f);				
			}
		});
		lblEpaisseurDesMurs = new Label(grpGroup, SWT.NONE);
		lblEpaisseurDesMurs.setText("Epaisseur des Murs");
		
		
		spnWallThickness = new Spinner(grpGroup, SWT.BORDER);
		spnWallThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		float thickness = preferences.getWallThickness();
		spnWallThickness.setMaximum(10000);
		spnWallThickness.setMinimum(10);
		spnWallThickness.setSelection(Math.round(thickness * 1000));
		spnWallThickness.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				preferences.setWallThickness(spnWallThickness.getSelection() / 1000.0f);
			}
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				preferences.setWallThickness(spnWallThickness.getSelection() / 1000.0f);				
			}
		});
		
		Composite composite_1 = new Composite(this, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		composite_1.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Group grpGroup_1 = new Group(composite_1, SWT.NONE);
		grpGroup_1.setText("Modèle(Materiaux MDF du Coupe)");
		grpGroup_1.setLayout(new GridLayout(3, false));
		List<Material> materials = ResourceManagers.getIntance().getMaterials();
		//
		Label lblMateriauface = new Label(grpGroup_1, SWT.NONE);
		lblMateriauface.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMateriauface.setText("Façade");
		
		tableComboVwr_facademat = new TableComboViewerSearch(grpGroup_1, SWT.NONE);
		TableCombo tableCombo_matface = tableComboVwr_facademat.getTableCombo();
		tableCombo_matface.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_matface.defineColumns(StaticUiObjects.MaterialColumns);
		tableCombo_matface.setEditable(true);
		tableCombo_matface.setUpdateSelectionOnEnter(true);
		tableCombo_matface.setShowTableHeader(true);
		
		tableComboVwr_facademat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_facademat.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboVwr_facademat.setInput(materials);
		tableComboVwr_facademat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_facademat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						String imagePath = mat.getImage();
						SceneTexture texture = null;
						if (ImageLoaderCache.isValidImagePath(imagePath)) {
							texture = ModelProvider.getTexture(imagePath);
						} else {
							imagePath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + imagePath;
							texture = ModelProvider.getTexture(imagePath);
						}
						if (texture != null) {
							preferences.setFacadeTexture(texture);
							PbrMaterial facadeMtl = preferences.getFacadeMtl();
							if (facadeMtl == null) {
								MaterialType type = MechanicDesignCreator.getInstance().getMaterialType("MDF");
								if (type == null) {
									type = MechanicDesignCreator.getInstance().getMaterialType("Bois");
								}
								facadeMtl = new PbrMaterial(type);
							}
							facadeMtl.setAlbedoMapPath(texture.getPath());
							preferences.setFacadeMtl(facadeMtl);
						}

					}
				}
			}
		});
		createMaterialButtonList(grpGroup_1,tableComboVwr_facademat);
		//
		
		Label lblMateriau = new Label(grpGroup_1, SWT.NONE);
		lblMateriau.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMateriau.setText("Caisson");
		tableComboViewer = new TableComboViewerSearch(grpGroup_1, SWT.NONE);
		TableCombo tableCombo = tableComboViewer.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo.defineColumns(StaticUiObjects.MaterialColumns);
//		tableCombo.setDisplayColumnIndex(0);
		tableCombo.setEditable(true);
		tableCombo.setUpdateSelectionOnEnter(true);
		tableCombo.setShowTableHeader(true);

		tableComboViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewer.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer.setInput(materials);
		
		tableComboViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboViewer.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						String imagePath = mat.getImage();
						SceneTexture texture = null;
						if (ImageLoaderCache.isValidImagePath(imagePath)) {
							texture = ModelProvider.getTexture(imagePath);
						} else {
							imagePath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + imagePath;
							texture = ModelProvider.getTexture(imagePath);
						}
						if (texture != null) {
							preferences.setBoxTexture(texture);
							PbrMaterial boxMtl= preferences.getBoxMtl();
							if (boxMtl == null) {
								MaterialType type = MechanicDesignCreator.getInstance().getMaterialType("MDF");
								if (type == null) {
									type = MechanicDesignCreator.getInstance().getMaterialType("Bois");
								}
								boxMtl = new PbrMaterial(type);
							}
							boxMtl.setAlbedoMapPath(texture.getPath());
							preferences.setBoxMtl(boxMtl);
						}

					}
				}
			}
		});
		createMaterialButtonList(grpGroup_1,tableComboViewer);

		//
		Label lblMatrielDeDos = new Label(grpGroup_1, SWT.NONE);
		lblMatrielDeDos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMatrielDeDos.setText("Fond");
		
		tableComboViewer_1 = new TableComboViewerSearch(grpGroup_1, SWT.NONE);
		TableCombo tableCombo_1 = tableComboViewer_1.getTableCombo();
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_1.defineColumns(StaticUiObjects.MaterialColumns);
		tableCombo_1.setEditable(true);
		tableCombo_1.setUpdateSelectionOnEnter(true);
		tableCombo_1.setShowTableHeader(true);
		tableComboViewer_1.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewer_1.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer_1.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboViewer_1.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						String imagePath = mat.getImage();
						SceneTexture texture = null;
						if (ImageLoaderCache.isValidImagePath(imagePath)) {
							texture = ModelProvider.getTexture(imagePath);
						} else {
							imagePath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + imagePath;
							texture = ModelProvider.getTexture(imagePath);
						}
						if (texture != null) {
							preferences.setBackTexture(texture);
							PbrMaterial backMtl= preferences.getBackMtl();
							if (backMtl == null) {
								MaterialType type = MechanicDesignCreator.getInstance().getMaterialType("MDF");
								if (type == null) {
									type = MechanicDesignCreator.getInstance().getMaterialType("Bois");
								}
								backMtl = new PbrMaterial(type);
							}
							backMtl.setAlbedoMapPath(texture.getPath());
							preferences.setBackMtl(backMtl);
						}
					}
				}
			}
		});
		createMaterialButtonList(grpGroup_1,tableComboViewer_1);

		//
		Composite composite_2 = new Composite(this, SWT.NONE);
		composite_2.setLayout(new GridLayout(5, false));
		composite_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		comboViewerNorthWestCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_1 = comboViewerNorthWestCorner.getCombo();
		combo_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType)comboViewerNorthWestCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 0);
			}
		});
		combo_1.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		comboViewerNorthWestCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerNorthWestCorner.setLabelProvider(new LabelProvider());
		comboViewerNorthWestCorner.setInput(CornerType.values());
		spnNorthwestL = new Spinner(composite_2, SWT.BORDER);
		spnNorthwestL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnNorthwestL.getSelection() * 0.001f;
				setCornerParameter(1, value);
			}
		});
		spnNorthwestL.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		spnNorthwestL.setMaximum(100000000);

		btnNorthWall = new Button(composite_2, SWT.CHECK);
		btnNorthWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(0, btnNorthWall.getSelection());
			}
		});
		btnNorthWall.setLayoutData(new GridData(SWT.CENTER, SWT.TOP, false, false, 1, 1));
		
		spnNorthEastL = new Spinner(composite_2, SWT.BORDER);
		spnNorthEastL.setMaximum(100000);
		spnNorthEastL.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		spnNorthEastL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnNorthEastL.getSelection() * 0.001f;
				setCornerParameter(3, value);
			}
		});
		
		comboViewerNorthEastCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo = comboViewerNorthEastCorner.getCombo();
		combo.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType)comboViewerNorthWestCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 3);
			}
		});
		combo.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		comboViewerNorthEastCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerNorthEastCorner.setLabelProvider(new LabelProvider());
		comboViewerNorthEastCorner.setInput(CornerType.values());
		spnNorthwestH = new Spinner(composite_2, SWT.BORDER);
		spnNorthwestH.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				 float value = spnNorthwestH.getSelection() * 0.001f;
				 setCornerParameter(0, value);
			}
		});
		spnNorthwestH.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		spnNorthwestH.setMaximum(100000000);
		compositeKitchenDraw = new Composite(composite_2, SWT.NONE);
		compositeKitchenDraw.setLayout(new FillLayout(SWT.HORIZONTAL));
		compositeKitchenDraw.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 3));
		kitchendraw=new KitchenDraw2D(compositeKitchenDraw, SWT.NONE,this.creator.getKitchenShapeBuilder());
		kitchendraw.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		spnNorthEastH = new Spinner(composite_2, SWT.BORDER | SWT.WRAP);
		spnNorthEastH.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		spnNorthEastH.setMaximum(100000000);
		spnNorthEastH.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				float value = spnNorthEastH.getSelection() * 0.001f;
				setCornerParameter(4, value);	
			}
		});
		
		btnWestWall = new Button(composite_2, SWT.CHECK);
		btnWestWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(3, btnWestWall.getSelection());
			}
		});
		btnWestWall.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, true, 1, 1));

		btnEastWall = new Button(composite_2, SWT.CHECK);
		btnEastWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(1, btnEastWall.getSelection());
			}
		});
		btnEastWall.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, true, 1, 1));
		
		spnSouthWestH = new Spinner(composite_2, SWT.BORDER);
		spnSouthWestH.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthWestH.getSelection() * 0.001f;
				setCornerParameter(10, value);	
			}
		});
		spnSouthWestH.setMaximum(100000000);
		spnSouthWestH.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));

		spnSouthEastH = new Spinner(composite_2, SWT.BORDER | SWT.WRAP);
		spnSouthEastH.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthEastH.getSelection() * 0.001f;
				setCornerParameter(6, value);	
			}
		});
		spnSouthEastH.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		spnSouthEastH.setMaximum(100000000);
		
		comboViewerSouthWestCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_2 = comboViewerSouthWestCorner.getCombo();
		combo_2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType) comboViewerSouthWestCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 9);
			}
		});
		combo_2.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));
		comboViewerSouthWestCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerSouthWestCorner.setLabelProvider(new LabelProvider());
		comboViewerSouthWestCorner.setInput(CornerType.values());

		spnSouthWestL = new Spinner(composite_2, SWT.BORDER);
		spnSouthWestL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthWestL.getSelection() * 0.001f;
				setCornerParameter(9, value);
			}
		});
		spnSouthWestL.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));
		spnSouthWestL.setMaximum(100000000);
		btnSouthWall = new Button(composite_2, SWT.CHECK);
		btnSouthWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(2, btnSouthWall.getSelection());
			}
		});
		btnSouthWall.setLayoutData(new GridData(SWT.CENTER, SWT.BOTTOM, true, false, 1, 1));	
		spnSouthEastL = new Spinner(composite_2, SWT.BORDER);
		spnSouthEastL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthEastL.getSelection() * 0.001f;
				setCornerParameter(7, value);
			}
		});
		spnSouthEastL.setMaximum(100000000);
		spnSouthEastL.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		comboViewerSouthEastCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_3 = comboViewerSouthEastCorner.getCombo();
		combo_3.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType) comboViewerSouthEastCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 6);
			}
		});
		combo_3.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		comboViewerSouthEastCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerSouthEastCorner.setLabelProvider(new LabelProvider());
		comboViewerSouthEastCorner.setInput(CornerType.values());
		tableComboViewer_1.setInput(materials);
		listener=new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				
			}
		};
		if(this.creator != null) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			m_bindingContext = initDataBindings();
//			this.creator.addPropertyChangeListener(listener);
		}
	}
	private void createMaterialButtonList(Group parent, TableComboViewer tableComboViewer2) {
		Button btnList = new Button(parent, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = 30;
		gd_btnList.heightHint = 30;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new MaterialListWindow(getShell(), null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboViewer2.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboViewer2.refresh();
				if (ret == Window.OK) {
					tableComboViewer2.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
	}
	protected void setCornerType(CornerType selection, int offset) {
		switch (selection) {
		case Rectancle:
			cornerParameters[offset + 2] = 1;
			break;
		case Angle:
			cornerParameters[offset + 2] = 0;
			break;
		case None:
			cornerParameters[offset] = 0;
			cornerParameters[offset + 1] = 0;
			cornerParameters[offset + 2] = 0;
			break;
		default:
			throw new IllegalArgumentException("Unexpected value: " + selection);
		}		
		creator.getKitchenShapeBuilder().setMiddlePoint(cornerParameters);

	}
	protected void setCornerParameter(int index, float value) {
		this.cornerParameters[index] = value;
		creator.getKitchenShapeBuilder().setMiddlePoint(cornerParameters);

	}
	protected void setEdgeSelection(int i, boolean selection) {
		int mask = 1 << i;
		if(selection) {
			this.edgeSelection |= mask;
		}else {
			this.edgeSelection &= ~mask;
		}
		creator.getKitchenShapeBuilder().setEdges(edgeSelection);
	}
	public ProjectCreator getCreator() {
		return creator;
	}

	@Override
	public void redraw() {
		super.redraw();
		if(kitchendraw != null) {
			kitchendraw.setFocus();
			kitchendraw.redraw();
		}
		
	}
	public void setCreator(ProjectCreator creator) {
		this.creator = creator;
		if(this.creator != null) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			m_bindingContext = initDataBindings();
		}
	}

	public Object getBackMaterial() {
		return backMaterial;
	}

	public void setBackMaterial(Object backMaterial) {
		this.backMaterial = backMaterial;
	}

	public Object getPrimaryMaterial() {
		return primaryMaterial;
	}

	public void setPrimaryMaterial(Object primaryMaterial) {
		this.primaryMaterial = primaryMaterial;
	}
	public void clearlistners() {
		creator.removePropertyChangeListener(listener);
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionTableComboViewer = ViewerProperties.singleSelection().observe(tableComboViewer);
		IObservableValue basematerialCreatorObserveValue = BeanProperties.value("basematerial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer, basematerialCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer_1 = ViewerProperties.singleSelection().observe(tableComboViewer_1);
		IObservableValue backmaterialCreatorObserveValue = BeanProperties.value("backmaterial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_1, backmaterialCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboVwr_facademat = ViewerProperties.singleSelection().observe(tableComboVwr_facademat);
		IObservableValue facematerialCreatorObserveValue = BeanProperties.value("facematerial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboVwr_facademat, facematerialCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
