package dressing.ui.engine3d.sceneconfig;

import java.util.Map.Entry;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.events.EventDriver;
import dressing.model.ProjectManager;
import dressing.ui.caisson.FacadeHandleConfigurer;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.object3d.DoorHandle;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Profile;
import gdxapp.scenes.SceneEvent;
import gdxapp.scenes.ScenePreferences;

public class SceneConfigurationEditorWindow extends EditorWindow {
	
	private FacadeHandleConfigurer handlePart;
	private FacadeHandleConfigurer ProfilePart;

	private WallConfigComposite wallPart;
	private ScenePreferences preferences;

	public SceneConfigurationEditorWindow(Shell parentShell, int update) {
		super(parentShell, update);
		setTitle("Configuration du scéne");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.FILL);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setLayout(new GridLayout(1, false));
		composite.setTouchEnabled(true);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_1.setLayout(new GridLayout(1, false));

		TabFolder tabFolder = new TabFolder(composite_1, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tabFolder.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));

		TabItem tbtmHandle = new TabItem(tabFolder, SWT.NONE);
		tbtmHandle.setText("Poignée");

		Composite composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmHandle.setControl(composite_2);
		composite_2.setLayout(new GridLayout(1, false));

		this.handlePart = new FacadeHandleConfigurer(composite_2,this.preferences.getDoorHandle());
		handlePart.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		for(KitchenElement element: ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
			if(element.getProfile()!=null) {
				this.ProfilePart = new FacadeHandleConfigurer(composite_2, element.getProfile().cpy());
				ProfilePart.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
				break;
			}
		}
		TabItem tbtmNewItem = new TabItem(tabFolder, SWT.NONE);
		tbtmNewItem.setText("Mur");

		Composite composite_7 = new Composite(tabFolder, SWT.NONE);
		tbtmNewItem.setControl(composite_7);
		composite_7.setLayout(new GridLayout(1, false));

		this.wallPart = new WallConfigComposite(composite_7, SWT.NONE, this.preferences);
		wallPart.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		return composite;
	}
	
	public ScenePreferences getPreferences() {
		return preferences;
	}

	public void setPreferences(ScenePreferences preferences) {
		this.preferences = preferences;
	}

	public FacadeHandleConfigurer getHandlePart() {
		return handlePart;
	}

	public WallConfigComposite getWallPart() {
		return wallPart;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		handlePart.updateDoorHandle();
		DoorHandle handle = handlePart.getDoorHandle();
		Profile profile =null;
		if(ProfilePart!=null) {
			ProfilePart.updateDoorHandle();
			profile = (Profile) ProfilePart.getDoorHandle();
		}
		
		if(handle!=null) {
			for(KitchenElement element: ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
				if(element.getDoorHandles()!=null && !element.getDoorHandles().isEmpty()) {
					for(Entry<String, DoorHandle> set : element.getDoorHandles().entrySet()) {
						set.getValue().setModelId(handle.getModelId());
						set.getValue().setMaterial(handle.getMaterial());
						set.getValue().setModel(handle.getModel());
						set.getValue().setDimension(handle.getDimension());
						set.getValue().setName(handle.getName());
						set.getValue().setPrice(handle.getPrice());
						set.getValue().setPreviewPath(handle.getPreviewPath());
					}
				}
				if(profile!=null && element.getProfile()!=null) {
					element.getProfile().setModelId(profile.getModelId());
					element.getProfile().setModel(profile.getModel());
					element.getProfile().setMaterial(profile.getMaterial());
					element.getProfile().setName(profile.getName());
					element.getProfile().setPrice(profile.getPrice());
					element.getProfile().setPreviewPath(profile.getPreviewPath());
				}
				
				element.setRequireRefrech(true);
				EventDriver.getDriver().deliverEvent(SceneEvent.OBJECT_CHANGED, element);
			}
		}
		
		finish();
		return true;
	}
	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	protected void cancel() {
		// TODO Auto-generated method stub

	}
	
	protected Point getInitialSize() {
		return new Point(1200, 720);
	}
	
	@Override
	protected boolean isMaximized() {
		return false;
	}
}
