package dressing.ui.composite;

import org.eclipse.swt.widgets.Composite;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;


import dressing.config.WorkspaceConfiguration;
import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.scenes.SceneEvent;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;

public class ObjectCreatorComposite extends Composite{
	
	
	private Color highLightColor = new Color(158, 221,255);
	private Color normalColor;

	public ObjectCreatorComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite = new Composite(this, SWT.NONE);
		
		Image imgPlinth = new Image(getDisplay(), WorkspaceConfiguration.ICONS + File.separator + "plinth.jpg");
		Image imgWall = new Image(getDisplay(), WorkspaceConfiguration.ICONS + File.separator + "create-wall.jpg");
		Image imgFloor = new Image(getDisplay(), WorkspaceConfiguration.ICONS + File.separator + "sol.jpg");
		Image imgMarble = new Image(getDisplay(), WorkspaceConfiguration.ICONS + File.separator + "plan_de_travail.jpeg");
		Image imgCeiling = null;
		try {
			imgCeiling = new Image(getDisplay(), WorkspaceConfiguration.ICONS + File.separator + "ceiling.jpg");

		}catch (Exception e) {
			e.printStackTrace();

		}

		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		composite_1.setLayout(new GridLayout(1, false));
		
		Label lblImgWall = new Label(composite_1, SWT.NONE);
		lblImgWall.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				mouseHoverHover(e);
			}
			@Override
			public void mouseExit(MouseEvent e) {
				mouseExitButton(e);
			}
		});
		lblImgWall.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				actionSelected("WALL");
			}
		});
		lblImgWall.setAlignment(SWT.CENTER);
		lblImgWall.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		lblImgWall.setImage(imgWall);
		
		Label lblWall = new Label(composite_1, SWT.CENTER);
		lblWall.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));
		lblWall.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblWall.setAlignment(SWT.CENTER);
		lblWall.setText("Murs");
		
		Composite composite_1_1 = new Composite(composite, SWT.NONE);
		composite_1_1.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));
		composite_1_1.setLayout(new GridLayout(1, false));
		
		Label lblImgFloor = new Label(composite_1_1, SWT.NONE);
		lblImgFloor.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				mouseHoverHover(e);
			}
			@Override
			public void mouseExit(MouseEvent e) {
				mouseExitButton(e);
			}
		});
		lblImgFloor.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				actionSelected("FLOOR");
			}
		});
		lblImgFloor.setAlignment(SWT.CENTER);
		lblImgFloor.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		lblImgFloor.setImage(imgFloor);
		
		Label lblNewLabel_4_1 = new Label(composite_1_1, SWT.NONE);
		lblNewLabel_4_1.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));
		lblNewLabel_4_1.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4_1.setAlignment(SWT.CENTER);
		lblNewLabel_4_1.setText("Sol");
		
		Composite composite_1_2 = new Composite(composite, SWT.NONE);
		composite_1_2.setLayout(new GridLayout(1, false));
		
		Label lblImgMarble = new Label(composite_1_2, SWT.NONE);
		lblImgMarble.setAlignment(SWT.CENTER);
		lblImgMarble.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				mouseHoverHover(e);
			}
			@Override
			public void mouseExit(MouseEvent e) {
				mouseExitButton(e);
			}
		});
		lblImgMarble.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				actionSelected("MARBLE");
			}
		});
		lblImgMarble.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		lblImgMarble.setImage(imgMarble);
		
		Label lblMarble = new Label(composite_1_2, SWT.NONE);
		lblMarble.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));
		lblMarble.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblMarble.setText("Plan de Travail");
		
		Composite composite_1_3 = new Composite(composite, SWT.NONE);
		composite_1_3.setLayout(new GridLayout(1, false));
		
		Label lblImgPlinth = new Label(composite_1_3, SWT.NONE);
		lblImgPlinth.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				mouseHoverHover(e);
			}
			@Override
			public void mouseExit(MouseEvent e) {
				mouseExitButton(e);
			}
		});
		lblImgPlinth.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				actionSelected("PLINTH");
			}
		});
		lblImgPlinth.setAlignment(SWT.CENTER);
		lblImgPlinth.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		lblImgPlinth.setImage(imgPlinth);
		
		Label lblNewLabel_4_3 = new Label(composite_1_3, SWT.NONE);
		lblNewLabel_4_3.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));
		lblNewLabel_4_3.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4_3.setText("Socle");
		
		Composite composite_1_4 = new Composite(composite, SWT.NONE);
		composite_1_4.setLayout(new GridLayout(1, false));
		
		Label ceilingLbl = new Label(composite_1_4, SWT.NONE);
		ceilingLbl.addMouseTrackListener(new MouseTrackAdapter() {
			@Override
			public void mouseHover(MouseEvent e) {
				mouseHoverHover(e);
			}
			@Override
			public void mouseExit(MouseEvent e) {
				mouseExitButton(e);
			}
		});
		ceilingLbl.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				actionSelected("CEILING");
			}
		});
		ceilingLbl.setAlignment(SWT.CENTER);
		ceilingLbl.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		ceilingLbl.setImage(imgCeiling);
		
		Label lblPlafond = new Label(composite_1_4, SWT.NONE);
		lblPlafond.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.BOLD));
		lblPlafond.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblPlafond.setText("Plafond");
	}
	
	
	public void actionSelected(String objectType) {
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.CREATE_OBJECT_CMD.name(), objectType));
	}
	
	public void mouseHoverHover(MouseEvent e) {
		if(normalColor == null)
			normalColor = ((Label)e.getSource()).getBackground();
		((Label)e.getSource()).setBackground(highLightColor);
	}
	public void mouseExitButton(MouseEvent e) {
		((Label)e.getSource()).setBackground(normalColor);
	}
}
